/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingWMSLayerInfo;
import org.geoserver.security.decorators.SecuredWMSLayer;
import org.geoserver.security.decorators.SecuredWMSStoreInfo;
import org.geotools.ows.wms.Layer;
import org.opengis.util.ProgressListener;

public class SecuredWMSLayerInfo
extends DecoratingWMSLayerInfo {
    WrapperPolicy policy;

    public SecuredWMSLayerInfo(WMSLayerInfo delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public Layer getWMSLayer(ProgressListener listener) throws IOException {
        Layer layer = super.getWMSLayer(listener);
        if (layer == null) {
            return layer;
        }
        return new SecuredWMSLayer(layer, this.policy);
    }

    @Override
    public WMSStoreInfo getStore() {
        return new SecuredWMSStoreInfo(((WMSLayerInfo)this.delegate).getStore(), this.policy);
    }

    @Override
    public void setStore(StoreInfo store) {
        super.setStore((StoreInfo)SecureCatalogImpl.unwrap((Object)store));
    }
}

