/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.config.BruteForcePreventionConfig;
import org.geoserver.security.config.SecurityConfig;
import org.geoserver.security.rememberme.RememberMeServicesConfig;

public class SecurityManagerConfig
implements SecurityConfig {
    private static final long serialVersionUID = 1L;
    private String roleServiceName;
    private List<String> authProviderNames = new ArrayList<String>();
    private String configPasswordEncrypterName;
    private boolean encryptingUrlParams;
    private GeoServerSecurityFilterChain filterChain = new GeoServerSecurityFilterChain();
    private RememberMeServicesConfig rememberMeService = new RememberMeServicesConfig();
    private BruteForcePreventionConfig bruteForcePrevention = new BruteForcePreventionConfig();

    public SecurityManagerConfig() {
    }

    public SecurityManagerConfig(SecurityManagerConfig config) {
        this.roleServiceName = config.getRoleServiceName();
        this.authProviderNames = config.getAuthProviderNames() != null ? new ArrayList<String>(config.getAuthProviderNames()) : null;
        this.filterChain = config.getFilterChain() != null ? new GeoServerSecurityFilterChain(config.getFilterChain()) : null;
        this.rememberMeService = new RememberMeServicesConfig(config.getRememberMeService());
        this.bruteForcePrevention = new BruteForcePreventionConfig(config.getBruteForcePrevention());
        this.encryptingUrlParams = config.isEncryptingUrlParams();
        this.configPasswordEncrypterName = config.getConfigPasswordEncrypterName();
    }

    private Object readResolve() {
        this.authProviderNames = this.authProviderNames != null ? this.authProviderNames : new ArrayList<String>();
        this.filterChain = this.filterChain != null ? this.filterChain : new GeoServerSecurityFilterChain();
        this.rememberMeService = this.rememberMeService != null ? this.rememberMeService : new RememberMeServicesConfig();
        this.bruteForcePrevention = this.bruteForcePrevention != null ? this.bruteForcePrevention : new BruteForcePreventionConfig();
        return this;
    }

    public String getRoleServiceName() {
        return this.roleServiceName;
    }

    public void setRoleServiceName(String roleServiceName) {
        this.roleServiceName = roleServiceName;
    }

    public List<String> getAuthProviderNames() {
        return this.authProviderNames;
    }

    public GeoServerSecurityFilterChain getFilterChain() {
        return this.filterChain;
    }

    public void setFilterChain(GeoServerSecurityFilterChain filterChain) {
        this.filterChain = filterChain;
    }

    public RememberMeServicesConfig getRememberMeService() {
        return this.rememberMeService;
    }

    public void setRememberMeService(RememberMeServicesConfig rememberMeService) {
        this.rememberMeService = rememberMeService;
    }

    public BruteForcePreventionConfig getBruteForcePrevention() {
        return this.bruteForcePrevention;
    }

    public void setBruteForcePrevention(BruteForcePreventionConfig bruteForcePrevention) {
        this.bruteForcePrevention = bruteForcePrevention;
    }

    public boolean isEncryptingUrlParams() {
        return this.encryptingUrlParams;
    }

    public void setEncryptingUrlParams(boolean encryptingUrlParams) {
        this.encryptingUrlParams = encryptingUrlParams;
    }

    public String getConfigPasswordEncrypterName() {
        return this.configPasswordEncrypterName;
    }

    public void setConfigPasswordEncrypterName(String configPasswordEncrypterName) {
        this.configPasswordEncrypterName = configPasswordEncrypterName;
    }

    @Override
    public SecurityConfig clone(boolean allowEnvParametrization) {
        GeoServerEnvironment gsEnvironment = (GeoServerEnvironment)GeoServerExtensions.bean(GeoServerEnvironment.class);
        SecurityManagerConfig target = (SecurityManagerConfig)SerializationUtils.clone((Serializable)this);
        if (target != null && allowEnvParametrization && gsEnvironment != null && GeoServerEnvironment.ALLOW_ENV_PARAMETRIZATION) {
            target.setConfigPasswordEncrypterName((String)gsEnvironment.resolveValue((Object)this.configPasswordEncrypterName));
            target.setRoleServiceName((String)gsEnvironment.resolveValue((Object)this.roleServiceName));
        }
        return target;
    }
}

