/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.config.SecurityConfig;
import org.geotools.util.logging.Logging;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public class BruteForcePreventionConfig
implements SecurityConfig {
    static final Logger LOGGER = Logging.getLogger(BruteForcePreventionConfig.class);
    private static final long serialVersionUID = 5774047555637121124L;
    public static final BruteForcePreventionConfig DEFAULT = new BruteForcePreventionConfig();
    boolean enabled;
    int minDelaySeconds;
    int maxDelaySeconds;
    int maxBlockedThreads;
    List<String> whitelistedMasks;
    transient List<IpAddressMatcher> whitelistedAddressMatchers;

    public BruteForcePreventionConfig() {
        this.enabled = true;
        this.minDelaySeconds = 1;
        this.maxDelaySeconds = 5;
        this.whitelistedMasks = new ArrayList<String>();
        this.whitelistedMasks.add("127.0.0.1");
        this.maxBlockedThreads = 100;
    }

    public BruteForcePreventionConfig(BruteForcePreventionConfig other) {
        this.enabled = other.enabled;
        this.minDelaySeconds = other.minDelaySeconds;
        this.maxDelaySeconds = other.maxDelaySeconds;
        this.whitelistedMasks = other.whitelistedMasks != null ? new ArrayList<String>(other.whitelistedMasks) : null;
        this.maxBlockedThreads = other.maxBlockedThreads;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getMinDelaySeconds() {
        return this.minDelaySeconds;
    }

    public void setMinDelaySeconds(int minConfig) {
        this.minDelaySeconds = minConfig;
    }

    public int getMaxDelaySeconds() {
        return this.maxDelaySeconds;
    }

    public void setMaxDelaySeconds(int maxConfig) {
        this.maxDelaySeconds = maxConfig;
    }

    public List<String> getWhitelistedMasks() {
        return this.whitelistedMasks;
    }

    public void setWhitelistedMasks(List<String> whitelistedMasks) {
        this.whitelistedMasks = whitelistedMasks;
        if (whitelistedMasks == null) {
            this.whitelistedAddressMatchers = null;
        }
    }

    public List<IpAddressMatcher> getWhitelistAddressMatchers() {
        try {
            if (this.getWhitelistedMasks() != null && this.whitelistedAddressMatchers == null) {
                this.whitelistedAddressMatchers = this.whitelistedMasks.stream().map(mask -> new IpAddressMatcher(mask)).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Invalid netmask configuration, will skip it", e);
        }
        return this.whitelistedAddressMatchers;
    }

    public int getMaxBlockedThreads() {
        return this.maxBlockedThreads;
    }

    public void setMaxBlockedThreads(int maxBlockedThreads) {
        this.maxBlockedThreads = maxBlockedThreads;
    }

    @Override
    public SecurityConfig clone(boolean allowEnvParametrization) {
        BruteForcePreventionConfig clone = new BruteForcePreventionConfig(this);
        GeoServerEnvironment gsEnvironment = (GeoServerEnvironment)GeoServerExtensions.bean(GeoServerEnvironment.class);
        if (clone != null && allowEnvParametrization && gsEnvironment != null && GeoServerEnvironment.ALLOW_ENV_PARAMETRIZATION) {
            ArrayList<String> resolvedMasks = new ArrayList<String>();
            for (String mask : this.whitelistedMasks) {
                String resolved = (String)gsEnvironment.resolveValue((Object)mask);
                if (resolved == null) continue;
                Arrays.stream(resolved.split("\\s*,\\s*")).filter(s -> s != null && !s.trim().isEmpty()).forEach(s -> resolvedMasks.add((String)s));
            }
            clone.setWhitelistedMasks(resolvedMasks);
        }
        return clone;
    }
}

