/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.impl.GeoServerRole;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class GeoServerRootAuthenticationProvider
extends GeoServerAuthenticationProvider {
    public GeoServerRootAuthenticationProvider() {
        this.setName("root");
    }

    @Override
    public boolean supports(Class<? extends Object> authentication, HttpServletRequest request) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    @Override
    public Authentication authenticate(Authentication authentication, HttpServletRequest request) throws AuthenticationException {
        UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)authentication;
        if (!"root".equals(token.getPrincipal())) {
            return null;
        }
        if (token.getCredentials() != null && this.getSecurityManager().checkMasterPassword(token.getCredentials().toString())) {
            ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
            roles.add(GeoServerRole.ADMIN_ROLE);
            UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)"root", null, roles);
            result.setDetails(token.getDetails());
            return result;
        }
        this.log((AuthenticationException)new BadCredentialsException("Bad credentials for: " + token.getPrincipal()));
        return null;
    }
}

