/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogCapabilities;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.ValidationResult;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.impl.AbstractDecorator;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.AdminRequest;
import org.geoserver.security.CatalogFilterAccessManager;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.DataAccessManagerAdapter;
import org.geoserver.security.DataAccessManagerWrapper;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.SecureCatalogFacade;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingCatalogFactory;
import org.geoserver.security.decorators.SecuredCoverageInfo;
import org.geoserver.security.decorators.SecuredCoverageStoreInfo;
import org.geoserver.security.decorators.SecuredDataStoreInfo;
import org.geoserver.security.decorators.SecuredFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredLayerGroupInfo;
import org.geoserver.security.decorators.SecuredLayerInfo;
import org.geoserver.security.decorators.SecuredObjects;
import org.geoserver.security.decorators.SecuredWMSLayerInfo;
import org.geoserver.security.decorators.SecuredWMSStoreInfo;
import org.geoserver.security.decorators.SecuredWMTSLayerInfo;
import org.geoserver.security.decorators.SecuredWMTSStoreInfo;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.DefaultResourceAccessManager;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class SecureCatalogImpl
extends AbstractDecorator<Catalog>
implements Catalog {
    protected ResourceAccessManager accessManager;

    public SecureCatalogImpl(Catalog catalog) throws Exception {
        this(catalog, SecureCatalogImpl.lookupResourceAccessManager());
    }

    @Override
    public String getId() {
        return ((Catalog)this.delegate).getId();
    }

    public ResourceAccessManager getResourceAccessManager() {
        return this.accessManager;
    }

    static ResourceAccessManager lookupResourceAccessManager() throws Exception {
        ResourceAccessManager manager = (ResourceAccessManager)GeoServerExtensions.bean(ResourceAccessManager.class);
        if (manager == null) {
            DataAccessManager daManager = SecureCatalogImpl.lookupDataAccessManager();
            manager = daManager == null ? SecureCatalogImpl.buildDefaultResourceAccessManager() : new DataAccessManagerAdapter(daManager);
        }
        CatalogFilterAccessManager lwManager = new CatalogFilterAccessManager();
        lwManager.setDelegate(manager);
        return lwManager;
    }

    private static DefaultResourceAccessManager buildDefaultResourceAccessManager() {
        return new DefaultResourceAccessManager((DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class), (Catalog)GeoServerExtensions.bean((String)"rawCatalog"));
    }

    static DataAccessManager lookupDataAccessManager() throws Exception {
        DataAccessManager manager = (DataAccessManager)GeoServerExtensions.bean(DataAccessManager.class);
        if (manager != null && manager instanceof DataAccessManagerWrapper) {
            ((DataAccessManagerWrapper)manager).setDelegate(SecureCatalogImpl.buildDefaultResourceAccessManager());
        }
        return manager;
    }

    public SecureCatalogImpl(Catalog catalog, ResourceAccessManager manager) {
        super(catalog);
        this.accessManager = manager;
    }

    @Override
    public CoverageInfo getCoverage(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverage(id), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public CoverageInfo getCoverageByName(String ns, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageByName(ns, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public CoverageInfo getCoverageByName(NamespaceInfo ns, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageByName(ns, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public CoverageInfo getCoverageByName(Name name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageByName(name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public CoverageInfo getCoverageByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageByName(name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public List<CoverageInfo> getCoverages() {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverages());
    }

    @Override
    public List<CoverageInfo> getCoveragesByNamespace(NamespaceInfo namespace) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoveragesByNamespace(namespace));
    }

    @Override
    public List<CoverageInfo> getCoveragesByCoverageStore(CoverageStoreInfo store) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoveragesByCoverageStore(store));
    }

    @Override
    public CoverageInfo getCoverageByCoverageStore(CoverageStoreInfo coverageStore, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageByCoverageStore(coverageStore, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public List<CoverageInfo> getCoveragesByStore(CoverageStoreInfo store) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoveragesByStore(store));
    }

    @Override
    public CoverageStoreInfo getCoverageStore(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStore(id), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStoreByName(name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(String workspaceName, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStoreByName(workspaceName, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(WorkspaceInfo workspace, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStoreByName(workspace, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(String workspaceName) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStoresByWorkspace(workspaceName));
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(WorkspaceInfo workspace) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStoresByWorkspace(workspace));
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStores() {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getCoverageStores());
    }

    @Override
    public DataStoreInfo getDataStore(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStore(id), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public DataStoreInfo getDataStoreByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStoreByName(name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public DataStoreInfo getDataStoreByName(String workspaceName, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStoreByName(workspaceName, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public DataStoreInfo getDataStoreByName(WorkspaceInfo workspace, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStoreByName(workspace, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public List<DataStoreInfo> getDataStoresByWorkspace(String workspaceName) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStoresByWorkspace(workspaceName));
    }

    @Override
    public List<DataStoreInfo> getDataStoresByWorkspace(WorkspaceInfo workspace) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStoresByWorkspace(workspace));
    }

    @Override
    public List<DataStoreInfo> getDataStores() {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDataStores());
    }

    @Override
    public NamespaceInfo getDefaultNamespace() {
        return ((Catalog)this.delegate).getDefaultNamespace();
    }

    @Override
    public WorkspaceInfo getDefaultWorkspace() {
        return ((Catalog)this.delegate).getDefaultWorkspace();
    }

    @Override
    public FeatureTypeInfo getFeatureType(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureType(id), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(String ns, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypeByName(ns, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(NamespaceInfo ns, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypeByName(ns, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(Name name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypeByName(name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypeByName(name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypes() {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypes());
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypesByNamespace(NamespaceInfo namespace) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypesByNamespace(namespace));
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByStore(DataStoreInfo dataStore, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypeByStore(dataStore, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByDataStore(DataStoreInfo dataStore, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypeByDataStore(dataStore, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypesByStore(DataStoreInfo store) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypesByStore(store));
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypesByDataStore(DataStoreInfo store) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getFeatureTypesByDataStore(store));
    }

    @Override
    public LayerInfo getLayer(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayer(id), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public LayerInfo getLayerByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerByName(name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public LayerInfo getLayerByName(Name name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerByName(name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public LayerGroupInfo getLayerGroup(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerGroup(id), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerGroupByName(name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String workspaceName, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerGroupByName(workspaceName, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(WorkspaceInfo workspace, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerGroupByName(workspace, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public List<LayerGroupInfo> getLayerGroups() {
        return this.filterGroups(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerGroups());
    }

    @Override
    public List<LayerGroupInfo> getLayerGroupsByWorkspace(String workspaceName) {
        return this.filterGroups(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerGroupsByWorkspace(workspaceName));
    }

    @Override
    public List<LayerGroupInfo> getLayerGroupsByWorkspace(WorkspaceInfo workspace) {
        return this.filterGroups(SecureCatalogImpl.user(), ((Catalog)this.delegate).getLayerGroupsByWorkspace(workspace));
    }

    @Override
    public List<LayerInfo> getLayers() {
        return this.filterLayers(Predicates.acceptAll());
    }

    @Override
    public List<LayerInfo> getLayers(ResourceInfo resource) {
        return this.filterLayers(Predicates.equal("resource.id", resource.getId()));
    }

    @Override
    public List<LayerInfo> getLayers(StyleInfo style) {
        String id = style.getId();
        Filter filter = Predicates.or(Predicates.equal("defaultStyle.id", id), Predicates.equal("styles.id", id));
        return this.filterLayers(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LayerInfo> filterLayers(Filter filter) {
        try (CloseableIterator<LayerInfo> iterator = this.list(LayerInfo.class, filter);){
            ImmutableList immutableList = ImmutableList.copyOf(iterator);
            return immutableList;
        }
    }

    @Override
    public NamespaceInfo getNamespace(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getNamespace(id), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public NamespaceInfo getNamespaceByPrefix(String prefix) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getNamespaceByPrefix(prefix), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public NamespaceInfo getNamespaceByURI(String uri) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getNamespaceByURI(uri), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public List<NamespaceInfo> getNamespaces() {
        return this.filterNamespaces(SecureCatalogImpl.user(), ((Catalog)this.delegate).getNamespaces());
    }

    @Override
    public <T extends ResourceInfo> T getResource(String id, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResource(id, clazz), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(Name name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourceByName(name, clazz), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourceByName(name, clazz), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(NamespaceInfo ns, String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourceByName(ns, name, clazz), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(String ns, String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourceByName(ns, name, clazz), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public <T extends ResourceInfo> List<T> getResources(Class<T> clazz) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResources(clazz));
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByNamespace(NamespaceInfo namespace, Class<T> clazz) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourcesByNamespace(namespace, clazz));
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByNamespace(String namespace, Class<T> clazz) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourcesByNamespace(namespace, clazz));
    }

    @Override
    public <T extends ResourceInfo> T getResourceByStore(StoreInfo store, String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourceByStore(store, name, clazz), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByStore(StoreInfo store, Class<T> clazz) {
        return this.filterResources(SecureCatalogImpl.user(), ((Catalog)this.delegate).getResourcesByStore(store, clazz));
    }

    @Override
    public <T extends StoreInfo> T getStore(String id, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStore(id, clazz), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStoreByName(name, clazz), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(String workspaceName, String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStoreByName(workspaceName, name, clazz), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(WorkspaceInfo workspace, String name, Class<T> clazz) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStoreByName(workspace, name, clazz), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public <T extends StoreInfo> List<T> getStores(Class<T> clazz) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStores(clazz));
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(String workspaceName, Class<T> clazz) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStoresByWorkspace(workspaceName, clazz));
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(WorkspaceInfo workspace, Class<T> clazz) {
        return this.filterStores(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStoresByWorkspace(workspace, clazz));
    }

    @Override
    public WorkspaceInfo getWorkspace(String id) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getWorkspace(id), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public WorkspaceInfo getWorkspaceByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getWorkspaceByName(name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public List<WorkspaceInfo> getWorkspaces() {
        return this.filterWorkspaces(SecureCatalogImpl.user(), ((Catalog)this.delegate).getWorkspaces());
    }

    protected static Authentication user() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    protected <T extends CatalogInfo> T checkAccess(Authentication user, T info, MixedModeBehavior mixedModeBehavior) {
        if (info instanceof WorkspaceInfo) {
            return (T)this.checkAccess(user, (WorkspaceInfo)info, mixedModeBehavior);
        }
        if (info instanceof NamespaceInfo) {
            return (T)this.checkAccess(user, (NamespaceInfo)info, mixedModeBehavior);
        }
        if (info instanceof StoreInfo) {
            return (T)this.checkAccess(user, (StoreInfo)info, mixedModeBehavior);
        }
        if (info instanceof ResourceInfo) {
            return (T)this.checkAccess(user, (ResourceInfo)info, mixedModeBehavior);
        }
        if (info instanceof LayerInfo) {
            return (T)this.checkAccess(user, (LayerInfo)info, mixedModeBehavior, Collections.emptyList());
        }
        if (info instanceof LayerGroupInfo) {
            return (T)this.checkAccess(user, (LayerGroupInfo)info, mixedModeBehavior, Collections.emptyList());
        }
        return info;
    }

    protected <T extends PublishedInfo> T checkAccess(Authentication user, T info, MixedModeBehavior mixedModeBehavior, List<LayerGroupInfo> containers) {
        if (info instanceof LayerInfo) {
            return (T)this.checkAccess(user, (LayerInfo)info, mixedModeBehavior, containers);
        }
        if (info instanceof LayerGroupInfo) {
            return (T)this.checkAccess(user, (LayerGroupInfo)info, mixedModeBehavior, containers);
        }
        return info;
    }

    protected <T extends ResourceInfo> T checkAccess(Authentication user, T info, MixedModeBehavior mixedModeBehavior) {
        if (info == null) {
            return null;
        }
        WrapperPolicy policy = this.buildWrapperPolicy(user, info, info.getName(), mixedModeBehavior);
        if (policy.level == AccessLevel.HIDDEN) {
            return null;
        }
        if (policy.level == AccessLevel.READ_WRITE && policy.getLimits() == null) {
            return info;
        }
        return (T)((ResourceInfo)SecuredObjects.secure(info, policy));
    }

    protected StyleInfo checkAccess(Authentication user, StyleInfo style, MixedModeBehavior mixedModeBehavior) {
        if (style == null) {
            return null;
        }
        WrapperPolicy policy = this.buildWrapperPolicy(user, style, style.getName(), mixedModeBehavior);
        if (policy.level == AccessLevel.HIDDEN) {
            return null;
        }
        return style;
    }

    protected <T extends StoreInfo> T checkAccess(Authentication user, T store, MixedModeBehavior mixedModeBehavior) {
        if (store == null) {
            return null;
        }
        WrapperPolicy policy = this.buildWrapperPolicy(user, store.getWorkspace(), store.getName(), mixedModeBehavior);
        if (policy.level == AccessLevel.HIDDEN) {
            return null;
        }
        if (policy.level == AccessLevel.READ_WRITE || policy.level == AccessLevel.READ_ONLY && store instanceof CoverageStoreInfo) {
            return store;
        }
        if (store instanceof DataStoreInfo || store instanceof CoverageStoreInfo || store instanceof WMSStoreInfo || store instanceof WMTSStoreInfo) {
            return (T)((StoreInfo)SecuredObjects.secure(store, policy));
        }
        throw new RuntimeException("Unknown store type " + store.getClass());
    }

    protected LayerInfo checkAccess(Authentication user, LayerInfo layer, MixedModeBehavior mixedModeBehavior, List<LayerGroupInfo> containers) {
        if (layer == null) {
            return null;
        }
        WrapperPolicy policy = this.buildWrapperPolicy(user, layer, layer.getName(), mixedModeBehavior, containers);
        if (policy.level == AccessLevel.HIDDEN) {
            return null;
        }
        if (policy.level == AccessLevel.READ_WRITE && policy.getLimits() == null) {
            return layer;
        }
        return (LayerInfo)SecuredObjects.secure(layer, policy);
    }

    protected LayerGroupInfo checkAccess(Authentication user, LayerGroupInfo group, MixedModeBehavior mixedModeBehavior, List<LayerGroupInfo> containers) {
        if (group == null) {
            return null;
        }
        WrapperPolicy policy = this.buildWrapperPolicy(user, group, group.getName(), mixedModeBehavior, containers);
        if (policy.level == AccessLevel.HIDDEN) {
            return null;
        }
        LayerInfo rootLayer = group.getRootLayer();
        if (LayerGroupInfo.Mode.EO.equals((Object)group.getMode()) && (rootLayer = this.checkAccess(user, rootLayer, MixedModeBehavior.CHALLENGE)) == null) {
            return null;
        }
        ArrayList<LayerGroupInfo> extendedContainers = new ArrayList<LayerGroupInfo>(containers);
        extendedContainers.add(group);
        List<PublishedInfo> layers = group.getLayers();
        List<StyleInfo> styles = group.getStyles();
        ArrayList<StyleInfo> selectedStyles = new ArrayList<StyleInfo>(layers.size());
        ArrayList<PublishedInfo> wrapped = new ArrayList<PublishedInfo>(layers.size());
        for (int i = 0; i < layers.size(); ++i) {
            StyleInfo styleGroup;
            PublishedInfo layer = layers.get(i);
            StyleInfo style = styles != null && styles.size() > i ? styles.get(i) : null;
            PublishedInfo checked = this.checkAccess(user, layer, MixedModeBehavior.HIDE, extendedContainers);
            if (checked != null) {
                wrapped.add(checked);
                selectedStyles.add(style);
                continue;
            }
            if (layer != null || (styleGroup = this.checkAccess(user, style, MixedModeBehavior.HIDE)) == null) continue;
            wrapped.add(null);
            selectedStyles.add(styleGroup);
        }
        return new SecuredLayerGroupInfo(group, rootLayer, wrapped, selectedStyles);
    }

    protected <T extends NamespaceInfo> T checkAccess(Authentication user, T ns, MixedModeBehavior mixedModeBehavior) {
        WorkspaceInfo info;
        if (ns == null) {
            return null;
        }
        WorkspaceInfo ws = ((Catalog)this.delegate).getWorkspaceByName(ns.getPrefix());
        if (ws == null) {
            ws = ((Catalog)this.delegate).getFactory().createWorkspace();
            ws.setName(ns.getPrefix());
        }
        if ((info = this.checkAccess(user, ws, mixedModeBehavior)) == null) {
            return null;
        }
        return ns;
    }

    protected <T extends WorkspaceInfo> T checkAccess(Authentication user, T ws, MixedModeBehavior mixedModeBehavior) {
        if (ws == null) {
            return null;
        }
        WrapperPolicy policy = this.buildWrapperPolicy(user, ws, ws.getName(), mixedModeBehavior);
        if (policy.level == AccessLevel.HIDDEN) {
            return null;
        }
        return ws;
    }

    WrapperPolicy buildWrapperPolicy(@Nonnull ResourceAccessManager accessManager, Authentication user, @Nonnull CatalogInfo info, MixedModeBehavior mixedModeBehavior) {
        Assert.notNull((Object)info);
        if (info instanceof NamespaceInfo) {
            WorkspaceInfo ws = ((Catalog)this.delegate).getWorkspaceByName(((NamespaceInfo)info).getPrefix());
            if (ws == null) {
                ws = ((Catalog)this.delegate).getFactory().createWorkspace();
                ws.setName(((NamespaceInfo)info).getPrefix());
            }
            return SecureCatalogImpl.buildWrapperPolicy(accessManager, user, ws, ws.getName(), mixedModeBehavior);
        }
        if (info instanceof WorkspaceInfo) {
            return SecureCatalogImpl.buildWrapperPolicy(accessManager, user, info, ((WorkspaceInfo)info).getName(), mixedModeBehavior);
        }
        if (info instanceof StoreInfo) {
            return SecureCatalogImpl.buildWrapperPolicy(accessManager, user, ((StoreInfo)info).getWorkspace(), ((StoreInfo)info).getName(), mixedModeBehavior);
        }
        if (info instanceof ResourceInfo) {
            return SecureCatalogImpl.buildWrapperPolicy(accessManager, user, info, ((ResourceInfo)info).getName(), mixedModeBehavior);
        }
        if (info instanceof LayerInfo) {
            return SecureCatalogImpl.buildWrapperPolicy(accessManager, user, info, ((LayerInfo)info).getName(), mixedModeBehavior);
        }
        if (info instanceof LayerGroupInfo) {
            WrapperPolicy mostRestrictive = WrapperPolicy.readWrite(null);
            for (PublishedInfo layer : ((LayerGroupInfo)info).getLayers()) {
                WrapperPolicy policy = SecureCatalogImpl.buildWrapperPolicy(accessManager, user, layer, layer.getName(), mixedModeBehavior);
                if (AccessLevel.HIDDEN.equals((Object)policy.getAccessLevel())) {
                    return policy;
                }
                int comparison = policy.compareTo(mostRestrictive);
                boolean thisOneIsMoreRestrictive = comparison < 0;
                if (!thisOneIsMoreRestrictive) continue;
                mostRestrictive = policy;
            }
            return mostRestrictive;
        }
        if (info instanceof StyleInfo) {
            return SecureCatalogImpl.buildWrapperPolicy(accessManager, user, info, ((StyleInfo)info).getName(), mixedModeBehavior);
        }
        throw new IllegalArgumentException("Can't build wrapper policy for objects of type " + info.getClass().getName());
    }

    protected WrapperPolicy buildWrapperPolicy(Authentication user, @Nonnull CatalogInfo info, MixedModeBehavior mixedModeBehavior) {
        return this.buildWrapperPolicy(this.accessManager, user, info, mixedModeBehavior);
    }

    public WrapperPolicy buildWrapperPolicy(Authentication user, CatalogInfo info, String resourceName, MixedModeBehavior mixedModeBehavior) {
        return SecureCatalogImpl.buildWrapperPolicy(this.accessManager, user, info, resourceName, mixedModeBehavior, Collections.emptyList());
    }

    public WrapperPolicy buildWrapperPolicy(Authentication user, CatalogInfo info, String resourceName, MixedModeBehavior mixedModeBehavior, List<LayerGroupInfo> containers) {
        return SecureCatalogImpl.buildWrapperPolicy(this.accessManager, user, info, resourceName, mixedModeBehavior, containers);
    }

    static WrapperPolicy buildWrapperPolicy(ResourceAccessManager accessManager, Authentication user, CatalogInfo info, String resourceName, MixedModeBehavior mixedModeBehavior) {
        return SecureCatalogImpl.buildWrapperPolicy(accessManager, user, info, resourceName, mixedModeBehavior, Collections.emptyList());
    }

    static WrapperPolicy buildWrapperPolicy(ResourceAccessManager accessManager, Authentication user, CatalogInfo info, String resourceName, MixedModeBehavior mixedModeBehavior, List<LayerGroupInfo> containers) {
        CatalogMode mode;
        AccessLimits limits;
        boolean canRead = true;
        boolean canWrite = true;
        if (info instanceof WorkspaceInfo) {
            limits = accessManager.getAccessLimits(user, (WorkspaceInfo)info);
            WorkspaceAccessLimits wl = limits;
            if (wl != null) {
                if (wl.isAdminable()) {
                    canWrite = true;
                    canRead = true;
                } else {
                    canRead = wl.isReadable();
                    canWrite = wl.isWritable();
                }
            }
            if (!(AdminRequest.get() == null || wl != null && wl.isAdminable())) {
                canWrite = false;
                canRead = false;
            }
        } else if (info instanceof LayerInfo || info instanceof ResourceInfo) {
            WorkspaceAccessLimits wl;
            DataAccessLimits dl;
            if (info instanceof LayerInfo) {
                dl = accessManager.getAccessLimits(user, (LayerInfo)info, containers);
                wl = accessManager.getAccessLimits(user, ((LayerInfo)info).getResource().getStore().getWorkspace());
            } else {
                dl = accessManager.getAccessLimits(user, (ResourceInfo)info);
                wl = accessManager.getAccessLimits(user, ((ResourceInfo)info).getStore().getWorkspace());
            }
            if (dl != null) {
                boolean bl = canRead = dl.getReadFilter() != Filter.EXCLUDE;
                canWrite = dl instanceof VectorAccessLimits ? ((VectorAccessLimits)dl).getWriteFilter() != Filter.EXCLUDE : false;
            }
            limits = dl;
            if (AdminRequest.get() != null && wl != null && !wl.isAdminable()) {
                canRead = false;
            }
        } else if (info instanceof StyleInfo || info instanceof LayerGroupInfo) {
            WorkspaceAccessLimits wl;
            WorkspaceInfo ws = null;
            if (info instanceof StyleInfo) {
                limits = accessManager.getAccessLimits(user, (StyleInfo)info);
                ws = ((StyleInfo)info).getWorkspace();
            } else {
                limits = accessManager.getAccessLimits(user, (LayerGroupInfo)info, containers);
                ws = ((LayerGroupInfo)info).getWorkspace();
            }
            if (limits != null) {
                canRead = false;
            }
            if (ws != null && AdminRequest.get() != null && (wl = accessManager.getAccessLimits(user, ws)) != null && !wl.isAdminable()) {
                canRead = false;
            }
        } else {
            throw new IllegalArgumentException("Can't build the wrapper policy for objects other than workspace, layer or resource: " + info);
        }
        CatalogMode catalogMode = mode = limits != null ? limits.getMode() : CatalogMode.HIDE;
        if (!canRead) {
            if (mode == CatalogMode.HIDE) {
                return WrapperPolicy.hide(limits);
            }
            if (mode == CatalogMode.MIXED) {
                if (mixedModeBehavior == MixedModeBehavior.HIDE) {
                    return WrapperPolicy.hide(limits);
                }
                throw SecureCatalogImpl.unauthorizedAccess(resourceName);
            }
            return WrapperPolicy.metadata(limits);
        }
        if (!canWrite) {
            if (mode == CatalogMode.HIDE) {
                return WrapperPolicy.readOnlyHide(limits);
            }
            return WrapperPolicy.readOnlyChallenge(limits);
        }
        return WrapperPolicy.readWrite(limits);
    }

    public static RuntimeException unauthorizedAccess(String resourceName) {
        Authentication user = SecureCatalogImpl.user();
        if (user == null || user.getAuthorities().size() == 0) {
            return new InsufficientAuthenticationException("Cannot access " + resourceName + " as anonymous");
        }
        return new AccessDeniedException("Cannot access " + resourceName + " with the current privileges");
    }

    public static RuntimeException unauthorizedAccess() {
        Authentication user = SecureCatalogImpl.user();
        if (user == null || user.getAuthorities().size() == 0) {
            return new InsufficientAuthenticationException("Operation unallowed with the current privileges");
        }
        return new AccessDeniedException("Operation unallowed with the current privileges");
    }

    protected <T extends ResourceInfo> List<T> filterResources(Authentication user, List<T> resources) {
        ArrayList<ResourceInfo> result = new ArrayList<ResourceInfo>();
        for (ResourceInfo original : resources) {
            ResourceInfo secured = this.checkAccess(user, original, MixedModeBehavior.HIDE);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    protected <T extends StoreInfo> List<T> filterStores(Authentication user, List<T> resources) {
        ArrayList<StoreInfo> result = new ArrayList<StoreInfo>();
        for (StoreInfo original : resources) {
            StoreInfo secured = this.checkAccess(user, original, MixedModeBehavior.HIDE);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    protected List<LayerGroupInfo> filterGroups(Authentication user, List<LayerGroupInfo> groups) {
        ArrayList<LayerGroupInfo> result = new ArrayList<LayerGroupInfo>();
        for (LayerGroupInfo original : groups) {
            LayerGroupInfo secured = this.checkAccess(user, original, MixedModeBehavior.HIDE);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    protected List<LayerInfo> filterLayers(Authentication user, List<LayerInfo> layers) {
        ArrayList<LayerInfo> result = new ArrayList<LayerInfo>();
        for (LayerInfo original : layers) {
            LayerInfo secured = this.checkAccess(user, original, MixedModeBehavior.HIDE);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    protected List<StyleInfo> filterStyles(Authentication user, List<StyleInfo> styles) {
        ArrayList<StyleInfo> result = new ArrayList<StyleInfo>();
        for (StyleInfo original : styles) {
            StyleInfo secured = this.checkAccess(user, original, MixedModeBehavior.HIDE);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    protected <T extends NamespaceInfo> List<T> filterNamespaces(Authentication user, List<T> namespaces) {
        ArrayList<NamespaceInfo> result = new ArrayList<NamespaceInfo>();
        for (NamespaceInfo original : namespaces) {
            NamespaceInfo secured = this.checkAccess(user, original, MixedModeBehavior.HIDE);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    protected <T extends WorkspaceInfo> List<T> filterWorkspaces(Authentication user, List<T> workspaces) {
        ArrayList<WorkspaceInfo> result = new ArrayList<WorkspaceInfo>();
        for (WorkspaceInfo original : workspaces) {
            WorkspaceInfo secured = this.checkAccess(user, original, MixedModeBehavior.HIDE);
            if (secured == null) continue;
            result.add(secured);
        }
        return result;
    }

    static LayerGroupInfo unwrap(LayerGroupInfo layerGroup) {
        if (layerGroup instanceof SecuredLayerGroupInfo) {
            return (LayerGroupInfo)((SecuredLayerGroupInfo)layerGroup).unwrap(LayerGroupInfo.class);
        }
        return layerGroup;
    }

    static LayerInfo unwrap(LayerInfo layer) {
        if (layer instanceof SecuredLayerInfo) {
            return (LayerInfo)((SecuredLayerInfo)layer).unwrap(LayerInfo.class);
        }
        return layer;
    }

    static ResourceInfo unwrap(ResourceInfo info) {
        if (info instanceof SecuredFeatureTypeInfo) {
            return (ResourceInfo)((SecuredFeatureTypeInfo)info).unwrap(ResourceInfo.class);
        }
        if (info instanceof SecuredCoverageInfo) {
            return (ResourceInfo)((SecuredCoverageInfo)info).unwrap(ResourceInfo.class);
        }
        if (info instanceof SecuredWMSLayerInfo) {
            return (ResourceInfo)((SecuredWMSLayerInfo)info).unwrap(ResourceInfo.class);
        }
        if (info instanceof SecuredWMTSLayerInfo) {
            return (ResourceInfo)((SecuredWMTSLayerInfo)info).unwrap(ResourceInfo.class);
        }
        return info;
    }

    static StoreInfo unwrap(StoreInfo info) {
        if (info instanceof SecuredDataStoreInfo) {
            return (StoreInfo)((SecuredDataStoreInfo)info).unwrap(StoreInfo.class);
        }
        if (info instanceof SecuredCoverageStoreInfo) {
            return (StoreInfo)((SecuredCoverageStoreInfo)info).unwrap(StoreInfo.class);
        }
        if (info instanceof SecuredWMSStoreInfo) {
            return (StoreInfo)((SecuredWMSStoreInfo)info).unwrap(StoreInfo.class);
        }
        if (info instanceof SecuredWMTSStoreInfo) {
            return (StoreInfo)((SecuredWMTSStoreInfo)info).unwrap(StoreInfo.class);
        }
        return info;
    }

    public static Object unwrap(Object obj) {
        if (obj instanceof LayerGroupInfo) {
            return SecureCatalogImpl.unwrap((LayerGroupInfo)obj);
        }
        if (obj instanceof LayerInfo) {
            return SecureCatalogImpl.unwrap((LayerInfo)obj);
        }
        if (obj instanceof ResourceInfo) {
            return SecureCatalogImpl.unwrap((ResourceInfo)obj);
        }
        if (obj instanceof StoreInfo) {
            return SecureCatalogImpl.unwrap((StoreInfo)obj);
        }
        if (obj instanceof SecureCatalogImpl) {
            return ((SecureCatalogImpl)obj).delegate;
        }
        return obj;
    }

    @Override
    public MapInfo getMap(String id) {
        return ((Catalog)this.delegate).getMap(id);
    }

    @Override
    public MapInfo getMapByName(String name) {
        return ((Catalog)this.delegate).getMapByName(name);
    }

    @Override
    public List<MapInfo> getMaps() {
        return ((Catalog)this.delegate).getMaps();
    }

    @Override
    public void add(LayerGroupInfo layerGroup) {
        ((Catalog)this.delegate).add(SecureCatalogImpl.unwrap(layerGroup));
    }

    @Override
    public ValidationResult validate(LayerGroupInfo layerGroup, boolean isNew) {
        return ((Catalog)this.delegate).validate(SecureCatalogImpl.unwrap(layerGroup), isNew);
    }

    @Override
    public LayerGroupInfo detach(LayerGroupInfo layerGroup) {
        return ((Catalog)this.delegate).detach(layerGroup);
    }

    @Override
    public void add(LayerInfo layer) {
        ((Catalog)this.delegate).add(SecureCatalogImpl.unwrap(layer));
    }

    @Override
    public ValidationResult validate(LayerInfo layer, boolean isNew) {
        return ((Catalog)this.delegate).validate(SecureCatalogImpl.unwrap(layer), isNew);
    }

    @Override
    public LayerInfo detach(LayerInfo layer) {
        return ((Catalog)this.delegate).detach(layer);
    }

    @Override
    public void add(MapInfo map) {
        ((Catalog)this.delegate).add(map);
    }

    @Override
    public MapInfo detach(MapInfo map) {
        return ((Catalog)this.delegate).detach(map);
    }

    @Override
    public void add(NamespaceInfo namespace) {
        ((Catalog)this.delegate).add(namespace);
    }

    @Override
    public ValidationResult validate(NamespaceInfo namespace, boolean isNew) {
        return ((Catalog)this.delegate).validate(namespace, isNew);
    }

    @Override
    public NamespaceInfo detach(NamespaceInfo namespace) {
        return ((Catalog)this.delegate).detach(namespace);
    }

    @Override
    public void add(ResourceInfo resource) {
        ((Catalog)this.delegate).add(SecureCatalogImpl.unwrap(resource));
    }

    @Override
    public ValidationResult validate(ResourceInfo resource, boolean isNew) {
        return ((Catalog)this.delegate).validate(SecureCatalogImpl.unwrap(resource), isNew);
    }

    @Override
    public <T extends ResourceInfo> T detach(T resource) {
        return ((Catalog)this.delegate).detach(resource);
    }

    @Override
    public void add(StoreInfo store) {
        ((Catalog)this.delegate).add(SecureCatalogImpl.unwrap(store));
    }

    @Override
    public ValidationResult validate(StoreInfo store, boolean isNew) {
        return ((Catalog)this.delegate).validate(SecureCatalogImpl.unwrap(store), isNew);
    }

    @Override
    public <T extends StoreInfo> T detach(T store) {
        return ((Catalog)this.delegate).detach(store);
    }

    @Override
    public void add(StyleInfo style) {
        ((Catalog)this.delegate).add(style);
    }

    @Override
    public ValidationResult validate(StyleInfo style, boolean isNew) {
        return ((Catalog)this.delegate).validate(style, isNew);
    }

    @Override
    public StyleInfo detach(StyleInfo style) {
        return ((Catalog)this.delegate).detach(style);
    }

    @Override
    public void add(WorkspaceInfo workspace) {
        ((Catalog)this.delegate).add(workspace);
    }

    @Override
    public ValidationResult validate(WorkspaceInfo workspace, boolean isNew) {
        return ((Catalog)this.delegate).validate(workspace, isNew);
    }

    @Override
    public WorkspaceInfo detach(WorkspaceInfo workspace) {
        return ((Catalog)this.delegate).detach(workspace);
    }

    @Override
    public void addListener(CatalogListener listener) {
        ((Catalog)this.delegate).addListener(listener);
    }

    @Override
    public void dispose() {
        ((Catalog)this.delegate).dispose();
    }

    @Override
    public CatalogFacade getFacade() {
        return new SecureCatalogFacade(this, ((Catalog)this.delegate).getFacade());
    }

    @Override
    public CatalogFactory getFactory() {
        return new DecoratingCatalogFactory(((Catalog)this.delegate).getFactory()){

            @Override
            public LayerGroupInfo createLayerGroup() {
                return new SecuredLayerGroupInfo(((CatalogFactory)this.delegate).createLayerGroup(), null, new ArrayList<PublishedInfo>(), new ArrayList<StyleInfo>());
            }
        };
    }

    @Override
    public Collection<CatalogListener> getListeners() {
        return ((Catalog)this.delegate).getListeners();
    }

    @Override
    public void fireAdded(CatalogInfo object) {
        ((Catalog)this.delegate).fireAdded(object);
    }

    @Override
    public void fireModified(CatalogInfo object, List<String> propertyNames, List oldValues, List newValues) {
        ((Catalog)this.delegate).fireModified(object, propertyNames, oldValues, newValues);
    }

    @Override
    public void firePostModified(CatalogInfo object, List<String> propertyNames, List oldValues, List newValues) {
        ((Catalog)this.delegate).firePostModified(object, propertyNames, oldValues, newValues);
    }

    @Override
    public void fireRemoved(CatalogInfo object) {
        ((Catalog)this.delegate).fireRemoved(object);
    }

    @Override
    public ResourcePool getResourcePool() {
        return ((Catalog)this.delegate).getResourcePool();
    }

    @Override
    public StyleInfo getStyle(String id) {
        return ((Catalog)this.delegate).getStyle(id);
    }

    @Override
    public StyleInfo getStyleByName(String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStyleByName(name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public StyleInfo getStyleByName(String workspaceName, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStyleByName(workspaceName, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public StyleInfo getStyleByName(WorkspaceInfo workspace, String name) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStyleByName(workspace, name), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public List<StyleInfo> getStyles() {
        return this.filterStyles(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStyles());
    }

    @Override
    public List<StyleInfo> getStylesByWorkspace(String workspaceName) {
        return this.filterStyles(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStylesByWorkspace(workspaceName));
    }

    @Override
    public List<StyleInfo> getStylesByWorkspace(WorkspaceInfo workspace) {
        return this.filterStyles(SecureCatalogImpl.user(), ((Catalog)this.delegate).getStylesByWorkspace(workspace));
    }

    @Override
    public void remove(LayerGroupInfo layerGroup) {
        ((Catalog)this.delegate).remove(SecureCatalogImpl.unwrap(layerGroup));
    }

    @Override
    public void remove(LayerInfo layer) {
        ((Catalog)this.delegate).remove(SecureCatalogImpl.unwrap(layer));
    }

    @Override
    public void remove(MapInfo map) {
        ((Catalog)this.delegate).remove(map);
    }

    @Override
    public void remove(NamespaceInfo namespace) {
        ((Catalog)this.delegate).remove(namespace);
    }

    @Override
    public void remove(ResourceInfo resource) {
        ((Catalog)this.delegate).remove(SecureCatalogImpl.unwrap(resource));
    }

    @Override
    public void remove(StoreInfo store) {
        ((Catalog)this.delegate).remove(SecureCatalogImpl.unwrap(store));
    }

    @Override
    public void remove(StyleInfo style) {
        ((Catalog)this.delegate).remove(style);
    }

    @Override
    public void remove(WorkspaceInfo workspace) {
        ((Catalog)this.delegate).remove(workspace);
    }

    @Override
    public void removeListener(CatalogListener listener) {
        ((Catalog)this.delegate).removeListener(listener);
    }

    @Override
    public void save(LayerGroupInfo layerGroup) {
        ((Catalog)this.delegate).save(SecureCatalogImpl.unwrap(layerGroup));
    }

    @Override
    public void save(LayerInfo layer) {
        ((Catalog)this.delegate).save(SecureCatalogImpl.unwrap(layer));
    }

    @Override
    public void save(MapInfo map) {
        ((Catalog)this.delegate).save(map);
    }

    @Override
    public void save(NamespaceInfo namespace) {
        ((Catalog)this.delegate).save(namespace);
    }

    @Override
    public void save(ResourceInfo resource) {
        ((Catalog)this.delegate).save(SecureCatalogImpl.unwrap(resource));
    }

    @Override
    public void save(StoreInfo store) {
        ((Catalog)this.delegate).save(SecureCatalogImpl.unwrap(store));
    }

    @Override
    public void save(StyleInfo style) {
        ((Catalog)this.delegate).save(style);
    }

    @Override
    public void save(WorkspaceInfo workspace) {
        ((Catalog)this.delegate).save(workspace);
    }

    @Override
    public void setDefaultNamespace(NamespaceInfo defaultNamespace) {
        ((Catalog)this.delegate).setDefaultNamespace(defaultNamespace);
    }

    @Override
    public void setDefaultWorkspace(WorkspaceInfo workspace) {
        ((Catalog)this.delegate).setDefaultWorkspace(workspace);
    }

    @Override
    public void setResourcePool(ResourcePool resourcePool) {
        ((Catalog)this.delegate).setResourcePool(resourcePool);
    }

    @Override
    public GeoServerResourceLoader getResourceLoader() {
        return ((Catalog)this.delegate).getResourceLoader();
    }

    @Override
    public void setResourceLoader(GeoServerResourceLoader resourceLoader) {
        ((Catalog)this.delegate).setResourceLoader(resourceLoader);
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        ((Catalog)this.delegate).accept(visitor);
    }

    @Override
    public DataStoreInfo getDefaultDataStore(WorkspaceInfo workspace) {
        return this.checkAccess(SecureCatalogImpl.user(), ((Catalog)this.delegate).getDefaultDataStore(workspace), MixedModeBehavior.CHALLENGE);
    }

    @Override
    public void setDefaultDataStore(WorkspaceInfo workspace, DataStoreInfo defaultStore) {
        ((Catalog)this.delegate).setDefaultDataStore(workspace, defaultStore);
    }

    @Override
    public <T extends CatalogInfo> int count(Class<T> of, Filter filter) {
        Filter securityFilter = this.securityFilter(of, filter);
        int count = ((Catalog)this.delegate).count(of, securityFilter);
        return count;
    }

    @Override
    public <T extends CatalogInfo> T get(Class<T> type, Filter filter) throws IllegalArgumentException {
        Filter securityFilter = this.securityFilter(type, filter);
        T result = ((Catalog)this.delegate).get(type, securityFilter);
        return result;
    }

    @Override
    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter) {
        return this.list(of, filter, (Integer)null, (Integer)null, (SortBy)null);
    }

    @Override
    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter, Integer offset, Integer count, SortBy sortBy) {
        Filter securityFilter = this.securityFilter(of, filter);
        CloseableIterator<T> filtered = ((Catalog)this.delegate).list(of, securityFilter, offset, count, sortBy);
        Function<T, T> securityWrapper = this.securityWrapper(of, MixedModeBehavior.HIDE);
        CloseableIterator<T> filteredWrapped = CloseableIteratorAdapter.transform(filtered, securityWrapper);
        return CloseableIteratorAdapter.filter(filteredWrapped, com.google.common.base.Predicates.notNull());
    }

    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter, Integer offset, Integer count, SortBy ... sortBy) {
        Filter securityFilter = this.securityFilter(of, filter);
        CloseableIterator<T> filtered = ((Catalog)this.delegate).getFacade().list(of, securityFilter, offset, count, sortBy);
        Function<T, T> securityWrapper = this.securityWrapper(of, MixedModeBehavior.HIDE);
        CloseableIterator<T> filteredWrapped = CloseableIteratorAdapter.transform(filtered, securityWrapper);
        return CloseableIteratorAdapter.filter(filteredWrapped, com.google.common.base.Predicates.notNull());
    }

    private <T extends CatalogInfo> Function<T, T> securityWrapper(Class<T> forClass, final MixedModeBehavior mixedModeBehavior) {
        final Authentication user = SecureCatalogImpl.user();
        return new Function<T, T>(){

            public T apply(T input) {
                Object checked = SecureCatalogImpl.this.checkAccess(user, input, mixedModeBehavior);
                return checked;
            }
        };
    }

    private <T extends CatalogInfo> Filter securityFilter(Class<T> infoType, Filter filter) {
        Authentication user = SecureCatalogImpl.user();
        if (this.isAdmin(user)) {
            return filter;
        }
        if (MapInfo.class.isAssignableFrom(infoType)) {
            return filter;
        }
        Filter securityFilter = this.accessManager.getSecurityFilter(user, infoType);
        return Predicates.and(filter, securityFilter);
    }

    protected boolean isAdmin(Authentication authentication) {
        return ((GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class)).checkAuthenticationForAdminRole(authentication);
    }

    @Override
    public void removeListeners(Class listenerClass) {
        ((Catalog)this.delegate).removeListeners(listenerClass);
    }

    @Override
    public CatalogCapabilities getCatalogCapabilities() {
        return ((Catalog)this.delegate).getCatalogCapabilities();
    }

    public static enum MixedModeBehavior {
        HIDE,
        CHALLENGE;

    }
}

