/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

public enum HTTPMethod {
    GET("GET"),
    POST("POST"),
    HEAD("HEAD"),
    OPTIONS("OPTIONS"),
    PUT("PUT"),
    DELETE("DELETE"),
    TRACE("TRACE");

    private final String name;

    private HTTPMethod(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static HTTPMethod fromString(String method) {
        if ("GET".equals(method)) {
            return GET;
        }
        if ("POST".equals(method)) {
            return POST;
        }
        if ("HEAD".equals(method)) {
            return HEAD;
        }
        if ("OPTIONS".equals(method)) {
            return OPTIONS;
        }
        if ("PUT".equals(method)) {
            return PUT;
        }
        if ("DELETE".equals(method)) {
            return DELETE;
        }
        if ("TRACE".equals(method)) {
            return TRACE;
        }
        throw new RuntimeException("Unknown HTTP method: " + method);
    }
}

