/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.List;
import java.util.SortedSet;
import org.geoserver.security.AuthorizingUserGroupService;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.security.validation.UserGroupServiceException;

public class GroupAdminUserGroupService
extends AuthorizingUserGroupService {
    List<String> groups;

    GroupAdminUserGroupService(GeoServerUserGroupService delegate, List<String> groups) {
        super(delegate);
        this.groups = groups;
    }

    @Override
    public GeoServerUserGroupStore createStore() throws IOException {
        return new GroupAdminUserGroupService(this.delegate.createStore(), this.groups);
    }

    @Override
    public int getGroupCount() throws IOException {
        return this.groups.size();
    }

    @Override
    protected GeoServerUser filterUser(GeoServerUser user) {
        return user;
    }

    @Override
    protected GeoServerUserGroup filterGroup(GeoServerUserGroup group) {
        if (this.groups.contains(group.getGroupname())) {
            return group;
        }
        return null;
    }

    @Override
    public boolean removeUser(GeoServerUser user) throws IOException {
        this.checkUserNotInOtherGroup(user);
        return super.removeUser(user);
    }

    @Override
    public void updateUser(GeoServerUser user) throws IOException, PasswordPolicyException {
        this.checkUserNotInOtherGroup(user);
        super.updateUser(user);
    }

    void checkUserNotInOtherGroup(GeoServerUser user) throws IOException {
        SortedSet<GeoServerUserGroup> userGroups = this.delegate.getGroupsForUser(user);
        if (userGroups.isEmpty()) {
            return;
        }
        for (GeoServerUserGroup userGroup : userGroups) {
            if (this.groups.contains(userGroup.getGroupname())) continue;
            String msg = new UserGroupServiceException("USER_IN_OTHER_GROUP_NOT_MODIFIABLE", new Object[]{user}).getMessage();
            throw new IOException(msg);
        }
    }
}

