/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AbstractCatalogFilter;

public class DisabledServiceResourceFilter
extends AbstractCatalogFilter {
    private boolean isFilterSubject() {
        return this.request() != null && this.request().getService() != null && this.request().getRequest() != null;
    }

    private Request request() {
        return (Request)Dispatcher.REQUEST.get();
    }

    @Override
    public boolean hideLayer(LayerInfo layer) {
        return this.hideResource(layer.getResource());
    }

    @Override
    public boolean hideResource(ResourceInfo resource) {
        if (this.isFilterSubject()) {
            List<String> disabledServices = DisabledServiceResourceFilter.disabledServices(resource);
            String service = this.request().getService();
            return disabledServices.stream().anyMatch(s -> service.toLowerCase().equals(s.trim().toLowerCase()));
        }
        return false;
    }

    private static List<String> defaultDisabledServices() {
        List<String> list2 = null;
        String globalEnv = GeoServerExtensions.getProperty((String)"org.geoserver.service.disabled");
        if (StringUtils.isNotBlank((CharSequence)globalEnv)) {
            list2 = Arrays.asList(globalEnv.split(","));
        }
        return list2 == null ? Collections.emptyList() : list2;
    }

    public static List<String> disabledServices(ResourceInfo resource) {
        List<Object> disabledServices = resource.isServiceConfiguration() ? (CollectionUtils.isEmpty(resource.getDisabledServices()) ? Collections.emptyList() : resource.getDisabledServices()) : DisabledServiceResourceFilter.defaultDisabledServices();
        return disabledServices;
    }
}

