/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class GZIPResponseStream
extends ServletOutputStream {
    protected final ServletOutputStream delegateStream;
    protected GZIPOutputStream gzipstream = null;
    protected boolean closed = false;

    public GZIPResponseStream(HttpServletResponse response) throws IOException {
        this.delegateStream = response.getOutputStream();
        this.gzipstream = new GZIPOutputStream((OutputStream)this.delegateStream, 4096, true);
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        this.gzipstream.finish();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (!this.closed) {
            this.gzipstream.flush();
        }
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.gzipstream.write((byte)b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.gzipstream.write(b, off, len);
    }

    public boolean closed() {
        return this.closed;
    }
}

