/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSource;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.resource.Resource;

public class GeoServerDataSource
extends BasicDataSource {
    GeoServerDataDirectory dataDirectory;
    String file;
    Properties defaultParameters;

    public void setDataDirectory(GeoServerDataDirectory dataDir) {
        this.dataDirectory = dataDir;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setDefaultParameters(Properties defaultParameters) {
        this.defaultParameters = defaultParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (this.getDriverClassName() == null) {
            GeoServerDataSource geoServerDataSource = this;
            synchronized (geoServerDataSource) {
                if (this.getDriverClassName() == null) {
                    this.initializeDataSource();
                }
            }
        }
        return super.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeDataSource() {
        try {
            Resource dbprops = this.dataDirectory.get(this.file);
            Properties db = new Properties();
            if (dbprops.getType() != Resource.Type.RESOURCE) {
                try (OutputStream fout = dbprops.out();){
                    this.defaultParameters.store(fout, null);
                }
                db.putAll((Map<?, ?>)this.defaultParameters);
            } else {
                InputStream in = dbprops.in();
                db.load(in);
                in.close();
            }
            this.setDriverClassName(db.getProperty("driver"));
            this.setUrl(this.getURL(db));
            if (db.containsKey("username")) {
                this.setUsername(db.getProperty("username"));
            }
            if (db.containsKey("password")) {
                this.setPassword(db.getProperty("password"));
            }
            this.setMinIdle(1);
            this.setMaxActive(4);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error setting up the datas source", e);
        }
    }

    String getURL(Properties db) {
        return db.getProperty("url").replace("%GEOSERVER_DATA_DIR%", this.dataDirectory.root().getAbsolutePath());
    }
}

