/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.core.util.PresortedSet;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.geoserver.config.util.TreeMapConverter;

public class TreeSetConverter
extends CollectionConverter {
    public TreeSetConverter(Mapper mapper) {
        super(mapper, TreeSet.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        SortedSet sortedSet = (SortedSet)source;
        TreeMapConverter.marshalComparator(this.mapper(), sortedSet.comparator(), writer, context);
        super.marshal(source, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TreeSet result = null;
        Comparator unmarshalledComparator = TreeMapConverter.unmarshalComparator(this.mapper(), reader, context, null);
        boolean inFirstElement = unmarshalledComparator instanceof Mapper.Null;
        Comparator comparator = inFirstElement ? null : unmarshalledComparator;
        PresortedSet set = new PresortedSet(comparator);
        TreeSet treeSet = result = comparator == null ? new TreeSet() : new TreeSet(comparator);
        if (inFirstElement) {
            this.addCurrentElementToCollection(reader, context, result, (Collection)set);
            reader.moveUp();
        }
        this.populateCollection(reader, context, result, (Collection)set);
        if (set.size() > 0) {
            result.addAll(set);
        }
        return result;
    }
}

