/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import com.thoughtworks.xstream.InitializationException;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.BigDecimalConverter;
import com.thoughtworks.xstream.converters.basic.BigIntegerConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.converters.basic.CharConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.LongConverter;
import com.thoughtworks.xstream.converters.basic.NullConverter;
import com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.thoughtworks.xstream.converters.basic.StringBufferConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.basic.URIConverter;
import com.thoughtworks.xstream.converters.basic.URLConverter;
import com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.thoughtworks.xstream.converters.collections.BitSetConverter;
import com.thoughtworks.xstream.converters.collections.CharArrayConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.converters.collections.SingletonCollectionConverter;
import com.thoughtworks.xstream.converters.collections.SingletonMapConverter;
import com.thoughtworks.xstream.converters.extended.ColorConverter;
import com.thoughtworks.xstream.converters.extended.EncodedByteArrayConverter;
import com.thoughtworks.xstream.converters.extended.FileConverter;
import com.thoughtworks.xstream.converters.extended.GregorianCalendarConverter;
import com.thoughtworks.xstream.converters.extended.JavaClassConverter;
import com.thoughtworks.xstream.converters.extended.JavaFieldConverter;
import com.thoughtworks.xstream.converters.extended.JavaMethodConverter;
import com.thoughtworks.xstream.converters.extended.LocaleConverter;
import com.thoughtworks.xstream.converters.extended.LookAndFeelConverter;
import com.thoughtworks.xstream.converters.extended.SqlDateConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimeConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimestampConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.util.SelfStreamingInstanceChecker;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import com.thoughtworks.xstream.security.ForbiddenClassException;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.util.CollectionConverter;
import org.geoserver.config.util.TreeMapConverter;
import org.geoserver.config.util.TreeSetConverter;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SecureXStream
extends XStream {
    private static final String WHITELIST_KEY = "GEOSERVER_XSTREAM_WHITELIST";
    static final Logger LOGGER = Logging.getLogger(SecureXStream.class);

    public SecureXStream() {
        this.init();
    }

    public SecureXStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        super(hierarchicalStreamDriver);
        this.init();
    }

    public SecureXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry) {
        super(reflectionProvider, driver, classLoaderReference, mapper, converterLookup, converterRegistry);
        this.init();
    }

    public SecureXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference, Mapper mapper) {
        super(reflectionProvider, driver, classLoaderReference, mapper);
        this.init();
    }

    public SecureXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference) {
        super(reflectionProvider, driver, classLoaderReference);
        this.init();
    }

    public SecureXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        super(reflectionProvider, hierarchicalStreamDriver);
        this.init();
    }

    public SecureXStream(ReflectionProvider reflectionProvider) {
        super(reflectionProvider);
        this.init();
    }

    private void init() {
        this.addPermission(NoTypePermission.NONE);
        this.allowTypes(new Class[]{Mapper.Null.class});
        this.addPermission((TypePermission)new PrimitiveTypePermission());
        this.allowTypes(new Class[]{String.class, java.util.Date.class, Date.class, Timestamp.class, Time.class});
        this.allowTypeHierarchy(Filter.class);
        this.allowTypeHierarchy(NumberRange.class);
        this.allowTypeHierarchy(CoordinateReferenceSystem.class);
        this.allowTypeHierarchy(Name.class);
        this.allowTypes(new Class[]{Version.class, SimpleInternationalString.class});
        this.allowTypes(new Class[]{TreeSet.class, SortedSet.class, Set.class, HashSet.class, LinkedHashSet.class, List.class, ArrayList.class, CopyOnWriteArrayList.class, Map.class, HashMap.class, TreeMap.class, ConcurrentHashMap.class});
        String whitelistProp = GeoServerExtensions.getProperty((String)WHITELIST_KEY);
        if (whitelistProp != null) {
            String[] wildcards = whitelistProp.split("\\s+|(\\s*;\\s*)");
            this.allowTypesByWildcard(wildcards);
        }
    }

    protected MapperWrapper wrapMapper(MapperWrapper next) {
        return new DetailedSecurityExceptionWrapper((Mapper)next);
    }

    protected void setupConverters() {
        Mapper mapper = this.getMapper();
        ReflectionProvider reflectionProvider = this.getReflectionProvider();
        ClassLoaderReference classLoaderReference = this.getClassLoaderReference();
        ConverterLookup converterLookup = this.getConverterLookup();
        this.registerConverter((Converter)new ReflectionConverter(mapper, reflectionProvider), -20);
        this.registerConverter((Converter)new NullConverter(), 10000);
        this.registerConverter((SingleValueConverter)new IntConverter(), 0);
        this.registerConverter((SingleValueConverter)new FloatConverter(), 0);
        this.registerConverter((SingleValueConverter)new DoubleConverter(), 0);
        this.registerConverter((SingleValueConverter)new LongConverter(), 0);
        this.registerConverter((SingleValueConverter)new ShortConverter(), 0);
        this.registerConverter((Converter)new CharConverter(), 0);
        this.registerConverter((SingleValueConverter)new BooleanConverter(), 0);
        this.registerConverter((SingleValueConverter)new ByteConverter(), 0);
        this.registerConverter((SingleValueConverter)new StringConverter(), 0);
        this.registerConverter((SingleValueConverter)new StringBufferConverter(), 0);
        this.registerConverter((SingleValueConverter)new DateConverter(), 0);
        this.registerConverter((Converter)new BitSetConverter(), 0);
        this.registerConverter((SingleValueConverter)new URIConverter(), 0);
        this.registerConverter((SingleValueConverter)new URLConverter(), 0);
        this.registerConverter((SingleValueConverter)new BigIntegerConverter(), 0);
        this.registerConverter((SingleValueConverter)new BigDecimalConverter(), 0);
        this.registerConverter((Converter)new ArrayConverter(mapper), 0);
        this.registerConverter((Converter)new CharArrayConverter(), 0);
        this.registerConverter((Converter)new CollectionConverter(mapper), 0);
        this.registerConverter((Converter)new MapConverter(mapper), 0);
        this.registerConverter((Converter)new TreeMapConverter(mapper), 0);
        this.registerConverter((Converter)new TreeSetConverter(mapper), 0);
        this.registerConverter((Converter)new SingletonCollectionConverter(mapper), 0);
        this.registerConverter((Converter)new SingletonMapConverter(mapper), 0);
        this.registerConverter((Converter)new EncodedByteArrayConverter(), 0);
        this.registerConverter((SingleValueConverter)new FileConverter(), 0);
        if (JVM.isSQLAvailable()) {
            this.registerConverter((SingleValueConverter)new SqlTimestampConverter(), 0);
            this.registerConverter((SingleValueConverter)new SqlTimeConverter(), 0);
            this.registerConverter((SingleValueConverter)new SqlDateConverter(), 0);
        }
        this.registerConverter((SingleValueConverter)new JavaClassConverter(classLoaderReference), 0);
        this.registerConverter((Converter)new JavaMethodConverter(classLoaderReference), 0);
        this.registerConverter((Converter)new JavaFieldConverter(classLoaderReference), 0);
        if (JVM.isAWTAvailable()) {
            this.registerConverter((Converter)new ColorConverter(), 0);
        }
        if (JVM.isSwingAvailable()) {
            this.registerConverter((Converter)new LookAndFeelConverter(mapper, reflectionProvider), 0);
        }
        this.registerConverter((SingleValueConverter)new LocaleConverter(), 0);
        this.registerConverter((Converter)new GregorianCalendarConverter(), 0);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.SubjectConverter", 0, new Class[]{Mapper.class}, new Object[]{mapper});
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.ThrowableConverter", 0, new Class[]{ConverterLookup.class}, new Object[]{converterLookup});
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.StackTraceElementConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.CurrencyConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.RegexPatternConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.CharsetConverter", 0, null, null);
        if (JVM.loadClassForName((String)"javax.xml.datatype.Duration") != null) {
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.DurationConverter", 0, null, null);
        }
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.enums.EnumConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.basic.StringBuilderConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.basic.UUIDConverter", 0, null, null);
        if (JVM.loadClassForName((String)"javax.activation.ActivationDataFlavor") != null) {
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.ActivationDataFlavorConverter", 0, null, null);
        }
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.PathConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.ChronologyConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.DurationConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.HijrahDateConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.JapaneseDateConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.JapaneseEraConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.InstantConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.LocalDateConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.LocalDateTimeConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.LocalTimeConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.MinguoDateConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.MonthDayConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.OffsetDateTimeConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.OffsetTimeConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.PeriodConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.SystemClockConverter", 0, new Class[]{Mapper.class}, new Object[]{mapper});
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.ThaiBuddhistDateConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.ValueRangeConverter", 0, new Class[]{Mapper.class}, new Object[]{mapper});
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.WeekFieldsConverter", 0, new Class[]{Mapper.class}, new Object[]{mapper});
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.YearConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.YearMonthConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.ZonedDateTimeConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.ZoneIdConverter", 0, null, null);
        this.registerConverterDynamically("com.thoughtworks.xstream.converters.reflection.LambdaConverter", 0, new Class[]{Mapper.class, ReflectionProvider.class, ClassLoaderReference.class}, new Object[]{mapper, reflectionProvider, classLoaderReference});
        this.registerConverter((Converter)new SelfStreamingInstanceChecker(converterLookup, (Object)this), 0);
    }

    private void registerConverterDynamically(String className, int priority, Class[] constructorParamTypes, Object[] constructorParamValues) {
        try {
            Class<?> type = Class.forName(className, false, this.getClassLoaderReference().getReference());
            Constructor<?> constructor = type.getConstructor(constructorParamTypes);
            Object instance = constructor.newInstance(constructorParamValues);
            if (instance instanceof Converter) {
                this.registerConverter((Converter)instance, priority);
            } else if (instance instanceof SingleValueConverter) {
                this.registerConverter((SingleValueConverter)instance, priority);
            }
        }
        catch (Exception e) {
            throw new InitializationException("Could not instantiate converter : " + className, (Throwable)e);
        }
        catch (LinkageError e) {
            throw new InitializationException("Could not instantiate converter : " + className, (Throwable)e);
        }
    }

    static class ForbiddenClassExceptionEx
    extends RuntimeException {
        public ForbiddenClassExceptionEx(String message, Throwable cause) {
            super(message, cause);
        }
    }

    static class DetailedSecurityExceptionWrapper
    extends MapperWrapper {
        public DetailedSecurityExceptionWrapper(Mapper wrapped) {
            super(wrapped);
        }

        public Class realClass(String elementName) {
            try {
                return super.realClass(elementName);
            }
            catch (ForbiddenClassException e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Class {0} is not whitelisted for XML parsing. \n");
                sb.append("This is done to prevent Remote Code Execution attacks, but it might be \n").append("you need this class to be authorized for GeoServer to actually work\n");
                sb.append("If you are a user, you can set a variable named ").append(SecureXStream.WHITELIST_KEY).append("\n").append("  with a semicolon separated list of fully qualified names, or patterns\n").append("  to match several classes.The variable can be set as a system variable,\n").append("  an environment variable, or a servlet context variable, just like\n").append("  GEOSERVER_DATA_DIR.\n").append("  For example, in order to authorize the org.geoserver.Foo class,\n").append("  plus any class in the org.geoserver.custom package, one could set\n").append("  a system variable: \n").append("  -D").append(SecureXStream.WHITELIST_KEY).append("=org.geoserver.Foo;org.geoserver.custom.**\n");
                sb.append("If instead you are a developer, you can call allowTypes/allowTypeHierarchy against\n").append("  the XStream used for serialization by rolling a custom\n").append("  XStreamPersisterInitializer or customizing your XStreamServiceLoader.");
                LOGGER.log(Level.SEVERE, sb.toString(), e.getMessage());
                throw new ForbiddenClassExceptionEx("Unauthorized class found, see logs for more details on how to handle it: " + e.getMessage(), e);
            }
        }
    }
}

