/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import org.geoserver.config.DefaultGeoServerLoader;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.GeoServerReinitializer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GeoServerLoaderProxy
implements BeanPostProcessor,
DisposableBean,
ApplicationContextAware,
GeoServerReinitializer {
    protected GeoServerResourceLoader resourceLoader;
    GeoServerLoader loader;

    public GeoServerLoaderProxy(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.loader = this.lookupGeoServerLoader(applicationContext);
        this.loader.setApplicationContext(applicationContext);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.loader != null) {
            return this.loader.postProcessAfterInitialization(bean, beanName);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.loader != null) {
            return this.loader.postProcessBeforeInitialization(bean, beanName);
        }
        return bean;
    }

    public void reload() throws Exception {
        if (this.loader != null) {
            this.loader.reload();
        }
    }

    public void destroy() throws Exception {
        if (this.loader != null) {
            this.loader.destroy();
        }
    }

    protected GeoServerLoader lookupGeoServerLoader(ApplicationContext appContext) {
        GeoServerLoader loader = (GeoServerLoader)GeoServerExtensions.bean(GeoServerLoader.class, (ApplicationContext)appContext);
        if (loader == null) {
            loader = new DefaultGeoServerLoader(this.resourceLoader);
        }
        return loader;
    }

    @Override
    public void initialize(GeoServer geoServer) throws Exception {
        this.loader.initializeDefaultStyles(geoServer.getCatalog());
    }
}

