/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.IOException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.Version;

public class StyleInfoImpl
implements StyleInfo {
    protected String id;
    protected String name;
    protected WorkspaceInfo workspace;
    @Deprecated
    protected Version sldVersion = null;
    protected String format = "sld";
    protected Version languageVersion = SLDHandler.VERSION_10;
    protected String filename;
    protected LegendInfo legend;
    protected transient Catalog catalog;

    protected StyleInfoImpl() {
    }

    public StyleInfoImpl(Catalog catalog) {
        this.catalog = catalog;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public WorkspaceInfo getWorkspace() {
        return this.workspace;
    }

    @Override
    public void setWorkspace(WorkspaceInfo workspace) {
        this.workspace = workspace;
    }

    @Override
    public Version getSLDVersion() {
        return this.getFormatVersion();
    }

    @Override
    public void setSLDVersion(Version v) {
        this.setFormatVersion(v);
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String language) {
        this.format = language;
    }

    @Override
    public Version getFormatVersion() {
        return this.languageVersion;
    }

    @Override
    public void setFormatVersion(Version version) {
        this.languageVersion = version;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public Style getStyle() throws IOException {
        return this.catalog.getResourcePool().getStyle(this);
    }

    @Override
    public StyledLayerDescriptor getSLD() throws IOException {
        return this.catalog.getResourcePool().getSld(this);
    }

    @Override
    public LegendInfo getLegend() {
        return this.legend;
    }

    @Override
    public void setLegend(LegendInfo legend) {
        this.legend = legend;
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.workspace == null ? 0 : this.workspace.hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.languageVersion == null ? 0 : this.languageVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StyleInfo)) {
            return false;
        }
        StyleInfo other = (StyleInfo)obj;
        if (this.filename == null ? other.getFilename() != null : !this.filename.equals(other.getFilename())) {
            return false;
        }
        if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
            return false;
        }
        if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
            return false;
        }
        if (this.workspace == null ? other.getWorkspace() != null : !this.workspace.equals(other.getWorkspace())) {
            return false;
        }
        if (this.format == null ? other.getFormat() != null : !this.format.equals(other.getFormat())) {
            return false;
        }
        return !(this.languageVersion == null ? other.getFormatVersion() != null : !this.languageVersion.equals((Object)other.getFormatVersion()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.prefixedName() + ']';
    }

    private Object readResolve() {
        if (this.format == null) {
            this.format = "sld";
        }
        if (this.languageVersion == null && this.sldVersion != null) {
            this.languageVersion = this.sldVersion;
        }
        if (this.languageVersion == null) {
            this.languageVersion = SLDHandler.VERSION_10;
        }
        return this;
    }

    @Override
    public String prefixedName() {
        if (this.workspace != null) {
            return this.workspace.getName() + ":" + this.getName();
        }
        return this.getName();
    }
}

