/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.platform.ServiceException;
import org.geotools.data.FeatureSource;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.measure.Measure;
import org.geotools.util.factory.Hints;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.util.ProgressListener;

public class FeatureTypeInfoImpl
extends ResourceInfoImpl
implements FeatureTypeInfo {
    protected transient Filter filter;
    protected String cqlFilter;
    protected int maxFeatures;
    protected int numDecimals;
    protected boolean padWithZeros;
    protected boolean forcedDecimal;
    protected List<AttributeTypeInfo> attributes = new ArrayList<AttributeTypeInfo>();
    protected List<String> responseSRS = new ArrayList<String>();
    boolean overridingServiceSRS;
    boolean skipNumberMatched = false;
    boolean circularArcPresent;
    Boolean encodeMeasures;
    Measure linearizationTolerance;

    @Override
    public boolean isCircularArcPresent() {
        return this.circularArcPresent;
    }

    @Override
    public void setCircularArcPresent(boolean curveGeometryEnabled) {
        this.circularArcPresent = curveGeometryEnabled;
    }

    protected FeatureTypeInfoImpl() {
    }

    public FeatureTypeInfoImpl(Catalog catalog) {
        super(catalog);
    }

    public FeatureTypeInfoImpl(Catalog catalog, String id) {
        super(catalog, id);
    }

    @Override
    public DataStoreInfo getStore() {
        StoreInfo storeInfo = super.getStore();
        if (!(storeInfo instanceof DataStoreInfo)) {
            LOGGER.warning("Failed to load actual store for " + this);
            return null;
        }
        return (DataStoreInfo)super.getStore();
    }

    @Override
    public List<AttributeTypeInfo> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<AttributeTypeInfo> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Filter filter() {
        try {
            if (this.filter == null && this.cqlFilter != null && !this.cqlFilter.isEmpty()) {
                this.filter = ECQL.toFilter((String)this.cqlFilter);
            }
        }
        catch (CQLException e) {
            throw new ServiceException("Failed to generate filter from ECQL string " + e.getMessage());
        }
        return this.filter;
    }

    @Override
    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    @Override
    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    @Override
    public int getNumDecimals() {
        return this.numDecimals;
    }

    @Override
    public void setNumDecimals(int numDecimals) {
        this.numDecimals = numDecimals;
    }

    @Override
    public List<AttributeTypeInfo> attributes() throws IOException {
        return this.catalog.getResourcePool().getAttributes(this);
    }

    @Override
    public FeatureType getFeatureType() throws IOException {
        return this.catalog.getResourcePool().getFeatureType(this);
    }

    @Override
    public FeatureSource<? extends FeatureType, ? extends Feature> getFeatureSource(ProgressListener listener, Hints hints) throws IOException {
        return this.catalog.getResourcePool().getFeatureSource(this, hints);
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<String> getResponseSRS() {
        return this.responseSRS;
    }

    public void setResponseSRS(List<String> otherSrs) {
        this.responseSRS = otherSrs;
    }

    @Override
    public boolean isOverridingServiceSRS() {
        return this.overridingServiceSRS;
    }

    @Override
    public void setOverridingServiceSRS(boolean overridingServiceSRS) {
        this.overridingServiceSRS = overridingServiceSRS;
    }

    @Override
    public boolean getSkipNumberMatched() {
        return this.skipNumberMatched;
    }

    @Override
    public void setSkipNumberMatched(boolean skipNumberMatched) {
        this.skipNumberMatched = skipNumberMatched;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + this.maxFeatures;
        result = 31 * result + this.numDecimals;
        result = 31 * result + (this.overridingServiceSRS ? 1231 : 1237);
        result = 31 * result + (this.responseSRS == null ? 0 : this.responseSRS.hashCode());
        result = 31 * result + (this.skipNumberMatched ? 2845 : 3984);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureTypeInfo)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        FeatureTypeInfo other = (FeatureTypeInfo)obj;
        if (this.attributes == null) {
            if (other.getAttributes() != null) {
                return false;
            }
        } else {
            List<AttributeTypeInfo> otherAttributes = other.getAttributes();
            if (otherAttributes == this.attributes) {
                return true;
            }
            ListIterator<AttributeTypeInfo> attributesIterator = this.attributes.listIterator();
            ListIterator<AttributeTypeInfo> otherAttributesIterator = otherAttributes.listIterator();
            while (attributesIterator.hasNext() && otherAttributesIterator.hasNext()) {
                AttributeTypeInfo attr = attributesIterator.next();
                AttributeTypeInfo otherAttr = otherAttributesIterator.next();
                if (!(attr == null ? otherAttr != null : !attr.equalsIngnoreFeatureType(otherAttr))) continue;
                return false;
            }
            if (attributesIterator.hasNext() || otherAttributesIterator.hasNext()) {
                return false;
            }
        }
        if (this.responseSRS == null ? other.getResponseSRS() != null : !this.responseSRS.equals(other.getResponseSRS())) {
            return false;
        }
        if (this.circularArcPresent != other.isCircularArcPresent()) {
            return false;
        }
        if (this.linearizationTolerance == null ? other.getLinearizationTolerance() != null : !this.linearizationTolerance.equals((Object)other.getLinearizationTolerance())) {
            return false;
        }
        if (this.maxFeatures != other.getMaxFeatures()) {
            return false;
        }
        if (this.numDecimals != other.getNumDecimals()) {
            return false;
        }
        if (this.overridingServiceSRS != other.isOverridingServiceSRS()) {
            return false;
        }
        if (this.skipNumberMatched != other.getSkipNumberMatched()) {
            return false;
        }
        return !(this.cqlFilter == null ? other.getCqlFilter() != null : !this.cqlFilter.equals(other.getCqlFilter()));
    }

    @Override
    public Measure getLinearizationTolerance() {
        return this.linearizationTolerance;
    }

    @Override
    public void setLinearizationTolerance(Measure tolerance) {
        this.linearizationTolerance = tolerance;
    }

    @Override
    public String getCqlFilter() {
        return this.cqlFilter;
    }

    @Override
    public void setCqlFilter(String cqlFilter) {
        this.cqlFilter = cqlFilter;
        this.filter = null;
    }

    @Override
    public boolean getEncodeMeasures() {
        return this.encodeMeasures == null ? false : this.encodeMeasures;
    }

    @Override
    public void setEncodeMeasures(boolean encodeMeasures) {
        this.encodeMeasures = encodeMeasures;
    }

    @Override
    public boolean getPadWithZeros() {
        return this.padWithZeros;
    }

    @Override
    public void setPadWithZeros(boolean padWithZeros) {
        this.padWithZeros = padWithZeros;
    }

    @Override
    public boolean getForcedDecimal() {
        return this.forcedDecimal;
    }

    @Override
    public void setForcedDecimal(boolean forcedDecimal) {
        this.forcedDecimal = forcedDecimal;
    }
}

