/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.util.ProgressListener;

public class CoverageInfoImpl
extends ResourceInfoImpl
implements CoverageInfo {
    private static final long serialVersionUID = 659498790758954330L;
    protected String nativeFormat;
    protected GridGeometry grid;
    protected List<String> supportedFormats = new ArrayList<String>();
    protected List<String> interpolationMethods = new ArrayList<String>();
    protected String defaultInterpolationMethod;
    protected List<CoverageDimensionInfo> dimensions = new ArrayList<CoverageDimensionInfo>();
    protected List<String> requestSRS = new ArrayList<String>();
    protected List<String> responseSRS = new ArrayList<String>();
    protected Map parameters = new HashMap();
    protected String nativeCoverageName;

    protected CoverageInfoImpl() {
    }

    public CoverageInfoImpl(Catalog catalog) {
        super(catalog);
    }

    public CoverageInfoImpl(Catalog catalog, String id) {
        super(catalog, id);
    }

    @Override
    public CoverageStoreInfo getStore() {
        return (CoverageStoreInfo)super.getStore();
    }

    @Override
    public GridGeometry getGrid() {
        return this.grid;
    }

    @Override
    public void setGrid(GridGeometry grid) {
        this.grid = grid;
    }

    @Override
    public String getNativeFormat() {
        return this.nativeFormat;
    }

    @Override
    public void setNativeFormat(String nativeFormat) {
        this.nativeFormat = nativeFormat;
    }

    @Override
    public List<String> getSupportedFormats() {
        return this.supportedFormats;
    }

    @Override
    public List<String> getInterpolationMethods() {
        return this.interpolationMethods;
    }

    @Override
    public String getDefaultInterpolationMethod() {
        return this.defaultInterpolationMethod;
    }

    @Override
    public void setDefaultInterpolationMethod(String defaultInterpolationMethod) {
        this.defaultInterpolationMethod = defaultInterpolationMethod;
    }

    @Override
    public List<CoverageDimensionInfo> getDimensions() {
        return this.dimensions;
    }

    @Override
    public List<String> getRequestSRS() {
        return this.requestSRS;
    }

    @Override
    public List<String> getResponseSRS() {
        return this.responseSRS;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    @Override
    public GridCoverage getGridCoverage(ProgressListener listener, Hints hints) throws IOException {
        if (this.projectionPolicy == ProjectionPolicy.FORCE_DECLARED) {
            Hints crsHints = new Hints((RenderingHints.Key)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)this.getCRS());
            if (hints != null) {
                hints.putAll((Map)crsHints);
            } else {
                hints = crsHints;
            }
        }
        return this.catalog.getResourcePool().getGridCoverage(this, null, hints);
    }

    @Override
    public GridCoverage getGridCoverage(ProgressListener listener, ReferencedEnvelope envelope, Hints hints) throws IOException {
        if (this.projectionPolicy == ProjectionPolicy.FORCE_DECLARED) {
            Hints crsHints = new Hints((RenderingHints.Key)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)this.getCRS());
            if (hints != null) {
                hints.putAll((Map)crsHints);
            } else {
                hints = crsHints;
            }
        }
        return this.catalog.getResourcePool().getGridCoverage(this, envelope, hints);
    }

    @Override
    public GridCoverageReader getGridCoverageReader(ProgressListener listener, Hints hints) throws IOException {
        if (this.projectionPolicy == ProjectionPolicy.FORCE_DECLARED) {
            Hints crsHints = new Hints((RenderingHints.Key)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)this.getCRS());
            if (hints != null) {
                hints.putAll((Map)crsHints);
            } else {
                hints = crsHints;
            }
        }
        return this.catalog.getResourcePool().getGridCoverageReader(this, this.nativeCoverageName, hints);
    }

    public void setSupportedFormats(List<String> supportedFormats) {
        this.supportedFormats = supportedFormats;
    }

    public void setInterpolationMethods(List<String> interpolationMethods) {
        this.interpolationMethods = interpolationMethods;
    }

    public void setDimensions(List<CoverageDimensionInfo> dimensions) {
        this.dimensions = dimensions;
    }

    public void setRequestSRS(List<String> requestSRS) {
        this.requestSRS = requestSRS;
    }

    public void setResponseSRS(List<String> responseSRS) {
        this.responseSRS = responseSRS;
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.defaultInterpolationMethod == null ? 0 : this.defaultInterpolationMethod.hashCode());
        result = 31 * result + (this.dimensions == null ? 0 : this.dimensions.hashCode());
        result = 31 * result + (this.grid == null ? 0 : this.grid.hashCode());
        result = 31 * result + (this.interpolationMethods == null ? 0 : this.interpolationMethods.hashCode());
        result = 31 * result + (this.nativeFormat == null ? 0 : this.nativeFormat.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.requestSRS == null ? 0 : this.requestSRS.hashCode());
        result = 31 * result + (this.responseSRS == null ? 0 : this.responseSRS.hashCode());
        result = 31 * result + (this.supportedFormats == null ? 0 : this.supportedFormats.hashCode());
        result = 31 * result + (this.nativeCoverageName == null ? 0 : this.nativeCoverageName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CoverageInfo)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CoverageInfo other = (CoverageInfo)obj;
        if (this.defaultInterpolationMethod == null ? other.getDefaultInterpolationMethod() != null : !this.defaultInterpolationMethod.equals(other.getDefaultInterpolationMethod())) {
            return false;
        }
        if (this.dimensions == null ? other.getDimensions() != null : !this.dimensions.equals(other.getDimensions())) {
            return false;
        }
        if (this.grid == null ? other.getGrid() != null : !this.grid.equals(other.getGrid())) {
            return false;
        }
        if (this.interpolationMethods == null ? other.getInterpolationMethods() != null : !this.interpolationMethods.equals(other.getInterpolationMethods())) {
            return false;
        }
        if (this.nativeFormat == null ? other.getNativeFormat() != null : !this.nativeFormat.equals(other.getNativeFormat())) {
            return false;
        }
        if (this.parameters == null ? other.getParameters() != null : !this.parameters.equals(other.getParameters())) {
            return false;
        }
        if (this.requestSRS == null ? other.getRequestSRS() != null : !this.requestSRS.equals(other.getRequestSRS())) {
            return false;
        }
        if (this.responseSRS == null ? other.getResponseSRS() != null : !this.responseSRS.equals(other.getResponseSRS())) {
            return false;
        }
        if (this.supportedFormats == null ? other.getSupportedFormats() != null : !this.supportedFormats.equals(other.getSupportedFormats())) {
            return false;
        }
        return !(this.nativeCoverageName == null ? other.getNativeCoverageName() != null : !this.nativeCoverageName.equals(other.getNativeCoverageName()));
    }

    @Override
    public String getNativeCoverageName() {
        return this.nativeCoverageName;
    }

    @Override
    public void setNativeCoverageName(String nativeCoverageName) {
        this.nativeCoverageName = nativeCoverageName;
    }
}

