/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;

class CatalogInfoLookup<T extends CatalogInfo> {
    static final Logger LOGGER = Logging.getLogger(CatalogInfoLookup.class);
    ConcurrentHashMap<Class<T>, Map<String, T>> idMultiMap = new ConcurrentHashMap();
    ConcurrentHashMap<Class<T>, Map<Name, T>> nameMultiMap = new ConcurrentHashMap();
    Function<T, Name> nameMapper;
    static final Predicate TRUE = x -> true;

    public CatalogInfoLookup(Function<T, Name> nameMapper) {
        this.nameMapper = nameMapper;
    }

    <K> Map<K, T> getMapForValue(ConcurrentHashMap<Class<T>, Map<K, T>> maps, T value) {
        Class<?> vc;
        if (Proxy.isProxyClass(value.getClass())) {
            ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(value);
            CatalogInfo po = (CatalogInfo)h.getProxyObject();
            vc = po.getClass();
        } else {
            vc = value.getClass();
        }
        return this.getMapForValue(maps, vc);
    }

    protected <K> Map<K, T> getMapForValue(ConcurrentHashMap<Class<T>, Map<K, T>> maps, Class vc) {
        Map vcMap = maps.get(vc);
        if (vcMap == null) {
            vcMap = maps.computeIfAbsent(vc, k -> new ConcurrentSkipListMap());
        }
        return vcMap;
    }

    public T add(T value) {
        if (Proxy.isProxyClass(value.getClass())) {
            ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(value);
            value = (CatalogInfo)h.getProxyObject();
        }
        Map<Name, T> nameMap = this.getMapForValue(this.nameMultiMap, value);
        Name name = this.nameMapper.apply(value);
        nameMap.put(name, value);
        Map<String, T> idMap = this.getMapForValue(this.idMultiMap, value);
        return (T)((CatalogInfo)idMap.put(value.getId(), value));
    }

    public Collection<T> values() {
        ArrayList<T> result = new ArrayList<T>();
        for (Map<String, T> v : this.idMultiMap.values()) {
            result.addAll(v.values());
        }
        return result;
    }

    public T remove(T value) {
        Name name = this.nameMapper.apply(value);
        Map nameMap = this.getMapForValue(this.nameMultiMap, value);
        nameMap.remove(name);
        Map idMap = this.getMapForValue(this.idMultiMap, value);
        return (T)((CatalogInfo)idMap.remove(value.getId()));
    }

    public void update(T proxiedValue) {
        Name newName;
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(proxiedValue);
        CatalogInfo actualValue = (CatalogInfo)h.getProxyObject();
        Name oldName = this.nameMapper.apply(actualValue);
        if (!oldName.equals((Object)(newName = this.nameMapper.apply(proxiedValue)))) {
            Map<Name, CatalogInfo> nameMap = this.getMapForValue(this.nameMultiMap, actualValue);
            nameMap.remove(oldName);
            nameMap.put(newName, actualValue);
        }
    }

    public void clear() {
        this.idMultiMap.clear();
        this.nameMultiMap.clear();
    }

    <U extends CatalogInfo> List<U> list(Class<U> clazz, Predicate<U> predicate) {
        ArrayList<CatalogInfo> result = new ArrayList<CatalogInfo>();
        for (Class key : this.nameMultiMap.keySet()) {
            Map<Name, T> valueMap;
            if (!clazz.isAssignableFrom(key) || (valueMap = this.nameMultiMap.get(key)) == null) continue;
            Iterator<T> iterator = valueMap.values().iterator();
            while (iterator.hasNext()) {
                CatalogInfo v;
                CatalogInfo u = v = (CatalogInfo)iterator.next();
                if (predicate != TRUE && !predicate.test(u)) continue;
                result.add(u);
            }
        }
        return result;
    }

    public <U extends CatalogInfo> U findById(String id, Class<U> clazz) {
        for (Class key : this.idMultiMap.keySet()) {
            CatalogInfo t;
            Map<String, T> valueMap;
            if (!clazz.isAssignableFrom(key) || (valueMap = this.idMultiMap.get(key)) == null || (t = (CatalogInfo)valueMap.get(id)) == null) continue;
            return (U)t;
        }
        return null;
    }

    public <U extends CatalogInfo> U findByName(Name name, Class<U> clazz) {
        for (Class key : this.nameMultiMap.keySet()) {
            CatalogInfo t;
            Map<Name, T> valueMap;
            if (!clazz.isAssignableFrom(key) || (valueMap = this.nameMultiMap.get(key)) == null || (t = (CatalogInfo)valueMap.get(name)) == null) continue;
            return (U)t;
        }
        return null;
    }

    <U extends CatalogInfo> U findFirst(Class<U> clazz, Predicate<U> predicate) {
        for (Class key : this.nameMultiMap.keySet()) {
            Map<Name, T> valueMap;
            if (!clazz.isAssignableFrom(key) || (valueMap = this.nameMultiMap.get(key)) == null) continue;
            Iterator<T> iterator = valueMap.values().iterator();
            while (iterator.hasNext()) {
                CatalogInfo v;
                CatalogInfo u = v = (CatalogInfo)iterator.next();
                if (predicate != TRUE && !predicate.test(u)) continue;
                return (U)u;
            }
        }
        return null;
    }

    public CatalogInfoLookup setCatalog(Catalog catalog) {
        for (Map<Name, T> valueMap : this.nameMultiMap.values()) {
            if (valueMap == null) continue;
            for (CatalogInfo v : valueMap.values()) {
                Method setter;
                if (!(v instanceof CatalogInfo) || (setter = OwsUtils.setter(v.getClass(), (String)"catalog", Catalog.class)) == null) continue;
                try {
                    setter.invoke((Object)v, catalog);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Failed to switch CatalogInfo to new catalog impl", e);
                }
            }
        }
        return this;
    }
}

