/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.GeoServerSLDVisitorAdapter;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SLDNamedLayerValidator
extends GeoServerSLDVisitorAdapter {
    public List<Exception> validationErrors = new ArrayList<Exception>();

    public SLDNamedLayerValidator(Catalog catalog, CoordinateReferenceSystem fallbackCrs) {
        super(catalog, fallbackCrs);
    }

    public List<Exception> getValidationErrors() {
        return this.validationErrors;
    }

    @Override
    public void visit(StyledLayerDescriptor sld) {
        try {
            super.visit(sld);
        }
        catch (Exception e) {
            this.validationErrors.add(e);
        }
    }

    @Override
    public PublishedInfo visitNamedLayerInternal(StyledLayer namedLayer) {
        PublishedInfo p = this.catalog.getLayerGroupByName(namedLayer.getName());
        if (p == null) {
            p = this.catalog.getLayerByName(namedLayer.getName());
        }
        if (p == null) {
            this.validationErrors.add(new Exception("No layer or layer group named '" + namedLayer.getName() + "' found in the catalog"));
        }
        return p;
    }

    @Override
    public StyleInfo visitNamedStyleInternal(NamedStyle namedStyle) {
        StyleInfo s = this.catalog.getStyleByName(namedStyle.getName());
        if (s == null) {
            this.validationErrors.add(new Exception("No style named '" + namedStyle.getName() + "' found in the catalog"));
        }
        return s;
    }

    public static List<Exception> validate(Catalog catalog, StyledLayerDescriptor sld) {
        SLDNamedLayerValidator validator = new SLDNamedLayerValidator(catalog, null);
        sld.accept((StyleVisitor)validator);
        return validator.getValidationErrors();
    }
}

