/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.List;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.PublishedInfo;

public interface LayerGroupVisibilityPolicy {
    public static final LayerGroupVisibilityPolicy HIDE_NEVER = new LayerGroupVisibilityPolicy(){

        @Override
        public boolean hideLayerGroup(LayerGroupInfo group, List<PublishedInfo> filteredLayers) {
            return false;
        }
    };
    public static final LayerGroupVisibilityPolicy HIDE_EMPTY = new LayerGroupVisibilityPolicy(){

        @Override
        public boolean hideLayerGroup(LayerGroupInfo group, List<PublishedInfo> filteredLayers) {
            return filteredLayers.size() == 0;
        }
    };
    public static final LayerGroupVisibilityPolicy HIDE_IF_ALL_HIDDEN = new LayerGroupVisibilityPolicy(){

        @Override
        public boolean hideLayerGroup(LayerGroupInfo group, List<PublishedInfo> filteredLayers) {
            return filteredLayers.size() == 0 && group.getLayers().size() > 0;
        }
    };

    public boolean hideLayerGroup(LayerGroupInfo var1, List<PublishedInfo> var2);
}

