/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.opengis.filter.Filter;
import org.opengis.filter.MultiValuedFilter;

public class CascadeRemovalReporter
implements CatalogVisitor {
    Catalog catalog;
    Map<CatalogInfo, ModificationType> objects;
    Map<LayerGroupInfo, Set<LayerInfo>> groups;

    public CascadeRemovalReporter(Catalog catalog) {
        this.catalog = catalog;
        this.reset();
    }

    @Override
    public void visit(Catalog catalog) {
    }

    public void reset() {
        this.objects = new HashMap<CatalogInfo, ModificationType>();
        this.groups = new HashMap<LayerGroupInfo, Set<LayerInfo>>();
    }

    public <T> List<T> getObjects(Class<T> catalogClass, ModificationType ... modifications) {
        ArrayList<CatalogInfo> result = new ArrayList<CatalogInfo>();
        List<ModificationType> mods = modifications == null || modifications.length == 0 ? null : Arrays.asList(modifications);
        for (CatalogInfo ci : this.objects.keySet()) {
            if (catalogClass != null && !catalogClass.isAssignableFrom(ci.getClass()) || mods != null && !mods.contains((Object)this.objects.get(ci))) continue;
            result.add(ci);
        }
        return result;
    }

    public void removeAll(Collection<? extends CatalogInfo> objects) {
        for (CatalogInfo catalogInfo : objects) {
            this.objects.remove(catalogInfo);
        }
    }

    void add(CatalogInfo ci, ModificationType type) {
        ModificationType oldType = this.objects.get(ci);
        if (oldType == null || oldType.compareTo(type) > 0) {
            this.objects.put(ci, type);
        }
    }

    @Override
    public void visit(WorkspaceInfo workspace) {
        List<StoreInfo> stores = this.catalog.getStoresByWorkspace(workspace, StoreInfo.class);
        for (StoreInfo storeInfo : stores) {
            storeInfo.accept(this);
        }
        for (StyleInfo style : this.catalog.getStylesByWorkspace(workspace)) {
            style.accept(this);
        }
        for (LayerGroupInfo group : this.catalog.getLayerGroupsByWorkspace(workspace)) {
            group.accept(this);
        }
        this.add(workspace, ModificationType.DELETE);
    }

    @Override
    public void visit(NamespaceInfo namespace) {
        this.add(namespace, ModificationType.DELETE);
    }

    @Override
    public void visit(DataStoreInfo dataStore) {
        this.visitStore(dataStore);
    }

    @Override
    public void visit(CoverageStoreInfo coverageStore) {
        this.visitStore(coverageStore);
    }

    @Override
    public void visit(WMSStoreInfo store) {
        this.visitStore(store);
    }

    @Override
    public void visit(WMTSStoreInfo store) {
        this.visitStore(store);
    }

    void visitStore(StoreInfo dataStore) {
        List<ResourceInfo> resources = this.catalog.getResourcesByStore(dataStore, ResourceInfo.class);
        for (ResourceInfo ri : resources) {
            List<LayerInfo> layers = this.catalog.getLayers(ri);
            if (!layers.isEmpty()) {
                for (LayerInfo li : layers) {
                    li.accept(this);
                }
                continue;
            }
            ri.accept(this);
        }
        this.add(dataStore, ModificationType.DELETE);
    }

    @Override
    public void visit(FeatureTypeInfo featureType) {
        this.add(featureType, ModificationType.DELETE);
    }

    @Override
    public void visit(CoverageInfo coverage) {
        this.add(coverage, ModificationType.DELETE);
    }

    @Override
    public void visit(WMSLayerInfo wmsLayer) {
        this.add(wmsLayer, ModificationType.DELETE);
    }

    @Override
    public void visit(WMTSLayerInfo wmtsLayer) {
        this.add(wmtsLayer, ModificationType.DELETE);
    }

    @Override
    public void visit(LayerInfo layer) {
        this.add(layer.getResource(), ModificationType.DELETE);
        this.add(layer, ModificationType.DELETE);
        Filter groupContainsLayer = Predicates.equal("layers", layer, MultiValuedFilter.MatchAction.ANY);
        try (CloseableIterator<LayerGroupInfo> it = this.catalog.list(LayerGroupInfo.class, groupContainsLayer);){
            while (it.hasNext()) {
                LayerGroupInfo group = (LayerGroupInfo)it.next();
                Set<LayerInfo> layers = this.groups.get(group);
                if (layers == null) {
                    layers = new HashSet<LayerInfo>();
                    this.groups.put(group, layers);
                }
                layers.add(layer);
                if (layers.size() == new HashSet<PublishedInfo>(group.getLayers()).size()) {
                    this.visit(group);
                    continue;
                }
                this.add(group, ModificationType.GROUP_CHANGED);
            }
        }
    }

    @Override
    public void visit(StyleInfo style) {
        Filter anyStyle = Predicates.equal("styles", style, MultiValuedFilter.MatchAction.ANY);
        Filter layersAssociated = Predicates.or(Predicates.equal("defaultStyle", style), anyStyle);
        try (CloseableIterator<LayerInfo> it = this.catalog.list(LayerInfo.class, layersAssociated);){
            while (it.hasNext()) {
                LayerInfo li = (LayerInfo)it.next();
                if (style.equals(li.getDefaultStyle())) {
                    this.add(li, ModificationType.STYLE_RESET);
                    continue;
                }
                if (!li.getStyles().contains(style)) continue;
                this.add(li, ModificationType.EXTRA_STYLE_REMOVED);
            }
        }
        Filter groupAssociated = Predicates.or(Predicates.equal("rootLayerStyle", style), anyStyle);
        try (CloseableIterator<LayerGroupInfo> it = this.catalog.list(LayerGroupInfo.class, groupAssociated);){
            while (it.hasNext()) {
                LayerGroupInfo group = (LayerGroupInfo)it.next();
                if (style.equals(group.getRootLayerStyle())) {
                    this.add(group, ModificationType.GROUP_CHANGED);
                }
                if (!group.getStyles().contains(style)) continue;
                this.add(group, ModificationType.GROUP_CHANGED);
            }
        }
        this.add(style, ModificationType.DELETE);
    }

    @Override
    public void visit(LayerGroupInfo layerGroupToRemove) {
        Filter associatedTo = Predicates.equal("layers", layerGroupToRemove, MultiValuedFilter.MatchAction.ANY);
        try (CloseableIterator<LayerGroupInfo> it = this.catalog.list(LayerGroupInfo.class, associatedTo);){
            while (it.hasNext()) {
                LayerGroupInfo group = (LayerGroupInfo)it.next();
                if (!group.getLayers().contains(layerGroupToRemove)) continue;
                ArrayList<PublishedInfo> layers = new ArrayList<PublishedInfo>(group.getLayers());
                layers.removeAll(this.objects.keySet());
                if (layers.size() == 0) {
                    this.visit(group);
                    continue;
                }
                this.add(group, ModificationType.GROUP_CHANGED);
            }
        }
        this.add(layerGroupToRemove, ModificationType.DELETE);
    }

    public static enum ModificationType {
        DELETE,
        STYLE_RESET,
        EXTRA_STYLE_REMOVED,
        GROUP_CHANGED;

    }
}

