/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;

public class GeoServerConfigurationLock {
    public static long DEFAULT_TRY_LOCK_TIMEOUT_MS = GeoServerExtensions.getProperty((String)"CONFIGURATION_TRYLOCK_TIMEOUT") != null ? Long.valueOf(GeoServerExtensions.getProperty((String)"CONFIGURATION_TRYLOCK_TIMEOUT")) : 30000L;
    private static final Level LEVEL = Level.FINE;
    private static final Logger LOGGER = Logging.getLogger(GeoServerConfigurationLock.class);
    private static final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private static final ThreadLocal<LockType> currentLock = new ThreadLocal();
    private boolean enabled;

    public GeoServerConfigurationLock() {
        String pvalue = System.getProperty("GeoServerConfigurationLock.enabled");
        this.enabled = pvalue != null ? Boolean.parseBoolean(pvalue) : true;
        LOGGER.info("GeoServer configuration lock is " + (this.enabled ? "enabled" : "disabled"));
    }

    public void lock(LockType type) {
        if (!this.enabled) {
            return;
        }
        Lock lock = this.getLock(type);
        lock.lock();
        currentLock.set(type);
        if (LOGGER.isLoggable(LEVEL)) {
            LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " got the lock in mode " + (Object)((Object)type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(LockType type) {
        if (!this.enabled) {
            return true;
        }
        Lock lock = this.getLock(type);
        boolean res = false;
        try {
            res = lock.tryLock(DEFAULT_TRY_LOCK_TIMEOUT_MS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Thread " + Thread.currentThread().getId() + " thrown an InterruptedException on GeoServerConfigurationLock TryLock.", e);
            res = false;
        }
        finally {
            if (res) {
                currentLock.set(type);
            }
        }
        if (LOGGER.isLoggable(LEVEL)) {
            if (res) {
                LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " got the lock in mode " + (Object)((Object)type));
            } else {
                LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " could not get the lock in mode " + (Object)((Object)type));
            }
        }
        return res;
    }

    public void tryUpgradeLock() {
        LockType lock = currentLock.get();
        if (lock == null) {
            throw new IllegalStateException("No lock currently held");
        }
        if (lock == LockType.WRITE) {
            throw new IllegalStateException("Already owning a write lock");
        }
        this.unlock();
        if (!this.tryLock(LockType.WRITE)) {
            currentLock.set(null);
            throw new RuntimeException("Failed to upgrade lock from read to write state, please re-try the configuration operation");
        }
        currentLock.set(LockType.WRITE);
    }

    public void unlock() {
        if (!this.enabled) {
            return;
        }
        LockType type = this.getCurrentLock();
        if (type == null) {
            return;
        }
        try {
            Lock lock = this.getLock(type);
            if (LOGGER.isLoggable(LEVEL)) {
                LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " releasing the lock in mode " + (Object)((Object)type));
            }
            lock.unlock();
        }
        finally {
            currentLock.set(null);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private Lock getLock(LockType type) {
        Lock lock = type == LockType.WRITE ? readWriteLock.writeLock() : readWriteLock.readLock();
        if (LOGGER.isLoggable(LEVEL)) {
            LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " locking in mode " + (Object)((Object)type));
        }
        return lock;
    }

    public LockType getCurrentLock() {
        return currentLock.get();
    }

    public static enum LockType {
        READ,
        WRITE;

    }
}

