/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContext {
    private static final Logger LOG = LoggerFactory.getLogger(RequestContext.class);
    private static final ThreadLocal<RequestContext> CURRENT_CONTEXT = new ThreadLocal();
    private final Map<String, AtlasObjectId> updatedEntities = new HashMap<String, AtlasObjectId>();
    private final Map<String, AtlasObjectId> deletedEntities = new HashMap<String, AtlasObjectId>();
    private final Map<String, AtlasEntity.AtlasEntityWithExtInfo> entityCacheV2 = new HashMap<String, AtlasEntity.AtlasEntityWithExtInfo>();
    private final Map<String, List<AtlasClassification>> addedPropagations = new HashMap<String, List<AtlasClassification>>();
    private final Map<String, List<AtlasClassification>> removedPropagations = new HashMap<String, List<AtlasClassification>>();
    private final long requestTime = System.currentTimeMillis();
    private String user;
    private Set<String> userGroups;
    private String clientIPAddress;

    private RequestContext() {
    }

    public static RequestContext get() {
        RequestContext ret = CURRENT_CONTEXT.get();
        if (ret == null) {
            ret = new RequestContext();
            CURRENT_CONTEXT.set(ret);
        }
        return ret;
    }

    public static void clear() {
        RequestContext instance = CURRENT_CONTEXT.get();
        if (instance != null) {
            instance.updatedEntities.clear();
            instance.deletedEntities.clear();
            instance.entityCacheV2.clear();
            instance.addedPropagations.clear();
            instance.removedPropagations.clear();
        }
        CURRENT_CONTEXT.remove();
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getUserGroups() {
        return this.userGroups;
    }

    public void setUser(String user, Set<String> userGroups) {
        this.user = user;
        this.userGroups = userGroups;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setClientIPAddress(String clientIPAddress) {
        this.clientIPAddress = clientIPAddress;
    }

    public void recordEntityUpdate(AtlasObjectId entity) {
        if (entity != null && entity.getGuid() != null) {
            this.updatedEntities.put(entity.getGuid(), entity);
        }
    }

    public void recordEntityDelete(AtlasObjectId entity) {
        if (entity != null && entity.getGuid() != null) {
            this.deletedEntities.put(entity.getGuid(), entity);
        }
    }

    public void recordAddedPropagation(String guid, AtlasClassification classification) {
        if (StringUtils.isNotEmpty((String)guid) && classification != null) {
            List<AtlasClassification> classifications = this.addedPropagations.get(guid);
            if (classifications == null) {
                classifications = new ArrayList<AtlasClassification>();
            }
            classifications.add(classification);
            this.addedPropagations.put(guid, classifications);
        }
    }

    public void recordRemovedPropagation(String guid, AtlasClassification classification) {
        if (StringUtils.isNotEmpty((String)guid) && classification != null) {
            List<AtlasClassification> classifications = this.removedPropagations.get(guid);
            if (classifications == null) {
                classifications = new ArrayList<AtlasClassification>();
            }
            classifications.add(classification);
            this.removedPropagations.put(guid, classifications);
        }
    }

    public Map<String, List<AtlasClassification>> getAddedPropagations() {
        return this.addedPropagations;
    }

    public Map<String, List<AtlasClassification>> getRemovedPropagations() {
        return this.removedPropagations;
    }

    public void cache(AtlasEntity.AtlasEntityWithExtInfo entity) {
        if (entity != null && entity.getEntity() != null && entity.getEntity().getGuid() != null) {
            this.entityCacheV2.put(entity.getEntity().getGuid(), entity);
        }
    }

    public Collection<AtlasObjectId> getUpdatedEntities() {
        return this.updatedEntities.values();
    }

    public Collection<AtlasObjectId> getDeletedEntities() {
        return this.deletedEntities.values();
    }

    public AtlasEntity.AtlasEntityWithExtInfo getInstanceV2(String guid) {
        return this.entityCacheV2.get(guid);
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public boolean isUpdatedEntity(String guid) {
        return this.updatedEntities.containsKey(guid);
    }

    public boolean isDeletedEntity(String guid) {
        return this.deletedEntities.containsKey(guid);
    }
}

