/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.v1.typesystem.types.utils.TypesUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypesDefScrubber {
    private static final Logger LOG = LoggerFactory.getLogger(TypesDefScrubber.class);
    public static final String LEGACY_TYPE_NAME_PREFIX = "legacy";
    private final Map<String, ClassificationToStructDefName> edgeLabelToClassificationToStructDefMap = new HashMap<String, ClassificationToStructDefName>();
    private final Map<String, Integer> classificationIndexMap = new HashMap<String, Integer>();
    private AtlasTypesDef typesDef;

    public AtlasTypesDef scrub(AtlasTypesDef typesDef) {
        this.typesDef = typesDef;
        this.display("incoming: ", typesDef);
        this.createClassificationNameIndexMap(typesDef.getClassificationDefs());
        for (AtlasStructDef structDef : new ArrayList(typesDef.getStructDefs())) {
            this.checkAndUpdate(structDef);
        }
        for (AtlasEntityDef entityDef : typesDef.getEntityDefs()) {
            this.checkAndUpdate((AtlasStructDef)entityDef);
        }
        this.display("scrubbed: ", typesDef);
        return typesDef;
    }

    public Map<String, ClassificationToStructDefName> getTraitToTypeMap() {
        return this.edgeLabelToClassificationToStructDefMap;
    }

    public static String getEdgeLabel(String typeName, String attributeName) {
        return String.format("%s%s.%s", "__", typeName, attributeName);
    }

    public static String getLegacyTypeNameForStructDef(String name) {
        return String.format("%s_%s", LEGACY_TYPE_NAME_PREFIX, name);
    }

    private void display(String s, AtlasTypesDef typesDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(s + "{}", (Object)typesDef.toString());
        }
    }

    private void checkAndUpdate(AtlasStructDef structDef) {
        for (AtlasStructDef.AtlasAttributeDef attrDef : structDef.getAttributeDefs()) {
            ClassificationToStructDefName pair;
            String attrTypeName = this.getAttributeTypeName(attrDef.getTypeName());
            if (!this.classificationIndexMap.containsKey(attrTypeName) || (pair = this.createLegacyStructDefFromClassification(attrTypeName)) == null) continue;
            this.updateAttributeWithNewType(pair.getTypeName(), pair.getLegacyTypeName(), attrDef);
            this.addStructDefToTypesDef(structDef.getName(), attrDef.getName(), pair);
            LOG.info("scrubbed: {}:{} -> {}", new Object[]{structDef.getName(), attrDef.getName(), attrDef.getTypeName()});
        }
    }

    private String getAttributeTypeName(String typeName) {
        if (AtlasTypeUtil.isArrayType((String)typeName)) {
            int startIdx = "array<".length();
            int endIdx = typeName.length() - ">".length();
            String elementTypeName = typeName.substring(startIdx, endIdx).trim();
            return elementTypeName;
        }
        if (AtlasTypeUtil.isMapType((String)typeName)) {
            int endIdx;
            int startIdx = "map<".length();
            String[] keyValueTypes = typeName.substring(startIdx, endIdx = typeName.length() - ">".length()).split(",", 2);
            String valueTypeName = keyValueTypes.length > 1 ? keyValueTypes[1].trim() : null;
            return valueTypeName;
        }
        return typeName;
    }

    private void updateAttributeWithNewType(String oldTypeName, String newTypeName, AtlasStructDef.AtlasAttributeDef ad) {
        if (StringUtils.isEmpty((String)newTypeName)) {
            return;
        }
        String str = ad.getTypeName().replace(oldTypeName, newTypeName);
        ad.setTypeName(str);
    }

    private ClassificationToStructDefName createLegacyStructDefFromClassification(String typeName) {
        AtlasClassificationDef classificationDef = this.getClassificationDefByName(typeName);
        if (classificationDef == null) {
            return null;
        }
        AtlasStructDef structDef = this.getStructDefFromClassificationDef(classificationDef);
        this.addStructDefToTypesDef(structDef);
        return new ClassificationToStructDefName(classificationDef.getName(), structDef.getName());
    }

    private void addStructDefToTypesDef(AtlasStructDef structDef) {
        for (AtlasStructDef sDef : this.typesDef.getStructDefs()) {
            if (!StringUtils.equals((String)sDef.getName(), (String)structDef.getName())) continue;
            return;
        }
        this.typesDef.getStructDefs().add(structDef);
    }

    private void addStructDefToTypesDef(String typeName, String attributeName, ClassificationToStructDefName pair) {
        String key = TypesDefScrubber.getEdgeLabel(typeName, attributeName);
        this.edgeLabelToClassificationToStructDefMap.put(key, pair);
    }

    private AtlasClassificationDef getClassificationDefByName(String name) {
        if (this.classificationIndexMap.containsKey(name)) {
            return (AtlasClassificationDef)this.typesDef.getClassificationDefs().get(this.classificationIndexMap.get(name));
        }
        return null;
    }

    private AtlasStructDef getStructDefFromClassificationDef(AtlasClassificationDef classificationDef) {
        String legacyTypeName = TypesDefScrubber.getLegacyTypeNameForStructDef(classificationDef.getName());
        return new AtlasStructDef(legacyTypeName, classificationDef.getDescription(), classificationDef.getTypeVersion(), this.getDefaultAttributeDefsIfNecessary(classificationDef.getAttributeDefs()));
    }

    private List<AtlasStructDef.AtlasAttributeDef> getDefaultAttributeDefsIfNecessary(List<AtlasStructDef.AtlasAttributeDef> attributeDefs) {
        return attributeDefs.isEmpty() ? Collections.singletonList(new AtlasStructDef.AtlasAttributeDef("name", "string")) : attributeDefs;
    }

    private void createClassificationNameIndexMap(List<AtlasClassificationDef> classificationDefs) {
        for (int i = 0; i < classificationDefs.size(); ++i) {
            AtlasClassificationDef classificationDef = classificationDefs.get(i);
            this.classificationIndexMap.put(classificationDef.getName(), i);
        }
    }

    public static class ClassificationToStructDefName
    extends TypesUtil.Pair<String, String> {
        public ClassificationToStructDefName(String typeName, String legacyTypeName) {
            super((Object)typeName, (Object)legacyTypeName);
        }

        public String getTypeName() {
            return (String)this.left;
        }

        public String getLegacyTypeName() {
            return (String)this.right;
        }
    }
}

