/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration;

import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.janus.migration.ElementProcessors;
import org.apache.atlas.repository.graphdb.janus.migration.pc.WorkItemBuilder;
import org.apache.atlas.repository.graphdb.janus.migration.pc.WorkItemConsumer;
import org.apache.atlas.repository.graphdb.janus.migration.pc.WorkItemManager;
import org.apache.atlas.repository.graphdb.janus.migration.postProcess.PostProcessListProperty;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessManager {
    public static WorkItemsManager create(Graph bGraph, Map<String, Map<String, List<String>>> propertiesToPostProcess, int batchSize, int numWorkers) {
        ConsumerBuilder cb = new ConsumerBuilder(bGraph, propertiesToPostProcess, batchSize);
        return new WorkItemsManager(cb, batchSize, numWorkers);
    }

    static class WorkItemsManager
    extends WorkItemManager<Object, Consumer> {
        public WorkItemsManager(WorkItemBuilder builder, int batchSize, int numWorkers) {
            super(builder, batchSize, numWorkers);
        }
    }

    private static class ConsumerBuilder
    implements WorkItemBuilder<Consumer, Object> {
        private final Graph bulkLoadGraph;
        private final int batchSize;
        private final Map<String, Map<String, List<String>>> vertexPropertiesToPostProcess;

        public ConsumerBuilder(Graph bulkLoadGraph, Map<String, Map<String, List<String>>> propertiesToPostProcess, int batchSize) {
            this.bulkLoadGraph = bulkLoadGraph;
            this.batchSize = batchSize;
            this.vertexPropertiesToPostProcess = propertiesToPostProcess;
        }

        @Override
        public Consumer build(BlockingQueue<Object> queue) {
            return new Consumer(queue, this.bulkLoadGraph, this.vertexPropertiesToPostProcess, this.batchSize);
        }
    }

    static class Consumer
    extends WorkItemConsumer<Object> {
        private static final Logger LOG = LoggerFactory.getLogger(Consumer.class);
        private final Graph bulkLoadGraph;
        private final Map<String, Map<String, List<String>>> typePropertiesMap;
        private final int batchSize;
        private long counter;
        private long batchCounter;
        private final PostProcessListProperty processor;
        private final String[] nonPrimitiveCategoryKeys;

        public Consumer(BlockingQueue<Object> queue, Graph bulkLoadGraph, Map<String, Map<String, List<String>>> typePropertiesMap, int batchSize) {
            super(queue);
            this.bulkLoadGraph = bulkLoadGraph;
            this.typePropertiesMap = typePropertiesMap;
            this.batchSize = batchSize;
            this.counter = 0L;
            this.batchCounter = 0L;
            this.processor = new PostProcessListProperty();
            this.nonPrimitiveCategoryKeys = ElementProcessors.getNonPrimitiveCategoryKeys();
        }

        @Override
        public void processItem(Object vertexId) {
            ++this.batchCounter;
            ++this.counter;
            try {
                Vertex vertex = (Vertex)this.bulkLoadGraph.traversal().V(new Object[]{vertexId}).next();
                boolean isTypeVertex = vertex.property(Constants.TYPENAME_PROPERTY_KEY).isPresent();
                VertexProperty typeNameProperty = vertex.property(Constants.ENTITY_TYPE_PROPERTY_KEY);
                if (!isTypeVertex && typeNameProperty.isPresent()) {
                    String typeName = (String)typeNameProperty.value();
                    if (!this.typePropertiesMap.containsKey(typeName)) {
                        return;
                    }
                    Map<String, List<String>> collectionTypeProperties = this.typePropertiesMap.get(typeName);
                    for (String key : this.nonPrimitiveCategoryKeys) {
                        if (!collectionTypeProperties.containsKey(key)) continue;
                        for (String propertyName : collectionTypeProperties.get(key)) {
                            this.processor.process(vertex, typeName, propertyName);
                        }
                    }
                }
                this.commitBatch();
            }
            catch (Exception ex) {
                LOG.error("processItem: v[{}] error!", vertexId, (Object)ex);
            }
        }

        private void commitBatch() {
            if (this.batchCounter >= (long)this.batchSize) {
                LOG.info("[{}]: batch: {}: commit", (Object)this.counter, (Object)this.batchCounter);
                this.commit();
                this.batchCounter = 0L;
            }
        }

        @Override
        protected void doCommit() {
            this.bulkLoadGraph.tx().commit();
        }
    }
}

