/*
 * Decompiled with CFR 0.152.
 */
package epoint.frame.encrypt.sm2;

import epoint.frame.encrypt.security.FormartUtil;
import epoint.frame.encrypt.security.SecurityUtil;
import epoint.frame.encrypt.security.StringUtil;
import epoint.frame.encrypt.sm2.SM2;
import epoint.frame.encrypt.sm2.SM2Result;
import epoint.frame.encrypt.sm3.SM3Util;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.math.ec.ECPoint;

public class SM2SignUtil {
    private static final String SM2_KEY = "44F3362D7B5BFA8DE16CC7AACECCEEF5F96131B8C5C37251F604ADD25EE45693";
    private static HashMap<String, String> keys = new HashMap();

    public static String sign(String userId, String sourceData) throws IOException {
        return SM2SignUtil.sign(userId, SM2_KEY, sourceData, null);
    }

    public static String sign(String userId, String sourceData, boolean isOld) throws IOException {
        return SM2SignUtil.sign(userId, SM2_KEY, sourceData, isOld);
    }

    public static String sign(String userId, String privateKey, String sourceData) throws IOException {
        return SM2SignUtil.sign(userId, privateKey, sourceData, null);
    }

    public static String sign(String userId, String priKey, String sourceData, Boolean isOld) throws IOException {
        if (StringUtil.isBlank(priKey)) {
            return null;
        }
        if (isOld == null) {
            isOld = true;
        }
        String privateKey = SM2SignUtil.getPrivateKey(priKey, isOld);
        byte[] prikey = FormartUtil.hexToByte(privateKey);
        if (StringUtil.isBlank(sourceData)) {
            return null;
        }
        byte[] sd = sourceData.getBytes("utf-8");
        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(prikey);
        ECPoint userKey = sm2.ecc_point_g.multiply(userD);
        SM3Util sm3 = new SM3Util();
        byte[] z = sm2.sm2GetZ(userId.getBytes(), userKey);
        sm3.update(z, 0, z.length);
        sm3.update(sd, 0, sd.length);
        byte[] md = new byte[32];
        sm3.doFinal(md, 0);
        SM2Result sm2Result = new SM2Result();
        sm2.sm2Sign(md, userD, userKey, sm2Result);
        ASN1Integer d_r = new ASN1Integer(sm2Result.r);
        ASN1Integer d_s = new ASN1Integer(sm2Result.s);
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add((ASN1Encodable)d_r);
        v2.add((ASN1Encodable)d_s);
        DERSequence sign = new DERSequence(v2);
        byte[] signdata = sign.getEncoded("DER");
        return FormartUtil.getHexString(signdata);
    }

    public static boolean verifySign(String userId, String sourceData, String signData) throws IOException {
        return SM2SignUtil.verifySign(userId, SM2_KEY, sourceData, signData, null);
    }

    public static boolean verifySign(String userId, String sourceData, String signData, boolean isOld) throws IOException {
        return SM2SignUtil.verifySign(userId, SM2_KEY, sourceData, signData, isOld);
    }

    public static boolean verifySign(String userId, String privateKey, String sourceData, String signData) throws IOException {
        return SM2SignUtil.verifySign(userId, privateKey, sourceData, signData, null);
    }

    public static boolean verifySign(String userId, String privateKey, String sourceData, String signData, Boolean isOld) throws IOException {
        if (StringUtil.isBlank(privateKey)) {
            return false;
        }
        if (StringUtil.isBlank(sourceData)) {
            return false;
        }
        String sign = SM2SignUtil.sign(userId, privateKey, sourceData, isOld);
        return sign.equalsIgnoreCase(signData);
    }

    private static String getPrivateKey(String privateKey, boolean isOld) {
        String tempprik;
        String string = tempprik = isOld ? privateKey : String.valueOf(privateKey) + "_new";
        if (!keys.containsKey(tempprik)) {
            String newKey = isOld ? privateKey : SecurityUtil.getDealedHexString(privateKey, 256, "SM2_SIGN");
            keys.put(tempprik, newKey);
        }
        return keys.get(tempprik);
    }
}

