/*
 * Decompiled with CFR 0.152.
 */
package epoint.frame.encrypt.sm2;

import epoint.frame.encrypt.security.FormartUtil;
import epoint.frame.encrypt.sm2.SM2Result;
import epoint.frame.encrypt.sm3.SM3Util;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class SM2 {
    public static String[] ecc_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    public final BigInteger ecc_p = new BigInteger(ecc_param[0], 16);
    public final BigInteger ecc_a = new BigInteger(ecc_param[1], 16);
    public final BigInteger ecc_b = new BigInteger(ecc_param[2], 16);
    public final BigInteger ecc_n = new BigInteger(ecc_param[3], 16);
    public final BigInteger ecc_gx = new BigInteger(ecc_param[4], 16);
    public final BigInteger ecc_gy = new BigInteger(ecc_param[5], 16);
    public final ECCurve ecc_curve;
    public final ECPoint ecc_point_g;
    public final ECDomainParameters ecc_bc_spec;
    public final ECKeyPairGenerator ecc_key_pair_generator;
    public final ECFieldElement ecc_gx_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_gx);
    public final ECFieldElement ecc_gy_fieldelement = new ECFieldElement.Fp(this.ecc_p, this.ecc_gy);

    public static SM2 Instance() {
        return new SM2();
    }

    public SM2() {
        this.ecc_curve = new ECCurve.Fp(this.ecc_p, this.ecc_a, this.ecc_b);
        this.ecc_point_g = new ECPoint.Fp(this.ecc_curve, this.ecc_gx_fieldelement, this.ecc_gy_fieldelement, false);
        this.ecc_bc_spec = new ECDomainParameters(this.ecc_curve, this.ecc_point_g, this.ecc_n);
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init((KeyGenerationParameters)ecc_ecgenparam);
    }

    public byte[] sm2GetZ(byte[] userId, ECPoint userKey) {
        SM3Util sm3 = new SM3Util();
        int len = userId.length * 8;
        sm3.update((byte)(len >> 8 & 0xFF));
        sm3.update((byte)(len & 0xFF));
        sm3.update(userId, 0, userId.length);
        byte[] p = FormartUtil.byteConvert32Bytes(this.ecc_a);
        sm3.update(p, 0, p.length);
        p = FormartUtil.byteConvert32Bytes(this.ecc_b);
        sm3.update(p, 0, p.length);
        p = FormartUtil.byteConvert32Bytes(this.ecc_gx);
        sm3.update(p, 0, p.length);
        p = FormartUtil.byteConvert32Bytes(this.ecc_gy);
        sm3.update(p, 0, p.length);
        p = FormartUtil.byteConvert32Bytes(userKey.getXCoord().toBigInteger());
        sm3.update(p, 0, p.length);
        p = FormartUtil.byteConvert32Bytes(userKey.getYCoord().toBigInteger());
        sm3.update(p, 0, p.length);
        byte[] md = new byte[sm3.getDigestSize()];
        sm3.doFinal(md, 0);
        return md;
    }

    public void sm2Sign(byte[] md, BigInteger userD, ECPoint userKey, SM2Result sm2Result) {
        BigInteger e = new BigInteger(1, md);
        BigInteger k = null;
        ECPoint kp = null;
        BigInteger r = null;
        BigInteger s = null;
        while (true) {
            String kS = "6CB28D99385C175C94F94E934817663FC176D925DD72B727260DBAAE1FB2F96F";
            k = new BigInteger(kS, 16);
            kp = this.ecc_point_g.multiply(k);
            r = e.add(kp.getXCoord().toBigInteger());
            if ((r = r.mod(this.ecc_n)).equals(BigInteger.ZERO) || r.add(k).equals(this.ecc_n)) continue;
            BigInteger da_1 = userD.add(BigInteger.ONE);
            da_1 = da_1.modInverse(this.ecc_n);
            s = r.multiply(userD);
            s = k.subtract(s).mod(this.ecc_n);
            if (!(s = da_1.multiply(s).mod(this.ecc_n)).equals(BigInteger.ZERO)) break;
        }
        sm2Result.r = r;
        sm2Result.s = s;
    }

    public void sm2Verify(byte[] md, ECPoint userKey, BigInteger r, BigInteger s, SM2Result sm2Result) {
        sm2Result.R = null;
        BigInteger e = new BigInteger(1, md);
        BigInteger t = r.add(s).mod(this.ecc_n);
        if (!t.equals(BigInteger.ZERO)) {
            ECPoint x1y1 = this.ecc_point_g.multiply(sm2Result.s);
            x1y1 = x1y1.add(userKey.multiply(t));
            sm2Result.R = e.add(x1y1.getXCoord().toBigInteger()).mod(this.ecc_n);
        }
    }

    public ECPoint getUserKey(BigInteger bigInteger) {
        SM2 sm2 = SM2.Instance();
        return sm2.ecc_point_g.multiply(bigInteger);
    }
}

