/*
 * Decompiled with CFR 0.152.
 */
package epoint.frame.encrypt.security;

import epoint.frame.encrypt.security.FormartUtil;
import epoint.frame.encrypt.security.StringUtil;
import java.math.BigInteger;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.KeyGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class SecurityUtil {
    public static final int KEY_SIZE_128 = 128;
    public static final int HEX_KEY_SIZE_128 = 32;
    public static final int SUBSTRING_KEY_SIZE_128 = 16;
    public static final int KEY_SIZE_224 = 224;
    public static final int HEX_KEY_SIZE_224 = 56;
    public static final int SUBSTRING_KEY_SIZE_224 = 28;
    public static final int KEY_SIZE_256 = 256;
    public static final int HEX_KEY_SIZE_256 = 64;
    public static final int SUBSTRING_KEY_SIZE_256 = 32;
    public static final String SM2_DEFAULT_PRIVATE_KEY = "646AF6FC57D918E01C90DBF67C2BE044";
    public static final String SM2_SIGN_DEFAULT_PRIVATE_KEY = "44F3362D7B5BFA8DE16CC7AACECCEEF5";
    public static final String SM4_SIGN_DEFAULT_PRIVATE_KEY = "D2C1330C61577B52";

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static String generateKeySM2() throws Exception {
        return SecurityUtil.generateKeySM2(256);
    }

    public static String generateKeySM2(int size) throws Exception {
        if (size <= 0) {
            return null;
        }
        BigInteger SM2_ECC_N = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
        SecureRandom random = new SecureRandom();
        BigInteger r = new BigInteger(size, random);
        BigInteger max = SM2_ECC_N.subtract(BigInteger.ONE);
        while (r.compareTo(max) >= 0) {
            r = new BigInteger(size / 2, random);
        }
        String hexString = FormartUtil.byteToHex(r.toByteArray());
        int realLength = SecurityUtil.getRealHexStringLength(size);
        if (hexString.startsWith("00") && hexString.length() > realLength) {
            hexString = hexString.substring(2, hexString.length());
        }
        return hexString;
    }

    public static String generateKeySM4() throws Exception {
        return SecurityUtil.generateKey(128);
    }

    public static String generateKey(int size) throws Exception {
        if (size <= 0) {
            return null;
        }
        KeyGenerator kg = KeyGenerator.getInstance("SM4", "BC");
        kg.init(size, new SecureRandom());
        byte[] keybytes = kg.generateKey().getEncoded();
        return FormartUtil.byteToHex(keybytes);
    }

    public static String getDealedHexString(String key, int size, String type) {
        if (size <= 0) {
            return null;
        }
        try {
            Hex.decode((String)key);
        }
        catch (Exception e) {
            throw new RuntimeException("\u3010" + type + "\u3011\u7b97\u6cd5\u914d\u7f6e\u7684key\u3010" + key + "\u3011\u4e0d\u662f16\u8fdb\u5236\u6570\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e");
        }
        int realLength = SecurityUtil.getRealHexStringLength(size);
        if (key.length() != realLength) {
            throw new RuntimeException("\u3010" + type + "\u3011\u7b97\u6cd5\u914d\u7f6e\u7684key\u3010" + key + "\u3011\u957f\u5ea6\u4e0d\u6ee1\u3010" + realLength + "\u3011\u4f4d\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e");
        }
        int sublength = SecurityUtil.getSubHexStringLength(size);
        String defaultKey = SecurityUtil.getDefaultKeyByType(type);
        String subPrik = key.length() > sublength ? key.substring(0, sublength) : key;
        return FormartUtil.generatePrivateKey(defaultKey, subPrik);
    }

    private static int getRealHexStringLength(int size) {
        int length = 0;
        switch (size) {
            case 128: {
                length = 32;
                break;
            }
            case 224: {
                length = 56;
                break;
            }
            case 256: {
                length = 64;
                break;
            }
            default: {
                length = size % 4 == 0 ? size / 4 : size / 4 + 2;
            }
        }
        return length;
    }

    private static int getSubHexStringLength(int size) {
        int length = 0;
        switch (size) {
            case 128: {
                length = 16;
                break;
            }
            case 224: {
                length = 28;
                break;
            }
            case 256: {
                length = 32;
                break;
            }
            default: {
                length = size / 4;
            }
        }
        return length;
    }

    private static String getDefaultKeyByType(String type) {
        String defaultKey = null;
        if (StringUtil.isBlank(type)) {
            return null;
        }
        switch (type) {
            case "SM2": {
                defaultKey = SM2_DEFAULT_PRIVATE_KEY;
                break;
            }
            case "SM2_SIGN": {
                defaultKey = SM2_SIGN_DEFAULT_PRIVATE_KEY;
                break;
            }
            case "SM4": {
                defaultKey = SM4_SIGN_DEFAULT_PRIVATE_KEY;
                break;
            }
            default: {
                defaultKey = SM2_DEFAULT_PRIVATE_KEY;
            }
        }
        return defaultKey;
    }
}

