package com.jsegov.tddj.workflow;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.services.interf.ILimitFieldService;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.services.interf.IYYDJService;
import com.jsegov.tddj.services.interf.IZXYYService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.DJKXB;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SJD;
import com.jsegov.tddj.vo.YYDJ;
import com.jsegov.tddj.vo.ZXYY;


//注销异议登记  没有用

public class WF_ZXYY implements WorkFlowEvent {

	public boolean doCreateAfter(PfWorkFlowInstanceVo arg0) {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean doDelAfter(PfWorkFlowInstanceVo instanceObj) {
		// TODO Auto-generated method stub
		String projectId = instanceObj.getProId();
		//删除项目表

		IProjectService projectService = (IProjectService)Container.getBean("projectService");
		projectService.deleteProject(projectId);
		//删除收件单

		ISJDService sjdService = (ISJDService)Container.getBean("sjdService");
		sjdService.deleteSJD(projectId);
		//删除收件单材料

		sjdService.deleteSJDCL(projectId);
		//删除登记卡续表

		IDJKXBService djkxbService = (IDJKXBService)Container.getBean("djkXbService");
		djkxbService.deleteDJKXB(projectId);
		//删除注销异议表

		IZXYYService zxyyService = (IZXYYService)Container.getBean("zxyyService");
		zxyyService.deleteZXYY(projectId);
		return false;
	}

	public boolean doGetBackAfter(WfInstance arg0, WfActivity arg1) {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean doStopAfter(PfWorkFlowInstanceVo arg0) {
		// TODO Auto-generated method stub
		return false;
	}

	public String doTurnAfter(WfInstance instanceObj, WfActivity wfac) {
		// TODO Auto-generated method stub
        String msg="";
        String projectId = instanceObj.getPRO_ID();
        IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
		String remark = platUtil.getActivityDesc(projectId, wfac.getWfacdefineid());
		//System.out.print("adid===="+activityID+"===projectId==="+projectId);

		if (remark.equals("注销异议登记")){
                    
			doTurnOverAfter(instanceObj,wfac);

		}
		return msg;
	}

	public boolean doTurnAfter(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean doTurnBackAfter(WfInstance arg0, WfActivity arg1) {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean doTurnBackAfter(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
		// TODO Auto-generated method stub
		return false;
	}

	public String doTurnBefore(WfInstance instanceObj, WfActivity wfac) {
		// TODO Auto-generated method stub
		String projectId = instanceObj.getPRO_ID();
		IPlatUtil platUtil=(IPlatUtil)Container.getBean("platUtil");
		String projecttype = platUtil.getWfRemarkByProjectId(projectId);
		String remark = platUtil.getActivityDesc(projectId, wfac.getWfacdefineid());	
		ILimitFieldService limitFieldService = (ILimitFieldService)Container.getBean("limitFieldService");
		return limitFieldService.checkLimitField(projecttype, remark, projectId);
	}

	public String doTurnBefore(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean doTurnOverAfter(WfInstance instanceObj, WfActivity wfac) {
		// TODO Auto-generated method stub
		String projectId = instanceObj.getPRO_ID();
		
		// 1 续表
		IZXYYService zxyyService = (IZXYYService)Container.getBean("zxyyService");
		ZXYY zxyy = zxyyService.getZXYY(projectId);
		String yyprojectid = zxyy.getYyProjectId();
		
		IYYDJService yydjService = (IYYDJService)Container.getBean("yydjService");
		YYDJ yydj = yydjService.getYYDJ(yyprojectid);
		
		ISJDService sjdService=(ISJDService)Container.getBean("sjdService");
		SJD sjd= sjdService.getSJD(projectId);
		
		IProjectService projectService = (IProjectService)Container.getBean("projectService");
		Project project = projectService.getProject(projectId);
		
		IDJKService djkService = (IDJKService)Container.getBean("djkService");
		DJK djk = djkService.getDJKByDjh(yydj.getDjh());
		String djkbh = "";
		Integer djkid = 0;
		if (djk!=null){
			djkbh = djk.getDjkbh();
			djkid = djk.getDjkId();
		}
		DJKXB djkxb = new DJKXB();
		djkxb.setDjkId(djkid);
		djkxb.setProjectId(projectId);
		djkxb.setDjh(yydj.getDjh());
		djkxb.setRq(CommonUtil.getCurrStrDate());
		
		djkxb.setDjjs(zxyy.getXbnr());
		djkxb.setDjkjbr(project.getCreater());
		//djkxb.setDjkshr(djkshr);
		djkxb.setDjrq(CommonUtil.getCurrStrDate());
		djkxb.setDwdm(project.getDwdm());
		djkxb.setTdzh(yydj.getTdzh());
		djkxb.setIslogout(0);
		djkxb.setIsprinted(0);
		djkxb.setDjkbh(djkbh);
		djkxb.setBsm(sjd.getBsm());
		//djkxb.setGhkh(ghkh);
		djkxb.setSqlx(sjd.getSqlx());//cf.getCflx()
		IDJKXBService djkxbService = (IDJKXBService)Container.getBean("djkXbService");
		if (djkxbService.getDJKXB(projectId) == null){
			djkxbService.insertDJKXB(djkxb);
		}else{
			djkxbService.updateDJKXB(djkxb);
		}
		
		// 2 更新异议记录 
		yydj.setIsjc(1);
		yydj.setJcrq(zxyy.getZxrq());
		yydjService.updateYYDJ(yydj);
		//给预查封djkxb 回填 djkid
		
		
		//3项目结束
		projectService.finishProject(projectId,CommonUtil.getCurrTime());
		return false;
	}


	public boolean doTurnPostAfter(PfWorkFlowInstanceVo arg0) {
		// TODO Auto-generated method stub
		return false;
	}

}
