package com.jsegov.tddj.workflow;


import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.services.interf.IFGINFOService;
import com.jsegov.tddj.services.interf.IFGZService;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.FGINFO;
import com.jsegov.tddj.vo.FGZ;
import com.jsegov.tddj.vo.SJD;


//分割登记
public class WF_FGDJ implements WorkFlowEvent {

	/**
	 * 项目转发后 --------节点传送拷贝数据

	 * @param 
	 * @param instanceObj 工作流实例对象

	 * @param wfac 活动实例对象
	 * @return
	 */
	public String doTurnAfter(WfInstance instanceObj, WfActivity wfac) {
		// TODO Auto-generated method stub
        String msg="";
		String oldProjectId="";
		String projectId = instanceObj.getPRO_ID();
		//获取活动描述
		IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
		String remark = platUtil.getActivityDesc(projectId, wfac.getWfacdefineid());
		
		//System.out.print("adid===="+activityID+"===projectId==="+projectId);
		if (remark.equals("分割登记")){
			
			// 1 分割证号赋值

			IFGZService fgzService = (IFGZService)Container.getBean("fgzService");
			List list = fgzService.getFGZByProjectID(projectId);
			FGZ fgz = new FGZ();
			if (list.size()>0)fgz=(FGZ)list.get(0);
			if (fgz.getFgzh()==null || fgz.getFgzh().equals(""))fgzService.updateFGZH(projectId);
			
			// 2 生成登记卡

			IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
			FGINFO fginfo = fginfoService.getFGINFO(projectId);
			IDJKService djkService = (IDJKService)Container.getBean("djkService");
			ISJDService sjdService = (ISJDService)Container.getBean("sjdService");
			SJD sjd = sjdService.getSJD(projectId);
			String dwdm  = "";
			if (sjd != null){
				dwdm = sjd.getDwdm();
			}
			//DJK zudjk = djkService.getDJKByDjh(fginfo.getDjh());
			//DJK zudjk = djkService.getDJK(projectId);
			DJK zudjk = djkService.getDJK(projectId);
			if(zudjk==null){
				zudjk = djkService.getDJKByDjh(fginfo.getDjh());
				if(zudjk!=null){
					oldProjectId=zudjk.getProjectId();
				}
			}
			if ( zudjk == null && !fginfo.getDjh().equals("")){
				//insert
				DJK djk = new DJK();
				djk.setProjectId(projectId);
				djk.setDjh(fginfo.getDjh());
				djk.setTh(fginfo.getTh());
				djk.setZdmj(fginfo.getZdmj());
				djk.setYt(fginfo.getYt());
				djk.setZl(fginfo.getZl());
				djk.setQsxz("国有土地使用权");
				djk.setQlr(fginfo.getQlr());
				djk.setDwxz(fginfo.getDwxz());
				djk.setTxdz(fginfo.getTxdz());
				djk.setSyqlx(fginfo.getSyqlx());
				djk.setZzrq(fginfo.getZzrq());
				djk.setIslogout(0);
				djk.setDwdm(dwdm);
				djk.setDjrq(CommonUtil.getCurrStrDate());
				djkService.insertDJK(djk);
			}else if (projectId.equals(oldProjectId) && !fginfo.getDjh().equals("")) {
				zudjk.setProjectId(projectId);
				zudjk.setDjh(fginfo.getDjh());
				zudjk.setTh(fginfo.getTh());
				zudjk.setZdmj(fginfo.getZdmj());
				zudjk.setYt(fginfo.getYt());
				zudjk.setZl(fginfo.getZl());
				zudjk.setQsxz("国有土地使用权");
				zudjk.setQlr(fginfo.getQlr());
				zudjk.setDwxz(fginfo.getDwxz());
				zudjk.setTxdz(fginfo.getTxdz());
				zudjk.setSyqlx(fginfo.getSyqlx());
				zudjk.setZzrq(fginfo.getZzrq());
				zudjk.setIslogout(0);
				zudjk.setDwdm(dwdm);
				zudjk.setDjrq(CommonUtil.getCurrStrDate());
				djkService.updateDJK(zudjk);
			}
		}
		//获取当前活动ID
		//String activityID = wfac.getWfacdefineid();
//		HttpServletRequest request = ServletActionContext.getRequest();
//		String userId = UserUtil.getUserId(request);
//		String userName = UserUtil.getUserName(request, userId);
//		String userDwdm = UserUtil.getUserRegionCode(request, userId);
//		String projectId = instanceObj.getPRO_ID();
//		String remark = PlatUtil.getActivityDesc(instanceObj, wfac);
//		//System.out.print("adid===="+remark+"===projectId==="+projectId);
//		XZQ xzq = CommonUtil.getXZQ();
//		String wfRemark = PlatUtil.getWfremarkByProjectId(projectId);
//		if (remark.equals("申请")){
//			// 申请节点传送

//			IGytdsyzService gytdsyzService = (IGytdsyzService)Container.getBean("gyTdsyzService");
//			if (gytdsyzService.getGYTDSYZ(projectId)==null){
//				IBHService bhService = (IBHService)Container.getBean("bhService");
//				GYTDSYZ gytdsyz = new GYTDSYZ();
//				gytdsyz.setProjectId(projectId);
//				gytdsyz.setIslogout(8);
//				gytdsyz.setOlddata(0);
//				gytdsyz.setIsprinted(0);
//				gytdsyz.setRmzf(CommonUtil.getXZQ().getXzqName());
//				gytdsyz.setTdzh(bhService.getGYTDSYZBH());
//				gytdsyzService.insertGYTDSYZ(gytdsyz);
//			}
//		}else if (remark.equals("分割登记")) {
//			// 分割节点传送

//			if (wfRemark.equals("分割登记") && xzq.getXzqName().equals("泰州市")){
//				IGytdsyzService gytdsyzService = (IGytdsyzService)Container.getBean("gyTdsyzService");
//				GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZ(projectId);
//				IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
//				FGINFO fginfo = new FGINFO();
//				fginfo.setProjectId(projectId);
//				fginfo = fginfoService.getFGINFO(fginfo);
//				//IBHService bhService = (IBHService)Container.getBean("bhService");
//				SPB spb = new SPB();
//				spb.setProjectId(projectId);
//				spb.setSpbh(gytdsyz.getTdzh());
//				spb.setSqlx(fginfo.getFgtype());
//				spb.setZtdzh(fginfo.getZtdzh());
//				spb.setDjh(fginfo.getDjh());
//				spb.setZdmj(fginfo.getZdmj());
//				spb.setZl(fginfo.getZl());
//				spb.setTh(fginfo.getTh());
//				spb.setSyqlx(fginfo.getSyqlx());
//				spb.setYt(fginfo.getYt());
//				spb.setZzrq(fginfo.getZzrq());
//				spb.setRf1_fddbrxm(fginfo.getFddbr());
//				spb.setRf1_dwxz(fginfo.getDwxz());
//				spb.setRf1_lxfs(fginfo.getLxdh());
//				spb.setRf1_txdz(fginfo.getTxdz());
//				spb.setQsxz("国有土地使用权");
//				spb.setDwdm(gytdsyz.getDwdm());
//				spb.setRmzf(CommonUtil.getXZQ().getXzqName());
//				spb.setRf1_dwmc(instanceObj.getWORKFLOW_INSTANCE_NAME());
//				ISPBService spbService = (ISPBService)Container.getBean("spbService");
//				if (spbService.getSPB(projectId) == null){
//					spbService.insertSPB(spb);
//				}else{
//					spbService.updateSPB(spb);
//				}
//			}else if(wfRemark.equals("分割登记标准版")){
//				// 1 分割证号赋值

//				IFGZService fgzService = (IFGZService)Container.getBean("fgzService");
//				fgzService.updateFGZH(projectId);
//				// 2 生成登记卡

//				IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
//				FGINFO fginfo = fginfoService.getFGINFO(projectId);
//				IDJKService djkService = (IDJKService)Container.getBean("djkService");
//				ISJDService sjdService = (ISJDService)Container.getBean("sjdService");
//				SJD sjd = sjdService.getSJD(projectId);
//				String dwdm  = "";
//				if (sjd != null){
//					dwdm = sjd.getDwdm();
//				}
//				DJK zudjk = djkService.getDJKByDjh(fginfo.getDjh());
//				if ( zudjk == null){
//					//insert
//					DJK djk = new DJK();
//					djk.setProjectId(projectId);
//					djk.setDjh(fginfo.getDjh());
//					djk.setTh(fginfo.getTh());
//					djk.setZdmj(fginfo.getZdmj());
//					djk.setYt(fginfo.getYt());
//					djk.setZl(fginfo.getZl());
//					djk.setQsxz("国有土地使用权");
//					djk.setQlr(fginfo.getQlr());
//					djk.setDwxz(fginfo.getDwxz());
//					djk.setTxdz(fginfo.getTxdz());
//					djk.setSyqlx(fginfo.getSyqlx());
//					djk.setZzrq(fginfo.getZzrq());
//					djk.setIslogout(0);
//					djk.setDwdm(dwdm);
//					djk.setDjrq(CommonUtil.getCurrStrDate());
//					djkService.insertDJK(djk);
//				}else{
//					if (zudjk != null){
//						//update
//						//DJK djk = new DJK();
//						zudjk.setProjectId(projectId);
//						zudjk.setDjh(fginfo.getDjh());
//						zudjk.setTh(fginfo.getTh());
//						zudjk.setZdmj(fginfo.getZdmj());
//						zudjk.setYt(fginfo.getYt());
//						zudjk.setZl(fginfo.getZl());
//						zudjk.setQsxz("国有土地使用权");
//						zudjk.setQlr(fginfo.getQlr());
//						zudjk.setDwxz(fginfo.getDwxz());
//						zudjk.setTxdz(fginfo.getTxdz());
//						zudjk.setSyqlx(fginfo.getSyqlx());
//						zudjk.setZzrq(fginfo.getZzrq());
//						zudjk.setIslogout(0);
//						zudjk.setDwdm(dwdm);
//						zudjk.setDjrq(CommonUtil.getCurrStrDate());
//						djkService.updateDJK(zudjk);
//					}	
//				}
//			}
//		}else if (remark.equals("审核")) {
//			// 审核节点传送

//			
//		}	
		return msg;
	}
	
	
	/**
	 * 新增流程，写在ACTION中，这边不用
	 */
	public boolean doCreateAfter(PfWorkFlowInstanceVo instanceObj) {
		// TODO Auto-generated method stub
		return false;
	}

	/**
	 * 项目删除-------需要删除哪些业务表在这写

	 */
	public boolean doDelAfter(PfWorkFlowInstanceVo instanceObj) {
		// TODO Auto-generated method stub
		String projectId = instanceObj.getProId();
		//删除项目表

		IProjectService projectService = (IProjectService)Container.getBean("projectService");
		projectService.deleteProject(projectId);
		//删除收件单

		ISJDService sjdService = (ISJDService)Container.getBean("sjdService");
		sjdService.deleteSJD(projectId);
		//删除收件单材料

		sjdService.deleteSJDCL(projectId);
		//删除审批表

		ISPBService spbService = (ISPBService)Container.getBean("spbService");
		spbService.deleteSPB(projectId);
		//删除登记卡

		IDJKService djkService= (IDJKService)Container.getBean("djkService");
		djkService.deleteDJK(projectId);
		//删除登记卡续表

		IDJKXBService djkxbService = (IDJKXBService)Container.getBean("djkXbService");
		djkxbService.deleteDJKXB(projectId);
		//删除分割信息表

		IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
		fginfoService.deleteFGINFOByProjectID(projectId);
		//删除分割证

		FGZ fgz = new FGZ();
		fgz.setProjectId(projectId);
		IFGZService fgzService = (IFGZService)Container.getBean("fgzService");
		fgzService.deleteFGZ(fgz);
		//删除分割土地证

		IGytdsyzService gytdsyzService = (IGytdsyzService)Container.getBean("gyTdsyzService");
		gytdsyzService.deleteGYTDSYZ(projectId);
		//删除登记卡

		return false;
	}

	/**
	 * 项目取回
	 * @param instanceObj 工作流实例对象

	 * @param wfac  取回前节点

	 * @return
	 */
	public boolean doGetBackAfter(WfInstance instanceObj, WfActivity wfac) {
		// TODO Auto-generated method stub
		return false;
	}

	/**
	 * 项目终止后

	 * @param instanceObj
	 * @return
	 */
	public boolean doStopAfter(PfWorkFlowInstanceVo instanceObj) {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean doTurnAfter(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
		// TODO Auto-generated method stub
		return false;
	}

	/**
	 * 项目退回

	 * @param 
	 * @param instanceObj 工作流实例对象

	 * @param wfac 活动实例对象
	 * @return
	 */
	public boolean doTurnBackAfter(WfInstance instanceObj, WfActivity wfac) {
		// TODO Auto-generated method stub
		//System.out.println("退回");
		return false;
	}

	
	public boolean doTurnBackAfter(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
		// TODO Auto-generated method stub
		return false;
	}

	/**
	 * 工作流转发前
	 * @param 
	 * @param instanceObj 工作流实例对象

	 * @param wfac 活动实例对象
	 * @return
	 */
	public String doTurnBefore(WfInstance instanceObj, WfActivity wfac) {
		// TODO Auto-generated method stub
		Integer i = 0;
		Double zmj = 0.00;
		String projectId = instanceObj.getPRO_ID();
		String returnVul = null;
		IFGZService fgzService = (IFGZService)Container.getBean("fgzService");
		List list = fgzService.getFGZByProjectID(projectId);
		if (list.size()==0){
			returnVul = "请您分割后再转发！";
		}
		FGZ fgz = new FGZ();
		for (i = 0; i < list.size(); i++) {
			fgz = (FGZ) list.get(i);
			zmj += fgz.getJzmj();
		}
		NumberFormat nf=new DecimalFormat("0.00"); 
		zmj = new Double(nf.format(zmj));
		IFGINFOService fginfoService = (IFGINFOService) Container
				.getBean("fgInfoService");
		FGINFO fginfo = fginfoService.getFGINFO(projectId);

		if ((zmj - fginfo.getZjzmj()) != 0
				&& !(fginfo.getZjzmj() == 0.0 || fginfo.getZjzmj() == null)) {
			returnVul = "建筑面积之和为：" + zmj + "㎡，总建筑面积为：" + fginfo.getZjzmj()
					+ "㎡，请您检查！";
		}
		//String wdid = instanceObj.getWORKFLOW_DEFINITION_ID();
		//String projecttype = PlatUtil.getWfremark(wdid);
		//String remark = PlatUtil.getActivityDesc(instanceObj, wfac);
		//ILimitFieldService limitFieldService = (ILimitFieldService)Container.getBean("limitFieldService");
		//limitFieldService.checkLimitField(projecttype, remark, projectId);
		//System.out.println(returnVul);
		return returnVul;
	}
	
	public String doTurnBefore(PfWorkFlowInstanceVo arg0, PfActivityVo arg1) {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * 项目办结后

     * @param instanceObj 工作流实例对象

	 * @param wfac 活动实例对象
	 * @return
	 */
	public boolean doTurnOverAfter(WfInstance instanceObj, WfActivity wfac) {
		// TODO Auto-generated method stub
		String projectId = instanceObj.getPRO_ID();
		//XZQ xzq = CommonUtil.getXZQ();
		// 4 项目结束
		IProjectService projectService = (IProjectService)Container.getBean("projectService");
		projectService.finishProject(projectId, CommonUtil.getCurrDate());
		return false;
	}

	/**
	 * 项目挂起前

	 * @param arg0
	 * @return
	 */
	public boolean doTurnPostAfter(PfWorkFlowInstanceVo arg0) {
		// TODO Auto-generated method stub
		return false;
	}
	
}
