/*
 * Project: tdsc
 *
 * File: Log.java
 *
 * LastModified: 2011-02-23 04:10:39
 *
 * Copyright (c) 2011 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.jsegov.tddj.vo;

import com.gtis.generic.util.Struts2Utils;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:xuexing3212@sina.com">zhangxing</a>
 * @version V1.0, 11-2-23
 */
public class Log {

    public static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String id;
    private String action;
    private String content;
    private Date createTime;
    private String ip;
    private String userId;
    private String projectid;
    private String userName;

    static {
        ToStringBuilder.setDefaultStyle(new LogToStringStyle());
    }

    public static Log instance() {
        Log log = new Log();
        log.setCreateTime(new Date());
        try {
            log.setIp(Struts2Utils.getRemoteAddr());
        } catch (Exception ignored) {
        }
        if (StringUtils.isBlank(log.getUserId()))
            log.setUserId(SessionUtil.getCurrentUserId());
        return log;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getProjectid() {

        return projectid;
    }

    public void setProjectid(String projectid) {
        this.projectid = projectid;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    private static final class LogToStringStyle extends ToStringStyle {

        LogToStringStyle() {
            super();
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setContentStart("");
            this.setContentEnd("");
        }

        protected void appendDetail(StringBuffer buffer, String fieldName, Object value) {
            if (value instanceof Date) {
                value = df.format(value);
            }
            buffer.append(value);
        }
    }
}
