package com.jsegov.tddj.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class UserConfigManager {
	/* 配置资格证号文件路径 */
	private static String USER_CONFIG_PATH = "tddj/user-config.xml";

	/**
	 * 获取路径
	 * 
	 * @return
	 */
	private String getPath() {
		String basePath = this.getClass().getResource("/").getPath();
		basePath = basePath.replace("WEB-INF/classes/", "");
		return basePath + USER_CONFIG_PATH;
	}

	/**
	 * 获取Document对象
	 * 
	 * @return
	 */
	private Document getDocument() {
		SAXReader sr = new SAXReader();
		Document document = null;
		try {
			document = sr.read(new File(getPath()));
		} catch (DocumentException e) {
			e.printStackTrace();
		}
		return document;
	}

	/**
	 * 想文件中写Document对象
	 * 
	 * @param document
	 */
	private void writeDocument(Document document) {
		OutputFormat format = OutputFormat.createPrettyPrint();
		format.setEncoding("utf-8"); // 指定XML编码
		XMLWriter writer;
		try {
			writer = new XMLWriter(new FileOutputStream(getPath()), format);
			writer.write(document);
			writer.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 设置用户对应的颜色代码
	 */
	public String setColor(String userName, String colorCode) {
		// 获取Document对象
		Document document = getDocument();
		// 获取根节点

		Element root = document.getRootElement();
		// 标志 new or edit
		boolean flag = false;
		Element user = null;
		for (Iterator it = root.elementIterator(); it.hasNext();) {
			Element element = (Element) it.next();
			String str = element.attribute("name").getValue();
			if (str != null && str.equals(userName)) {// 已经存在
				flag = true;
				user = element;
				break;
			}
		}
		if (flag) {// 如果用户的id存在,则修改

			user.addAttribute("color", colorCode);
		} else {// 用户id不存在,则新增

			// 在root下添加一个Element
			user = root.addElement("user").addAttribute("name", userName).addAttribute("color", colorCode);
		}

		// 写Document
		this.writeDocument(document);

		return userName;
	}

	/**
	 * 通过用户的userid获取颜色代码
	 */
	public String getColor(String userName) {
		String resultColor = "";
		// 获取Document对象
		Document document = getDocument();
		// 获取根节点

		Element root = document.getRootElement();
		for (Iterator it = root.elementIterator(); it.hasNext();) {
			Element element = (Element) it.next();
			String str = element.attribute("name").getValue();
			if (str != null && str.equals(userName)) {// 已经存在
				resultColor = element.attribute("color").getValue();
				break;
			}
		}
		return resultColor;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		UserConfigManager usrManager = new UserConfigManager();
		//System.out.println(usrManager.getColor("0"));
		usrManager.setColor("1", Math.random() + "");
		//System.out.println(usrManager.getColor("1"));
	}

}
