package com.jsegov.tddj.util;

import java.io.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.jsegov.tddj.vo.ZGZH;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

import com.jsegov.tddj.vo.FTP;
import com.jsegov.tddj.vo.XZQ;

public class Common {
	static Log log = LogFactory.getLog("Common");
    /* 配置资格证号文件路径 */
    private static String ZGZHPATH = "tddj/zgzh.xml";

    public Document getTddjXml(){
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(getPath() + "conf/tddj/tddj.xml"));
        } catch (DocumentException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return document;
    }

	public String getUserName(){
		SAXReader sr = new SAXReader();
		Document document = null;
		String name = "";
		try {
			document = sr.read(new File(getPath() + "conf/tddj/tddj.xml"));
			Element root = document.getRootElement();
			Node node1 = root.selectSingleNode("//Config/user");
			DefaultElement element = (DefaultElement)node1;
			name = element.attribute("name").getText();		
		     
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return name;
	}
	public String getUserPassword(){
		SAXReader sr = new SAXReader();
		Document document = null;
		String password = "";
		try {
			document = sr.read(new File(getPath() + "conf/tddj/tddj.xml"));
			Element root = document.getRootElement();
			Node node1 = root.selectSingleNode("//Config/user");
			DefaultElement element = (DefaultElement)node1;
			password = element.attribute("password").getText();		
		     
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return password;
	}
	public XZQ getXZQ() {
		/**
		 * 用途：获取行政区信息 
		 * 参数：

		 * 修改日期：

		 * 修改人：
		 */
		SAXReader sr = new SAXReader();
		Document document = null;
		try {
			// System.out.println(getPath());
			document = sr.read(new File(getPath() + "conf/tddj/tddj.xml"));
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Element root = document.getRootElement();
		Node node1 = root.selectSingleNode("//Config/xzq/xzqName");
		String xzqName = node1.getText();
		
		Node node2 = root.selectSingleNode("//Config/xzq/xzqShortName");
		String xzqShorName = node2.getText();
		
		Node node3=root.selectSingleNode("//Config/xzq/gytdsyz");
		String gyFormat=node3.getText();
		
		Node node4=root.selectSingleNode("//Config/xzq/jttdsyz");
		String jyFormat=node4.getText();
		
		Node node5=root.selectSingleNode("//Config/xzq/jttdsuz");
		String juFormat=node5.getText();
		
		Node node7=root.selectSingleNode("//Config/xzq/txqlzms");
		String txFormat=node7.getText();
		
		Node node8=root.selectSingleNode("//Config/xzq/bh");
		String bh=node8.getText();
		
		XZQ xzq = new XZQ();
		xzq.setXzqName(xzqName);
		xzq.setXzqShortName(xzqShorName);
		xzq.setGytdsyzFormat(gyFormat);
		xzq.setJttdsyzFormat(jyFormat);
		xzq.setJttdsuzFormat(juFormat);
		xzq.setTxqlzmsFormat(txFormat);
		xzq.setBh(bh);
		return xzq;
	}
	
	public Boolean isFilterByDjh() {
		/**
		 * 用途：读filter/djh的值 判断全局是否按地籍号过滤
		 * 参数：

		 * 修改日期：2009-3-3
		 * 修改人：刘仲阳

		 */
		Boolean resultVal = false;
		SAXReader sr = new SAXReader();
		Document document = null;
		try {
			// System.out.println(getPath());
			document = sr.read(new File(getPath() + "conf/tddj/tddj.xml"));
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Element root = document.getRootElement();
		Node node = root.selectSingleNode("//Config/filter/djh");
		String nodeVal = node.getText();
		if (nodeVal != null && nodeVal.equals("1")){
			resultVal = true;
		}
		return resultVal;
	}
	
	
	public Boolean isFilterByDwdm() {
		/**
		 * 用途：读filter/dwdm的值 判断全局是否按单位代码过滤

		 * 参数：

		 * 修改日期：2009-3-3
		 * 修改人：刘仲阳

		 */
		Boolean resultVal = false;
		SAXReader sr = new SAXReader();
		Document document = null;
		try {
			// System.out.println(getPath());
			document = sr.read(new File(getPath() + "conf/tddj/tddj.xml"));
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Element root = document.getRootElement();
		Node node = root.selectSingleNode("//Config/filter/dwdm");
		String nodeVal = node.getText();
		if (nodeVal != null && nodeVal.equals("1")){
			resultVal = true;
		}
		return resultVal;
	}
	
	
	public void setCURRENTYEAR(String curYear){
		/**
		 * 用途：写currentYear/value的值

		 * 参数：curYear 为年份字符串  形式"2008"
		 * 修改日期：2008-12-10
		 * 修改人：刘仲阳

		 */
		SAXReader sr = new SAXReader();
		Document document = null;
		try {
			document = sr.read(new File(getPath() + "conf/tddj/tddj.xml"));
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Element root = document.getRootElement();
		Node node1 = root.selectSingleNode("//Config/currentYear/value");
		node1.setText(curYear);
		try {
			OutputFormat format = OutputFormat.createPrettyPrint();
			format.setEncoding("GBK");
			XMLWriter output = new XMLWriter(new FileWriter(new File(getPath() + "conf/tddj/tddj.xml")),format);
			output.write(document);
	        output.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public String getCURRENTYEAR(){
		/**
		 * 用途：获取currentYear/value的值 结果为年份字符串 形式为"2008"
		 * 参数：

		 * 修改日期：2008-12-10
		 * 修改人：刘仲阳

		 */
		SAXReader sr = new SAXReader();
		Document document = null;
		try {
			document = sr.read(new File(getPath() + "conf/tddj/tddj.xml"));
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Element root = document.getRootElement();
		Node node1 = root.selectSingleNode("//Config/currentYear/value");
		String curYear = node1.getText();
		return  curYear;
	}
	
	public List<String> getAllNodeid(){
		/**
		 * 用途：获取全部的活动描述(节点名称)
		 * 参数：

		 * 修改日期：2009-1-22
		 * 修改人：
		 */
		List<String> listAllNodeid = new ArrayList<String>();
		SAXReader sr = new SAXReader();
		Document document = null;
		try {
			document = sr.read(new File(getPath() + "conf/tddj/node.xml"));
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Element root = document.getRootElement();
		List<Node> nodes = root.selectNodes("node");
		for (int i = 0 ; i < nodes.size() ; i++){
			listAllNodeid.add(nodes.get(i).getText());
		}
		return listAllNodeid;
	}
	
	public List<String> getAllSqlx(){
		/**
		 * 用途：获取全部的申请类型

		 * 参数：

		 * 修改日期：2009-1-22
		 * 修改人：
		 */
		List<String> listAllSqlx = new ArrayList<String>();
		SAXReader sr = new SAXReader();
		Document document = null;
		try {
			// System.out.println(getPath());
			document = sr.read(new File(getPath() + "conf/tddj/sqlx.xml"));
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			log.error("Common.getAllSqlx:"+e);
		}
		Element root = document.getRootElement();
		
		List<Node> djlxNodes = root.selectNodes("djlx");
		for (int i = 0 ; i < djlxNodes.size() ; i++){
			Element djlxElement = (Element)djlxNodes.get(i);   
			List<Node> qsxzNodes = djlxElement.selectNodes("qsxz");
			for (int j = 0 ; j < qsxzNodes.size() ; j++){
				Element qsxzElement = (Element)qsxzNodes.get(j);
				List<Node>  sqlxNodes = qsxzElement.selectNodes("sqlx");
				for (int k = 0 ; k < sqlxNodes.size(); k++){
					Element sqlxElement = (Element)sqlxNodes.get(k);
					if (sqlxElement.getText() != null && !sqlxElement.getText().equals("") && !listAllSqlx.contains(sqlxElement.getText()))
						listAllSqlx.add(sqlxElement.getText());
				}
			}			
		}
		return listAllSqlx;
	}
	
	private String getPath() {
		/**
		 * 用途：获取架包相对路径 用于定位xml文件
		 * 参数：

		 * 修改日期：

		 * 修改人：
		 */
		return this.getClass().getResource("/").getPath();
	}

	public FTP getFTP() {
		/**
		 * 用途：获取FTP地址 用于证书关系查看
		 * 参数：

		 * 修改日期：

		 * 修改人：
		 */
		SAXReader sr = new SAXReader();
		Document document = null;
		try {
			document = sr.read(new File(getPath() + "conf/tddj/tddj.xml"));
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Element root = document.getRootElement();
		Node node1 = root.selectSingleNode("//Config/ftp/ip");
		String ip = node1.getText();
		
		Node node2 = root.selectSingleNode("//Config/ftp/port");
		String port = node2.getText();

		FTP ftp = new FTP();
		ftp.setIp(ip);
		ftp.setPort(port);
		return ftp;
	}
	
	public String getPrecision(String type) {
		/**
		 * 用途：获取小数精度 根据conf/tddj/tddj.xml下配置

		 * 参数：

		 * 修改日期：

		 * 修改人：
		 */
		String precision = "";
		SAXReader sr = new SAXReader();
		Document document = null;
		try {
			// System.out.println(getPath());
			document = sr.read(new File(getPath() + "conf/tddj/tddj.xml"));
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Element root = document.getRootElement();
		if (type.equals("syq")) {
			Node node = root.selectSingleNode("//Config/precision/area/syq");
			precision = node.getText();
		} else if (type.equals("suq")) {
			Node node = root.selectSingleNode("//Config/precision/area/suq");
			precision = node.getText();
		} else if (type.equals("je")) {
			Node node = root.selectSingleNode("//Config/precision/money");
			precision = node.getText();
		} else if (type.equals("default")) {
			Node node = root.selectSingleNode("//Config/precision/area/default");
			precision = node.getText();
		}
		return precision;
	}
	
	public String getFileNameByCode(String fileCode) {
		String fileName = "";
		SAXReader sr = new SAXReader();
		Document document = null;
		try {
			// System.out.println(getPath());
			document = sr.read(new File(getPath() + "conf/tddj/FileRename.xml"));
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Element root = document.getRootElement();
		List list=root.selectNodes("//FileList/File[@FileCode=\\'"+fileCode+"\\']");
		Iterator it=list.iterator();    
	     while(it.hasNext()){    
	       Element elm=(Element)it.next();
	       //System.out.println(elm.attributeValue("FileName"));
	       fileName = elm.attributeValue("FileName");
	     }  
		
		//Node node = root.selectSingleNode("//FileList/File[@FileCode=\'"+fileCode+"\']");
		//fileName = node.getStringValue();
		
		
		return fileName;
	}
//	public String getArchiveProjectId(String xml){
//		//创建一个新的字符串
//        StringReader read = new StringReader(xml);
//        //创建新的输入源SAX 解析器将使用 InputSource 对象来确定如何读取 XML 输入
//        InputSource source = new InputSource(read);
//        //创建一个新的SAXBuilder
//        SAXBuilder sb = new SAXBuilder();
//        String archiveProjectId=null;
//        try{
//        	//通过输入源构造一个Document
//        	org.jdom.Document doc = sb.build(source);
//        	org.jdom.Element root = doc.getRootElement();
//        	org.jdom.Element result = root.getChild("result");
//        	if(result.getText()!=null && result.getText().equals("succeed")){
//        		org.jdom.Element archive = root.getChild("archive");
//        		List field=archive.getChildren("field");
//        		org.jdom.Element fieldId= (org.jdom.Element) field.get(field.size()-1);
//        		archiveProjectId=fieldId.getText();
//        	}
//        }catch (JDOMException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		return archiveProjectId;
//	}
	public String getArchiveProjectId(String xml){
		//创建一个新的字符串
        StringReader read = new StringReader(xml);
        //创建新的输入源SAX 解析器将使用 InputSource 对象来确定如何读取 XML 输入
        InputSource source = new InputSource(read);
        //创建一个新的SAXBuilder
        SAXBuilder sb = new SAXBuilder();
        String archiveProjectId=null;
        try{
        	//通过输入源构造一个Document
        	org.jdom.Document doc = sb.build(source);
        	org.jdom.Element root = doc.getRootElement();
        	org.jdom.Element result = root.getChild("archive");
        	if(result.getAttributeValue("result")!=null && result.getAttributeValue("result").equals("succeed")){
        		org.jdom.Element archive = root.getChild("archive");
        		List field=archive.getChildren("field");
        		org.jdom.Element fieldId= (org.jdom.Element) field.get(field.size()-1);
        		archiveProjectId=fieldId.getText();
        	}
        }catch (JDOMException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return archiveProjectId;
	}
//	public static void main(String[] args) {
//		Common a = new Common();
//		//XZQ xzq = a.getXZQ();
//		//System.out.println(a.getPrecision("suq"));
//		System.out.println(a.getFileNameByCode("0"));
//	}
    /**
     * 获取所有资格证号

     *
     * @return
     */
    public List<ZGZH> getZGZHList() {
        Document document = getDocument();
        Element root = document.getRootElement();
        List<ZGZH> result = new ArrayList<ZGZH>();
        for (Iterator it = root.elementIterator(); it.hasNext();) {
            Element element = (Element) it.next();
            ZGZH zgzh = new ZGZH();
            zgzh.setUserName(element.attribute("name").getValue());
            zgzh.setZgzh(element.getTextTrim());
            result.add(zgzh);
        }
        return result;
    }
    /**
     * 获取Document对象
     *
     * @return
     */
    private Document getDocument() {
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            document = sr.read(new File(getPath2() + ZGZHPATH));
        } catch (DocumentException e) {
            e.printStackTrace();
        }
        return document;
    }
    /**
     * 获取路径2
     *
     * @return
     */
    private String getPath2() {
        String basePath = this.getClass().getResource("/").getPath();
        basePath = basePath.replace("WEB-INF/classes/", "");
        return basePath;
    }
    /**
     * 删除资格证号
     *
     * @param zgzh
     */
    public void deleteZGZH(ZGZH zgzh) {
        // 获取Document对象
        Document document = getDocument();
        // 获取根节点

        Element root = document.getRootElement();
        // 遍历root下所有Element
        for (Iterator it = root.elementIterator(); it.hasNext();) {
            Element element = (Element) it.next();
            String str = element.attribute("name").getValue();
            if (str != null && str.equals(zgzh.getUserName())) {
                // 删除
                root.remove(element);
                // 写文档

                writeDocument(document);
            }
        }
    }
    /**
     * 删除资格证号
     *
     * @param userName
     */
    public void deleteZGZH(String userName) {
        ZGZH zgzh = new ZGZH();
        zgzh.setUserName(userName);
        this.deleteZGZH(zgzh);
    }

    /**
     * 编辑资格证号
     *
     * @param zgzh
     */
    @SuppressWarnings("deprecation")
    public void editZGZH(ZGZH zgzh) {
        // 获取Document对象
        Document document = getDocument();
        // 获取根节点

        Element root = document.getRootElement();
        boolean flag = false;
        Element user = null;
        for (Iterator it = root.elementIterator(); it.hasNext();) {
            Element element = (Element) it.next();
            String str = element.attribute("name").getValue();
            if (str != null && str.equals(zgzh.getUserName())) {// 已经存在
                flag = true;
                user = element;
                break;
            }
        }
        if (flag) {// 已经存在
            user.setText(zgzh.getZgzh());
        } else {// 新增
            // 在root下添加一个Element
            user = root.addElement("user").addAttribute("name", zgzh.getUserName()).addText(zgzh.getZgzh());
        }
        // 写入文档
        writeDocument(document);
    }
    /**
     * 写Document对象
     *
     * @param document
     */
    private void writeDocument(Document document) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8"); // 指定XML编码
        XMLWriter writer;
        try {
            // writer = new XMLWriter(new FileWriter(getPath() +
            // "conf/tddj/zgzh.xml"), format);
            writer = new XMLWriter(new FileOutputStream(getPath2() + ZGZHPATH), format);
            writer.write(document);
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
