package com.jsegov.tddj.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IStatFGZService;
import com.jsegov.tddj.services.interf.IStatTDZService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.util.GetStatSQL;
import com.jsegov.tddj.vo.StatTDZ;
import com.jsegov.tddj.vo.StatTDZForPrint;
import com.jsegov.tddj.vo.StatTDZResult;

public class statReport extends HttpServlet{

	/**
	 * 
	 */
	private static final long serialVersionUID = -2657664101907062843L;

	@Override
	public void destroy() {
		// TODO Auto-generated method stub
		super.destroy();
	}

	@Override
	public void init() throws ServletException {
		// TODO Auto-generated method stub
		super.init();
	}

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		// TODO Auto-generated method stub
		//super.doGet(req, resp);
		String sheetName=new String(request.getParameter("sheetName").getBytes("ISO8859_1"),"GBK");
		String djh="";
		String tdzh="";
		String qlr="";
		if(request.getParameter("tdzh")!=null && !request.getParameter("tdzh").equals("")){
			tdzh=new String(request.getParameter("tdzh").getBytes("ISO8859_1"),"GBK");
		}
		if(request.getParameter("qlr")!=null && !request.getParameter("qlr").equals("")){
			qlr=new String(request.getParameter("qlr").getBytes("ISO8859_1"),"GBK");
		}
		String ksrq="";
		String jsrq="";
		String zslx="";
		String spectype=request.getParameter("spectype");
		if (request.getParameter("zslx")!=null){
			zslx=new String(request.getParameter("zslx").getBytes("ISO8859_1"),"GBK");
		}
		StringBuffer sb = new StringBuffer();
		String resultXML = null;
		List list = null;
		sb.append("<?xml version=\"1.0\" encoding=\"GBK\"?>");
		sb.append("<fetchdatas><datas></datas>");
		HashMap<String, Object> map = new HashMap<String, Object>();
		if (request.getParameter("djh") != null){
			djh = request.getParameter("djh");
			if (!djh.equals("")){
				map.put("djh", "%"+djh+"%");
			}
		}
		
		if (qlr!= null){
			if (!qlr.equals("")){
				map.put("qlr", "%"+qlr+"%");
			}
		}
		
		if (request.getParameter("ksrq") != null){
			ksrq = request.getParameter("ksrq");
			if (!ksrq.equals("")){
				map.put("ksrq",CommonUtil.formateDateToStr(ksrq));
			}
		}
		
		if (request.getParameter("jsrq") != null){
			jsrq = request.getParameter("jsrq");
			if (!jsrq.equals("")){
				map.put("jsrq", CommonUtil.formateDateToStr(jsrq));
			}
		}
		if (sheetName.equals("statfgz")){
			if (tdzh != null){
				if (!tdzh.equals("")){
					map.put("ztdzh", "%"+tdzh+"%");
				}
			}
			IStatFGZService statFGZService = (IStatFGZService)Container.getBean("statFgzService");
			list = statFGZService.statFGZ(map);
		}else if(sheetName.equals("statzs")){
//			if (tdzh != null){
//				if (!tdzh.equals("")){
//					map.put("tdzh", "%"+tdzh+"%");
//				}
//			}
//			IStatTDZService statTDZService = (IStatTDZService)Container.getBean("statTdzService");
//			list = statTDZService.statTDZ(map,zslx);
			IStatTDZService statTDZService=(IStatTDZService)Container.getBean("statTdzService");
			//统计证书
			ArrayList<StatTDZResult> statList=new ArrayList<StatTDZResult>();
			//统计证书
			StringBuffer sqlstr=new StringBuffer();
			sqlstr=GetStatSQL.getStatTDZSQLForChart(spectype, zslx, ksrq, jsrq);
			statList = statTDZService.getStatTDZ(sqlstr.toString());
			list=new ArrayList<StatTDZForPrint>();
			for(int i=0;i<statList.size();i++){
				StatTDZForPrint statTdz=new StatTDZForPrint();
				statTdz.setDwmc(statList.get(i).getDwmc());
				if(statList.get(i).getZj()!=null && !statList.get(i).getZj().equals("")){
					statTdz.setAllnum(Integer.parseInt(statList.get(i).getZj()));
				}else{
					statTdz.setAllnum(0);
				}
				statTdz.setZmj(CommonUtil.formatNumber(statList.get(i).getMj()));
				list.add(statTdz);
			}
			
		}
		resultXML = CommonUtil.getDetailXML(list,sheetName);
		sb.append(resultXML);
		sb.append("</fetchdatas>");
		//System.out.println(sb.toString());
		response.setContentType("text/xml;charset=GBK");
		response.getOutputStream().write(sb.toString().getBytes());
		response.getOutputStream().flush();
		response.getOutputStream().close();
	}

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		// TODO Auto-generated method stub
		doGet(req, resp);
	}

	

}
