package com.jsegov.tddj.servlet;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.HashMap;

import javax.servlet.http.HttpSession;

import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.servlet.ServletUtilities;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.ui.TextAnchor;
import java.net.URLEncoder;

import com.jsegov.tddj.util.CommonUtil;

public class WebChart {
    private HashMap<String, Object> paramMap;
    private String selVal1;
    private String selVal;
    
    /**
	 * 获取鼠标提示
	 *
	 */
	private final class CategoryToolTipGeneratorImplementation implements
			CategoryToolTipGenerator {
		public String generateToolTip(CategoryDataset dataset, int series,
				int index) {
			// TODO Auto-generated method stub
			return String.valueOf(dataset.getValue(series, index));
		}
	}
	
	/**
	 * 获取点击对象的URL
	 *
	 */
	private final class CategoryURLGeneratorImplementation implements
			CategoryURLGenerator {
		public String generateURL(CategoryDataset dataset, int series,
				int index) {
			// TODO Auto-generated method stub
			String colKey = (String)dataset.getColumnKey(index);
			if (colKey.equals("未定义")) colKey = null;
			String rowKey = (String)dataset.getRowKey(series);
			if (rowKey.equals("未定义")) rowKey = null;
			paramMap.put(selVal, colKey);
			paramMap.put(selVal1, rowKey);

			String sUrl = "";
			String zslx="";
			String dwmc="";
			String dwxz="";
			String qsxz="";
			String syqlx="";
			String yt="";
			String zsstate="";
			String sqlx="";
			String djlx="";
			if (paramMap.get("zslx")!=null)
				zslx = URLEncoder.encode(paramMap.get("zslx").toString());
			if (paramMap.get("dwmc")!=null)
				dwmc = URLEncoder.encode(paramMap.get("dwmc").toString());
			if (paramMap.get("dwxz")!=null)
				dwxz = URLEncoder.encode(paramMap.get("dwxz").toString());
			if (paramMap.get("qsxz")!=null)
				qsxz = URLEncoder.encode(paramMap.get("qsxz").toString());
			if (paramMap.get("syqlx")!=null)
				syqlx = URLEncoder.encode(paramMap.get("syqlx").toString());
			if (paramMap.get("yt")!=null)
				yt = URLEncoder.encode(paramMap.get("yt").toString());
			if (paramMap.get("zsstate")!=null)
				zsstate = URLEncoder.encode(paramMap.get("zsstate").toString());
			if (paramMap.get("sqlx")!=null)
				sqlx = URLEncoder.encode(paramMap.get("sqlx").toString());
			if (paramMap.get("djlx")!=null)
				djlx = URLEncoder.encode(paramMap.get("djlx").toString());
			sUrl = "statZS!showDetail.action?zslx="+zslx+"&dwmc="+dwmc
				  +"&dwxz="+dwxz+"&qsxz="+qsxz+"&syqlx="+syqlx
				  +"&yt="+yt+"&zsstate="+zsstate+"&sqlx="+sqlx
				  +"&djlx="+djlx
				  +"&ksrq="+(paramMap.get("ksrq")==null?"":paramMap.get("ksrq").toString())
				  +"&jsrq="+(paramMap.get("jsrq")==null?"":paramMap.get("jsrq").toString());
			//System.out.println(sUrl);
			return sUrl;//String.valueOf(dataset.getValue(series, index));
		}
	}
    
	private DefaultPieDataset pieDataset = new DefaultPieDataset();
    private DefaultCategoryDataset categotyDataset = new DefaultCategoryDataset();
    
    /**
     * 柱状图数据集
     * @param value 值轴值

     * @param rowKey 分类轴字段名
     * @param columnKey 分组轴字段名
     */
    public void setCategotyDatasetValue(double value,String rowKey,String columnKey) {
    	categotyDataset.setValue(value, rowKey, columnKey);
    }
    
    /**
     * 饼状图数据集
     * @param value 值轴值

     * @param key 字段名

     */
    public void setPieDatasetValue(String key, double value) {
    	pieDataset.setValue(key, value);
    }
    
    /**
     * 生成饼状图

     * @param title 标题名称
     * @param session session对象
     * @param pw 打印图表的printwiter流

     * @param width 图表宽

     * @param height 图表高

     * @return
     */
    public String generatePieChart(String title, HttpSession session, PrintWriter pw, int width, int height) {
        String filename = null;
        try {
        	//创建chart对象
            PiePlot plot = new PiePlot(pieDataset);
            //在统计图片上建连结

            //plot.setURLGenerator(new StandardPieURLGenerator("index.jsp","section"));
            plot.setToolTipGenerator(new StandardPieToolTipGenerator());
            JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
            chart.setBackgroundPaint(Color.white); //设置图片的背景色
            chart.setTitle(title);
            //把生成的图片放到临时目录
            ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
            //width是图片长度，height是图片高度

            filename = ServletUtilities.saveChartAsPNG(chart, width, height, info, session);
            ChartUtilities.writeImageMap(pw, filename, info, false);
            pw.flush();
        } catch (Exception e) {
//            System.out.println("Exception - " + e.toString());
            e.printStackTrace(System.out);
            filename = "error.png";
        }
        return filename;
    }
    /**
     * 生成柱状图

     * @param title 标题名称
     * @param session session对象
     * @param pw 打印图表的printwiter流

     * @param width 图表宽

     * @param height 图表高

     * @param catagoryAxisLabel 分类轴名称

     * @param catagoryAxisLabel1 分组轴名称

     * @param valueAxisLabel 值轴名称 
     * @param map 参数图

     * @return
     */
    public String generateCatagoryChart(String title, HttpSession session, PrintWriter pw,int width, int height,
    		String catagoryAxisLabel,String catagoryAxisLabel1,String valueAxisLabel,HashMap<String, Object> map){
    	String filename =null;
    	try{
    		//生成3D柱状图
    		JFreeChart chart = ChartFactory.createBarChart3D(title, 
    				catagoryAxisLabel, valueAxisLabel, categotyDataset,
                    PlotOrientation.VERTICAL, true, true, true);
    		//获得图表区域对象  
    		CategoryPlot plot = chart.getCategoryPlot();
    		/**没有数据配置*/ 
    		this.configNoData(chart, "没有查询到数据 !");
    		/**没有数据配置*/
    		Font labelFont = new Font("宋体", Font.TRUETYPE_FONT, 16);
    		/*
    		 * VALUE_TEXT_ANTIALIAS_OFF表示将文字的抗锯齿关闭,
    		 * 使用的关闭抗锯齿后，字体尽量选择12到14号的宋体字,这样文字最清晰好看
    		 */
    		chart.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    		chart.setTextAntiAlias(false);
    		chart.setBackgroundPaint(Color.white);
    		/**设置数据分段*/
    		// 设置数据分段个数
    		// 设置数据分段虚线可见
    		plot.setRangeGridlinesVisible(true);
    		// 设置数据分段虚线色彩
    		plot.setRangeGridlinePaint(Color.gray);
    		/**设置数据分段*/
    		/**数据轴精度*/
    		NumberAxis vn = (NumberAxis) plot.getRangeAxis();
    		//设置Y轴间隔
    		   Double dInterval= vn.getUpperBound();
    		if(dInterval>=10){
    			dInterval = vn.getUpperBound();
    			String sIntervalIntegerPart = (new DecimalFormat("#0")).format(dInterval);
        		Integer iIntervalLength = sIntervalIntegerPart.length()-1;
        		Integer iMax = Integer.parseInt(sIntervalIntegerPart.substring(0,1))+1;
        		dInterval = iMax * Math.pow(10, iIntervalLength)/5;
    		}else{
        		dInterval =1.0;
    		}
    		

    		//如果是一位数的话 这边这个可能会是小数  比如3时 dInterval 是 0.8 0.8设置成1 2011 hj 10 24
    		if(dInterval<1.0){
    			dInterval=1.0;
    		}
    		vn.setTickUnit(new NumberTickUnit(dInterval));
    		
    		//vn.setAutoRange(true);
    		// 数据轴数据标签的显示格式
    		DecimalFormat df = new DecimalFormat("#0");
    		vn.setNumberFormatOverride(df); 
    		/**数据轴精度*/
    		/**x轴设置*/
    		CategoryAxis domainAxis = plot.getDomainAxis();
    		domainAxis.setLabelFont(labelFont);// 轴标题

    		domainAxis.setTickLabelFont(labelFont);// 轴数值

    		// 横轴上的 Lable 是否完整显示
    		domainAxis.setMaximumCategoryLabelWidthRatio(0.6f);
    		// 设置距离图片左端距离
    		domainAxis.setLowerMargin(0.1);
    		// 设置距离图片右端距离
    		domainAxis.setUpperMargin(0.1);
    		// 设置 columnKey 是否间隔显示
    		//domainAxis.setSkipCategoryLabelsToFit(true);
    		plot.setDomainAxis(domainAxis);
    		/**x轴设置*/
    		// 设置柱图背景色（注意，系统取色的时候要使用16位的模式来查看颜色编码，这样比较准确）

    		plot.setBackgroundPaint(new Color(255, 255, 255));

    		/**y轴设置*/
    		ValueAxis rangeAxis = plot.getRangeAxis();
    		rangeAxis.setLabelFont(labelFont);
    		
    		rangeAxis.setTickLabelFont(labelFont);
    		// 设置最高的一个 Item 与图片顶端的距离
    		rangeAxis.setUpperMargin(0.15); 
    		// 设置最低的一个 Item 与图片底端的距离
    		rangeAxis.setLowerMargin(0.15);
    		rangeAxis.setLowerBound(0);   //设置从零开始
    		rangeAxis.setAutoRangeMinimumSize(10);

    		//以下注释掉 未注释情况下 小于10时 y轴显示10行 导致出现-坐标 hj 2011 10 24
    		//rangeAxis.setAutoRangeMinimumSize(10);

    		rangeAxis.setNegativeArrowVisible(false);
    		plot.setRangeAxis(rangeAxis);
    		/**y轴设置*/
    		/**renderer设置*/
//    		BarRenderer renderer = new BarRenderer();
    		BarRenderer3D renderer = new BarRenderer3D();
//    		CustomRenderer renderer = new CustomRenderer(new Paint[] {Color.cyan,Color.orange,Color.yellow});
    		// 设置柱子宽度
    		renderer.setMaximumBarWidth(0.05);
    		// 设置柱子高度
    		renderer.setMinimumBarLength(0.2);
    		// 设置柱子边框颜色
    		renderer.setBaseOutlinePaint(Color.BLACK);
    		// 设置柱子边框可见
    		renderer.setDrawBarOutline(true);
    		// 设置柱的颜色
//    		renderer.setSeriesPaint(0, new Color(255, 255, 60));
//    		renderer.setSeriesPaint(1, new Color(153, 204, 255));   
//    		renderer.setSeriesPaint(2, new Color(51, 204, 204));   
//    		// 设置柱的外框颜色
//    		renderer.setSeriesOutlinePaint(0, new Color(159,213,210));
//    		renderer.setSeriesOutlinePaint(1, Color.red);
//    		renderer.setSeriesOutlinePaint(2, Color.black);
    		
   
//    		renderer.setSeriesPaint(0, Color.decode("#24F4DB")); // 给series1 Bar 
//    		renderer.setSeriesPaint(1, Color.decode("#7979FF")); // 给series2 Bar 
//    		renderer.setSeriesPaint(2, Color.decode("#FF5555")); // 给series3 Bar 
//    		renderer.setSeriesOutlinePaint(0,Color.BLACK);//边框为黑色 
//     		renderer.setSeriesOutlinePaint(1,Color.RED);//边框为黑色 
//    		renderer.setSeriesOutlinePaint(2,Color.BLACK); //边框为黑色 
    		// 设置每个地区所包含的平行柱的之间距离

    		renderer.setItemMargin(0.1);

            //所有柱子创建鼠标提示

            CategoryToolTipGenerator catTG = new CategoryToolTipGeneratorImplementation();
            renderer.setBaseToolTipGenerator(catTG);
            //所有柱子创建URL连接显示详细信息
            if (catagoryAxisLabel.equals("证书类型")){
				selVal = "zslx";
			} else if (catagoryAxisLabel.equals("单位名称")) {
				selVal = "dwmc";
			} else if (catagoryAxisLabel.equals("单位性质")) {
				selVal = "dwxz";
			} else if (catagoryAxisLabel.equals("权属性质")) {
				selVal = "qsxz";
			} else if (catagoryAxisLabel.equals("使用权类型")) {
				selVal = "syqlx";
			} else if (catagoryAxisLabel.equals("用途")) {
				selVal = "yt";
			} else if (catagoryAxisLabel.equals("证书状态")) {
				selVal = "zsstate";
			} else if (catagoryAxisLabel.equals("申请类型")) {
				selVal = "sqlx";
			} else if (catagoryAxisLabel.equals("登记类型")) {
				selVal = "djlx";
			}
            if (catagoryAxisLabel1.equals("证书类型")){
            	selVal1 ="zslx";
			} else if (catagoryAxisLabel1.equals("单位名称")) {
				selVal1 = "dwmc";
			} else if (catagoryAxisLabel1.equals("单位性质")) {
				selVal1 = "dwxz";
			} else if (catagoryAxisLabel1.equals("权属性质")) {
				selVal1 = "qsxz";
			} else if (catagoryAxisLabel1.equals("使用权类型")) {
				selVal1 = "syqlx";
			} else if (catagoryAxisLabel1.equals("用途")) {
				selVal1 = "yt";
			} else if (catagoryAxisLabel1.equals("证书状态")) {
				selVal1 = "zsstate";
			} else if (catagoryAxisLabel1.equals("申请类型")) {
				selVal1 = "sqlx";
			} else if (catagoryAxisLabel1.equals("登记类型")) {
				selVal1 = "djlx";
			}
            
            paramMap = map;
            CategoryURLGenerator catUG = new CategoryURLGeneratorImplementation();
            renderer.setBaseItemURLGenerator(catUG);
            /**显示每个柱的数值，并修改该数值的字体属性*/
    		renderer.setIncludeBaseInRange(true);
    		renderer.setBaseItemLabelFont(labelFont);
    		renderer.setBaseItemLabelGenerator(new StandardCategoryItemLabelGenerator());
    		//此句很关键，若无此句，那数字的显示会被覆盖，给人数字没有显示出来的问题

    		renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER)); 
    		// 设置柱形图上的文字偏离值 
    		renderer.setItemLabelAnchorOffset(10D);
    		// 设置柱子的文字可见

    		renderer.setBaseItemLabelsVisible(true);
    		

    		/**显示每个柱的数值，并修改该数值的字体属性*/
    		/**renderer设置*/
    		//使用设计的效果 
            plot.setRenderer(renderer); 
            //设置plot背景色

    		plot.setBackgroundPaint(Color.green);
    		//设置plot数据区的边界线条颜色
    		plot.setOutlinePaint(Color.black);
    		//设置plot数据区的数据轴和分类轴网格线条颜色

    		plot.setRangeGridlinePaint(Color.black);
    		plot.setDomainGridlinePaint(Color.black);
            //设置纵轴的显示位置
    		
            plot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT);//分类值显示在下端(柱子竖直)或左侧(柱子水平)   
            //设置纵横坐标的显示位置  
            plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT); //范围值显示在下端(柱子水平)或左侧(柱子竖直)   
            //char 设置
            chart.setBorderVisible(true);	//边界线条可见
            chart.setBorderPaint(Color.black);	//设置边界颜色
    		chart.setBackgroundPaint(Color.white); //设置背景颜色
            chart.setTitle(title);
            //把生成的图片放到临时目录
            ChartRenderingInfo info = new ChartRenderingInfo(new StandardEntityCollection());
            //width是图片长度，height是图片高度

            filename = ServletUtilities.saveChartAsPNG(chart, width, height, info, session);
            ChartUtilities.writeImageMap(pw, filename, info, false);
            pw.flush();
    	}catch (Exception e) {
            e.printStackTrace(System.out);
            filename = "error.png";
    	}
    	
    	return filename;
    }
    
    /**
	 * 配置没有数据时的显示信息
	 * 
	 * @param chart
	 */
	private void configNoData(JFreeChart chart, String message) {
		CategoryPlot categoryplot = (CategoryPlot) chart.getPlot();
		// 没有数据时的显示
		categoryplot.setNoDataMessage(message);
		categoryplot.setNoDataMessageFont(new Font("黑体", Font.BOLD, 25));
	}
}