package com.jsegov.tddj.servlet;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.ICFService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.CF;

public class ShowCFListXML extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor of the object.
	 */
	public ShowCFListXML() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	/**
	 * The doGet method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		String tdzh = request.getParameter("tdzh");
		
		ICFService cfService = (ICFService)Container.getBean("cfService");
		tdzh= URLDecoder.decode(tdzh, "utf-8");
		List<CF> cfList=cfService.getCFByTdzh(tdzh);
		CommonUtil commonUtil=new CommonUtil();
		StringBuffer sb = new StringBuffer();
		sb.append("<?xml version=\"1.0\" encoding=\"GBK\"?>");
		sb.append("<rows>");
		for (int i = 0; i < cfList.size(); i++) {
			sb.append("<row id=\"");
			sb.append(i+1);
			sb.append("\" open=\"1\">");
			sb.append("<cell>"+cfList.get(i).getProjectId()+"</cell>");
			sb.append("<cell>"+cfList.get(i).getId()+"</cell>");
			if(cfList.get(i).getIsjf()!=null && cfList.get(i).getIsjf().equals("1")){
				sb.append("<cell>解封</cell>");
			}else{
				sb.append("<cell>查封</cell>");
			}
			sb.append("<cell>"+cfList.get(i).getDjh()+"</cell>");
			sb.append("<cell>"+cfList.get(i).getTdzh()+"</cell>");
			sb.append("<cell>"+cfList.get(i).getBzxr()+"</cell>");
			sb.append("<cell>"+cfList.get(i).getZxsqr()+"</cell>");
			if(cfList.get(i).getCfksrq()!=null && !cfList.get(i).getCfksrq().equals("")){
				sb.append("<cell>"+commonUtil.formateDate(cfList.get(i).getCfksrq())+"</cell>");
			}else{
				sb.append("<cell></cell>");
			}
			if(cfList.get(i).getSdrq()!=null && !cfList.get(i).getSdrq().equals("")){
				sb.append("<cell>"+commonUtil.formateDate(cfList.get(i).getSdrq())+"</cell>");
			}else{
				sb.append("<cell></cell>");
			}
			sb.append("<cell>"+cfList.get(i).getCddw()+"</cell>");
			sb.append("<cell>"+cfList.get(i).getZl()+"</cell>");
			sb.append("<cell>"+cfList.get(i).getCfmj()+"</cell>");
			sb.append("</row>");
		}
		sb.append("</rows>");
		//System.out.println(sb);
		response.setContentType("text/xml;charset=GBK");
		response.getOutputStream().write(sb.toString().getBytes());
		response.getOutputStream().flush();
		response.getOutputStream().close();
	}

	/**
	 * The doPost method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		doGet(request, response);
	}

	/**
	 * Initialization of the servlet. <br>
	 *
	 * @throws ServletException if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}

}
