package com.jsegov.tddj.servlet;

import java.util.List;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.ISJDCLService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.SJD;
import com.jsegov.tddj.vo.SJDCL;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class PrintSJD {
	public static String getPrintXML(String projectId){
		ISJDService sjdService=(ISJDService)Container.getBean("sjdService");
		SJD sjdvo=sjdService.getSJD(projectId);
		String dataXML = CommonUtil.getDataXML(sjdvo);
		
//		XZQ xzq = new XZQ();
//		xzq = CommonUtil.getXZQ();
//		String rmzf = xzq.getXzqName();
//		dataXML = dataXML.replace("</datas>", "<data name=\"rmzf\" type=\"String(50)\">"+rmzf+"<datas></datas>");
		
		ISJDCLService sjdclService=(ISJDCLService)Container.getBean("sjdClService");
		List<SJDCL> sjdclList=sjdclService.getSJDCL(projectId);
		String detailXML=CommonUtil.getDetailXML(sjdclList,"SJDCL");
		
		StringBuffer sb = new StringBuffer();
		sb.append(dataXML);
		sb.append(detailXML);
		return sb.toString();
	}

    public static Document getPrintXMLDoc(String projectId){
        Document doc = DocumentHelper.createDocument();
        Element page =  doc.addElement("page");

        ISJDService sjdService=(ISJDService)Container.getBean("sjdService");
        SJD sjdvo=sjdService.getSJD(projectId);

        page.add(CommonUtil.getDataXMLDoc(sjdvo).getRootElement());

        ISJDCLService sjdclService=(ISJDCLService)Container.getBean("sjdClService");
        List<SJDCL> sjdclList=sjdclService.getSJDCL(projectId);

        page.add(CommonUtil.getDetailXMLDoc(sjdclList,"SJDCL"));

        return doc;
    }
}
