package com.jsegov.tddj.servlet;

import java.io.UnsupportedEncodingException;
import java.util.List;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.services.interf.IFGINFOService;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.IJttdsyzService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.DJKXB;
import com.jsegov.tddj.vo.FGINFO;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.SPB;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class PrintDJK {
    public static String getPrintXML(String projectId){
        IDJKService djkService=(IDJKService)Container.getBean("djkService");
        DJK djkVo=djkService.getDJK(projectId);
        String dataXML= CommonUtil.getDataXML(djkVo);

        Integer djkId=djkVo.getDjkId();

        IDJKXBService djkxbService=(IDJKXBService)Container.getBean("djkXbService");
        List djkxbList=djkxbService.getDJKXBList(djkId);

        String detailXML=CommonUtil.getDetailXML(djkxbList,"DJKXB");
        //
        detailXML = detailXML.replaceAll("tdzh", "djkxbtdzh");
        StringBuffer sb = new StringBuffer();
        sb.append(dataXML);
        sb.append(detailXML);
        //System.out.println(sb.toString());
        return sb.toString();
    }

    /*
     *   根据项目ID获得相应的信息
     */
    public static Document getPrintXMLByProId(String projectId){
        Document doc = DocumentHelper.createDocument();
        Element page =  doc.addElement("page");

        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB spb = spbService.getSPB(projectId);
        String djh = "";
        if (spb!=null){
            djh=spb.getDjh();
        }
        if (djh==null || djh.equals("")){
            IGytdsyzService gytdsyzService = (IGytdsyzService)Container.getBean("gyTdsyzService");
            GYTDSYZ gytdsyz= gytdsyzService.getGYTDSYZ(projectId);
            if (gytdsyz!=null)djh = gytdsyz.getDjh();
        }
        if (djh==null || djh.equals("")){
            IJttdsyzService jttdsyzService = (IJttdsyzService)Container.getBean("jtTdsyzService");
            JTTDSYZ jttdsyz= jttdsyzService.getJTTDSYZ(projectId);
            if (jttdsyz!=null)djh = jttdsyz.getDjh();
        }
        if (djh==null || djh.equals("")){
            IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
            FGINFO fginfo = fginfoService.getFGINFO(projectId);
            if (fginfo!=null)djh = fginfo.getDjh();
        }
        if (djh==null || djh.equals("")){
            IDJKService djkService = (IDJKService) Container.getBean("djkService");
            DJK djk = djkService.getDJK(projectId);
            djh = djk.getDjh();
        }
        IDJKService djkService = (IDJKService) Container.getBean("djkService");
        DJK djkVo = djkService.getDJKByDjh(djh);

        //将登记卡组成的Datas装入page节点中
        page.add(CommonUtil.getDataXMLDoc(djkVo).getRootElement());

        IDJKXBService djkxbService=(IDJKXBService)Container.getBean("djkXbService");
        List djkxbList=djkxbService.getDJKXBList(djh);

        page.add(CommonUtil.getDjkxbDetailXMLDoc(djkxbList,"DJKXB").getRootElement());

        return doc;
    }

    public static String getPrintXMLByDjh(String projectId){
        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB spb = spbService.getSPB(projectId);
        String djh = "";
        if (spb!=null){
            djh=spb.getDjh();
        }
        if (djh==null || djh.equals("")){
            IGytdsyzService gytdsyzService = (IGytdsyzService)Container.getBean("gyTdsyzService");
            GYTDSYZ gytdsyz= gytdsyzService.getGYTDSYZ(projectId);
            if (gytdsyz!=null)djh = gytdsyz.getDjh();
        }
        if (djh==null || djh.equals("")){
            IJttdsyzService jttdsyzService = (IJttdsyzService)Container.getBean("jtTdsyzService");
            JTTDSYZ jttdsyz= jttdsyzService.getJTTDSYZ(projectId);
            if (jttdsyz!=null)djh = jttdsyz.getDjh();
        }
        if (djh==null || djh.equals("")){
            IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
            FGINFO fginfo = fginfoService.getFGINFO(projectId);
            if (fginfo!=null)djh = fginfo.getDjh();
        }
        if (djh==null || djh.equals("")){
            IDJKService djkService = (IDJKService) Container.getBean("djkService");
            DJK djk = djkService.getDJK(projectId);
            djh = djk.getDjh();
        }
        IDJKService djkService = (IDJKService) Container.getBean("djkService");
        DJK djkVo = djkService.getDJKByDjh(djh);

        //DJK djkVo=djkService.getDJK(projectId);
        String dataXML= CommonUtil.getDataXML(djkVo);
        //Integer djkId=djkVo.getDjkId();

        IDJKXBService djkxbService=(IDJKXBService)Container.getBean("djkXbService");
        //List djkxbList=djkxbService.getDJKXBList(djkId);
        List djkxbList=djkxbService.getDJKXBList(djh);

        String detailXML=CommonUtil.getDjkxbDetailXML(djkxbList,"DJKXB");

        StringBuffer sb = new StringBuffer();
        sb.append(dataXML);
        sb.append(detailXML);

        return sb.toString();
    }


    public static String getDjkZkXMLByDjh(String projectId){
        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB spb = spbService.getSPB(projectId);
        String djh = "";
        if (spb!=null){
            djh=spb.getDjh();
        }
        if (djh==null || djh.equals("")){
            IGytdsyzService gytdsyzService = (IGytdsyzService)Container.getBean("gyTdsyzService");
            GYTDSYZ gytdsyz= gytdsyzService.getGYTDSYZ(projectId);
            if (gytdsyz!=null)djh = gytdsyz.getDjh();
        }
        if (djh==null || djh.equals("")){
            IJttdsyzService jttdsyzService = (IJttdsyzService)Container.getBean("jtTdsyzService");
            JTTDSYZ jttdsyz= jttdsyzService.getJTTDSYZ(projectId);
            if (jttdsyz!=null)djh = jttdsyz.getDjh();
        }
        if (djh==null || djh.equals("")){
            IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
            FGINFO fginfo = fginfoService.getFGINFO(projectId);
            if (fginfo!=null)djh = fginfo.getDjh();
        }
        if (djh==null || djh.equals("")){
            IDJKService djkService = (IDJKService) Container.getBean("djkService");
            DJK djk = djkService.getDJK(projectId);
            djh = djk.getDjh();
        }
        IDJKService djkService = (IDJKService) Container.getBean("djkService");
        DJK djkVo = djkService.getDJKByDjh(djh);

        String dataXML= CommonUtil.getDataXML(djkVo);

        StringBuffer sb = new StringBuffer();
        sb.append(dataXML);

        return sb.toString();
    }

    public static String getDjkxbXMLByDjh(String projectId){
        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB spb = spbService.getSPB(projectId);
        String djh = "";
        if (spb!=null){
            djh=spb.getDjh();
        }
        if (djh==null || djh.equals("")){
            IGytdsyzService gytdsyzService = (IGytdsyzService)Container.getBean("gyTdsyzService");
            GYTDSYZ gytdsyz= gytdsyzService.getGYTDSYZ(projectId);
            if (gytdsyz!=null)djh = gytdsyz.getDjh();
        }
        if (djh==null || djh.equals("")){
            IJttdsyzService jttdsyzService = (IJttdsyzService)Container.getBean("jtTdsyzService");
            JTTDSYZ jttdsyz= jttdsyzService.getJTTDSYZ(projectId);
            if (jttdsyz!=null)djh = jttdsyz.getDjh();
        }
        if (djh==null || djh.equals("")){
            IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
            FGINFO fginfo = fginfoService.getFGINFO(projectId);
            if (fginfo!=null)djh = fginfo.getDjh();
        }
        if (djh==null || djh.equals("")){
            IDJKService djkService = (IDJKService) Container.getBean("djkService");
            DJK djk = djkService.getDJK(projectId);
            djh = djk.getDjh();
        }
        IDJKXBService djkxbService=(IDJKXBService)Container.getBean("djkXbService");
        List djkxbList=djkxbService.getDJKXBList(djh);
        if (djkxbList.size()==0){
            DJKXB djkxb = new DJKXB();
            djkxb.setDjh(djh);
            djkxbList.add(djkxb);
        }
       String detailXML=CommonUtil.getDjkXBDetailXML(djkxbList,"DJKXB");

        StringBuffer sb = new StringBuffer();
        sb.append(detailXML);

        return sb.toString();
    }

    public static String getGyqDjkxbXML(String djh,String tdzh) throws UnsupportedEncodingException{
        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        IDJKXBService djkxbService=(IDJKXBService)Container.getBean("djkXbService");
        //tdzh = tdzh.getBytes("ISO8859_1"),"GBK");
        String gytdzh=new String(tdzh.getBytes("ISO8859_1"),"GBK");
        List djkxbList=djkxbService.getDJKXBList(djh,gytdzh);
        if (djkxbList.size()==0){
            DJKXB djkxb = new DJKXB();
            djkxb.setDjh(djh);
            djkxbList.add(djkxb);
        }
        String detailXML=CommonUtil.getDjkxbDetailXML(djkxbList,"DJKXB");
        StringBuffer sb = new StringBuffer();
        sb.append(detailXML);

        return sb.toString();
    }
}
