package com.jsegov.tddj.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.SQB;
public class PrintAllServlet extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3891155055402353040L;

	/**
	 * Constructor of the object.
	 */
	public PrintAllServlet() {
		super();
	}

	/**
	 * Destruc tion of  the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	/**
	 * The doGet method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws java.io.IOException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		String sheetName=request.getParameter("sheetName");
		StringBuffer sb = new StringBuffer();
		sb.append("<?xml version=\"1.0\" encoding=\"GBK\"?>");
		sb.append("<fetchdatas>");
		String resultXML = null;
		String djh = "";
		String qlr = "";
		String zl = "";
		String syqlx = "";
		String fzrq1 = "";
		String fzrq2 = "";
		String yt = "";
		String createName = "";
		HashMap<String, Object> map = new HashMap<String, Object>();
		if (request.getParameter("djh") != null)
			djh = new String(request.getParameter("djh").getBytes(
					"ISO8859_1"), "GBK");
		if (request.getParameter("qlr") != null)
			qlr = new String(request.getParameter("qlr").getBytes(
					"ISO8859_1"), "GBK");
		if (request.getParameter("zl") != null)
			zl = new String(request.getParameter("zl").getBytes(
					"ISO8859_1"), "GBK");
		if (request.getParameter("syqlx") != null)
			syqlx = new String(request.getParameter("syqlx").getBytes(
					"ISO8859_1"), "GBK");
		if (request.getParameter("fzrq1") != null)
			fzrq1 = new String(request.getParameter("fzrq1").getBytes(
					"ISO8859_1"), "GBK");
		if (request.getParameter("fzrq2") != null)
			fzrq2 = new String(request.getParameter("fzrq2").getBytes(
					"ISO8859_1"), "GBK");
		if (request.getParameter("createName") != null)
			createName = new String(request.getParameter("createName").getBytes(
			"ISO8859_1"), "GBK");
		if (request.getParameter("yt") != null)
			yt = new String(request.getParameter("yt").getBytes(
			"ISO8859_1"), "GBK");
		
		if(djh!=null && !djh.equals("")){
			map.put("djh","%"+djh+"%");
		}
		if(qlr!=null && !qlr.equals("")){
			//map.put("rf1_dwmc","%"+qlr+"%");
			map.put("qlr","%"+qlr+"%");
		}
		if(zl!=null && !zl.equals("")){
			map.put("zl","%"+zl+"%");
		}
		if(yt!=null && !yt.equals("")){
			map.put("yt",yt);
		}
		if(syqlx!=null && !syqlx.equals("")){
			map.put("syqlx",syqlx);
		}
		if(fzrq1!=null && !fzrq1.equals("")){
			map.put("fzrq1",fzrq1);
		}
		if(fzrq2!=null && !fzrq2.equals("")){
			map.put("fzrq2",fzrq2);
		}
		if(createName!=null && !createName.equals("")){
			map.put("createName",createName);
		}
		if(sheetName!=null && sheetName.equals("spb")){
			ISPBService spbService=(ISPBService)Container.getBean("spbService");
			List<Object> spbList = spbService.querySPB(map);
			//System.out.println(spbList.size());
			resultXML= CommonUtil.getDetailXML(spbList,"SPB");
		}else if(sheetName!=null && sheetName.equals("sqb")){
			ISQBService sqbService = (ISQBService)Container.getBean("sqbService");
			List<SQB> sqbList = sqbService.getSqbList(map);
			//System.out.println(sqbList.size());
			resultXML= CommonUtil.getDetailXML(sqbList,"SQB");
		}
		
		sb.append(resultXML);
		sb.append("</fetchdatas>");
		//System.out.println(sb.toString());
		response.setContentType("text/xml;charset=GBK");
		response.getOutputStream().write(sb.toString().getBytes());
		response.getOutputStream().flush();
		response.getOutputStream().close();
	}

	/**
	 * The doPost method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws java.io.IOException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		doGet(request,response);
	}

	/**
	 * Initialization of the servlet. <br>
	 *
	 * @throws ServletException if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}
}
