package com.jsegov.tddj.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.util.DataSourceManager;
import com.jsegov.tddj.services.interf.IZDTService;
import com.jsegov.tddj.vo.ZDT;

public class GetZdtServlet extends HttpServlet {

	/**
	 * Constructor of the object.
	 */
	public GetZdtServlet() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	/**
	 * The doGet method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws javax.servlet.ServletException if an error occurred
	 * @throws java.io.IOException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		String djh = request.getParameter("djh");
		String uniqueId = request.getParameter("uniqueId");        
		try {
			response.setContentType("application/jpg;charset=utf-8");
			response.addHeader("Content-Disposition","attachment; filename=test.jpg");

			OutputStream outStream = response.getOutputStream();		
			IZDTService zdtService = (IZDTService)Container.getBean("zdtService");
			ZDT zdt = zdtService.getZdtImage(uniqueId, djh);
			if (zdt!=null && zdt.getZdt_image()!=null)
				response.getOutputStream().write(zdt.getZdt_image(), 0, zdt.getZdt_image().length);
			
			outStream.flush();
			outStream.close();
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
		
	}

	/**
	 * The doPost method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws javax.servlet.ServletException if an error occurred
	 * @throws java.io.IOException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		doGet(request, response);
	}

	/**
	 * Initialization of the servlet. <br>
	 *
	 * @throws javax.servlet.ServletException if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}

}
