package com.jsegov.tddj.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

import javax.print.attribute.standard.DocumentName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IDHDZBService;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.SJD;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public class BatchPrint extends HttpServlet {

	/**
	 * SerialVersionUID
	 */
	private static final long serialVersionUID = 4167165524376223406L;

	/**
	 * Constructor of the object.
	 */
	public BatchPrint() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	/**
	 * The doGet method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws java.io.IOException
	 *             if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String sheetName = request.getParameter("sheetName");
        Document doc = DocumentHelper.createDocument();
		String resultXML = null;
		String djh = "";
		String qlr = "";
		String sjr = "";
		String jjr = "";
		String zl = "";
		String syqlx = "";
		String fzrq1 = "";
		String fzrq2 = "";
		String sjrq1 = "";
		String sjrq2 = "";
		String yt = "";
		String createName = "";
		String userDwdm = "";
//		String oldDjh = "";
        if(StringUtils.isNotBlank(request.getParameter("qlr"))){
            qlr = java.net.URLDecoder.decode(request.getParameter("qlr"),"utf-8");
        }
        if(StringUtils.isNotBlank(request.getParameter("djh"))){
            djh = java.net.URLDecoder.decode(request.getParameter("djh"),"utf-8");
        }
        if(StringUtils.isNotBlank(request.getParameter("sjr"))){
            sjr = java.net.URLDecoder.decode(request.getParameter("sjr"),"utf-8");
        }
        if(StringUtils.isNotBlank(request.getParameter("jjr"))){
            jjr = java.net.URLDecoder.decode(request.getParameter("jjr"),"utf-8");
        }
        if(StringUtils.isNotBlank(request.getParameter("zl"))){
            zl = java.net.URLDecoder.decode(request.getParameter("zl"),"utf-8");
        }
        if(StringUtils.isNotBlank(request.getParameter("syqlx"))){
            syqlx = java.net.URLDecoder.decode(request.getParameter("syqlx"),"utf-8");
        }
        if(StringUtils.isNotBlank(request.getParameter("fzrq1"))){
            fzrq1 = java.net.URLDecoder.decode(request.getParameter("fzrq1"),"utf-8");
        }
        if(StringUtils.isNotBlank(request.getParameter("fzrq2"))){
            fzrq2 = java.net.URLDecoder.decode(request.getParameter("fzrq2"),"utf-8");
        }
        if(StringUtils.isNotBlank(request.getParameter("sjrq1"))){
            sjrq1 = java.net.URLDecoder.decode(request.getParameter("sjrq1"),"utf-8");
        }
        if(StringUtils.isNotBlank(request.getParameter("sjrq2"))){
            sjrq2 = java.net.URLDecoder.decode(request.getParameter("sjrq2"),"utf-8");
        }
        if(StringUtils.isNotBlank(request.getParameter("yt"))){
            yt = java.net.URLDecoder.decode(request.getParameter("yt"),"utf-8");
        }
        if(StringUtils.isNotBlank(request.getParameter("createName"))){
            createName = java.net.URLDecoder.decode(request.getParameter("createName"),"utf-8");
        }
        if(StringUtils.isNotBlank(request.getParameter("userDwdm"))){
            userDwdm = request.getParameter("userDwdm");
        }
		HashMap<String, Object> map = new HashMap<String, Object>();

		if (userDwdm!=null && !userDwdm.equals("")){
			map.put("dwdm", userDwdm+"%");
		}
		if (djh != null && !djh.equals("")) {
			map.put("djh", "%" + djh + "%");
		}
		if (qlr != null && !qlr.equals("")) {
			// map.put("rf1_dwmc","%"+qlr+"%");
			map.put("qlr", "%" + qlr + "%");
		}
		if (jjr != null && !jjr.equals("")) {
			map.put("jjr", "%" + jjr + "%");
		}
		if (sjr != null && !sjr.equals("")) {
			map.put("sjr", "%" + sjr + "%");
		}
		if (zl != null && !zl.equals("")) {
			map.put("zl", "%" + zl + "%");
		}
		if (yt != null && !yt.equals("")) {
			map.put("yt", "%"+yt+"%");
		}
		if (syqlx != null && !syqlx.equals("")) {
			map.put("syqlx", "%"+syqlx+"%");
		}
		if (fzrq1 != null && !fzrq1.equals("")) {
			map.put("fzrq1", fzrq1);
		}
		if (fzrq2 != null && !fzrq2.equals("")) {
			map.put("fzrq2", fzrq2);
		}
		if (createName != null && !createName.equals("")) {
			map.put("createName", createName);
		}
		if (sjrq1 != null && !sjrq1.equals("")) {
			map.put("sjrq1", sjrq1);
		}
		if (sjrq2 != null && !sjrq2.equals("")) {
			map.put("sjrq2", sjrq2);
		}
//		IDHDZBService dhdzbService = (IDHDZBService)Container.getBean("dhDzbService");
		if (sheetName != null && sheetName.equals("spb")) {
			ISPBService spbService = (ISPBService) Container.getBean("spbService");
//			map=dhdzbService.putNewDjhToMap(map, oldDjh,"a");
			List<Object> spbList = spbService.querySPB(map);
            doc = CommonUtil.getManyDatasXMLDoc(spbList, request);
		} else if (sheetName != null && sheetName.equals("sqb")) {
			ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
//			map=dhdzbService.putNewDjhToMap(map, oldDjh,"a");
			List<Object> sqbList = sqbService.getSqbListForBatchPrint(map);
			doc = CommonUtil.getManyDatasXMLDoc(sqbList, request);
		} else if (sheetName != null && sheetName.equals("djk")) {
			IDJKService djkService = (IDJKService) Container.getBean("djkService");
//			map=dhdzbService.putNewDjhToMap(map, oldDjh,"TBL_DJK");
			List<Object> djkList = djkService.getDjkListForBatchPrint(map);
			if (djkList.size() > 0) {
                Element root= doc.addElement("fetchdatas");
				for (int i = 0; i < djkList.size(); i++) {
					DJK djk = (DJK) djkList.get(i);
					String projectId = djk.getProjectId();
                    root.add(PrintDJK.getPrintXMLByProId(projectId).getRootElement());
				}
			}

			// System.out.println(spbList.size());
		} else if (sheetName != null && sheetName.equals("sjd")) {
			ISJDService sjdService = (ISJDService) Container.getBean("sjdService");
			List<Object> sjdList = sjdService.getSjdListForBatchPrint(map);
			if (sjdList.size() > 0) {
                Element root= doc.addElement("fetchdatas");
                for (int i = 0; i < sjdList.size(); i++) {
					SJD sjd = (SJD) sjdList.get(i);
					String projectId = sjd.getProjectId();

                    root.add(PrintDJK.getPrintXMLByProId(projectId).getRootElement());
				}
			}
		}

        XMLWriter writer = null;
        writer = new XMLWriter(response.getOutputStream());
        writer.write(doc);
		response.getOutputStream().flush();
		response.getOutputStream().close();
	}

	public static void crtXmlFile(InputStream in, String xmlName, HttpServletRequest request, HttpServletResponse response) throws IOException {

	}

	public static void delXmlFile(String fileName) {
		File file = new File(fileName);
		if (file.exists()) {
			file.delete();
		}
	}

	/**
	 * The doPost method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to
	 * post.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws java.io.IOException
	 *             if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGet(request, response);
	}

	/**
	 * Initialization of the servlet. <br>
	 * 
	 * @throws ServletException
	 *             if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}

}
