package com.jsegov.tddj.services.interf;

import com.jsegov.tddj.vo.SQB;

import java.util.List;

public interface IQlygService {
	
	/**
	 * 工作流开始调用方法
	 * @param proid 项目ID
	 * @param activityid 活动ID
	 * @param qsxz 权属性质
	 * @param sqlx 申请类型
	 */
	public void workflowBegin(String proid, String activityid, String qsxz, String sqlx);

	/**
	 * 工作流转发
	 * @param proid 项目ID
	 * @param activityid 活动ID
	 * @param qsxz 权属性质
	 * @param sqlx 申请类型
	 */
	public void workflowTurn(String proid, String activityid, String qsxz, String sqlx);

	/**
	 * 工作流退回
	 * @param proid 项目ID
	 * @param activityid 活动ID
	 * @param qsxz 权属性质
	 * @param sqlx 申请类型
	 */
	public void workflowBack(String proid, String activityid, String qsxz, String sqlx);

	/**
	 * 工作流停止
	 * @param proid 项目ID
	 * @param activityid 活动ID
	 * @param qsxz 权属性质
	 * @param sqlx 申请类型
	 */
	public void workflowStop(String proid, String activityid, String qsxz, String sqlx);

	/**
	 * 工作流取回
	 * @param proid 项目ID
	 * @param activityid 活动ID
	 * @param qsxz 权属性质
	 * @param sqlx 申请类型
	 */
	public void workflowGet(String proid, String activityid, String qsxz, String sqlx);

	/**
	 * 
	 * 工作流结束
	 */
	public String workflowEnd(String proid,String qsxz,String sqlx);

    public String workflowEndList(List<SQB> qlygList);
}
