package com.jsegov.tddj.services.interf;

import java.util.HashMap;
import java.util.List;

import com.jsegov.tddj.vo.CF;

public interface ICFService {
	String isCF(CF cf);
	List getCFByTdzh(String tdzh);
	List getCFByDjh(String djh);
	List getCFByIsjf(Integer isjf);
	CF getCFByProjectId(String projectId);
	void insertCF(CF cf);
	void updateCF(CF cf);
	void deleteCF(String projectId);
	List<Object> expCf(HashMap<String, Object> map);
    /**
   	 * 更新轮候查封的lhxh 如果cf参数为null根据projectid参数进行更新
   	 * @param cf
   	 * @param projectId
   	 */
   	void updateLhcf(CF cf,String projectId);
   	/**
   	 * 根据轮候序号查询该序号之前还是之后的所有数据
   	 * @param lhxh （如果要查询>=(<=)某值 lhxh值设置为 该值-(+)1）
   	 * @param compare 用于判断大于小于还是等于 值大于0表示大于 等于0表示等于 小于0表示小于
   	 * @return
   	 */
   	public List<CF> queryLhcfByLhxh(int lhxh,Integer compare,String tdzh,String djh);
   	/**
   	 * 设置下一个轮候查封为解封 如果cf参数为null根据projectid参数进行更新
   	 * @param cf
   	 * @param projectId
   	 */
   	void updateNextLhxf(CF cf, String projectId);

    List<CF> getCF(CF cf);
}
