package com.jsegov.tddj.services;

import java.util.HashMap;

import com.jsegov.tddj.dao.ZDQLRDAO;
import com.jsegov.tddj.services.interf.IZDQLRService;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import com.jsegov.tddj.vo.ZDQLR;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZdQlrService implements IZDQLRService {

    @Autowired
    ZDQLRDAO zdqlrDAO;
	
	public void deleteZDQLR(String tdzh) {
		// TODO Auto-generated method stub
		zdqlrDAO.deleteZDQLR(tdzh);
	}

	public ZDQLR getZDQLR(HashMap<String, String> map) {
		// TODO Auto-generated method stub
		return zdqlrDAO.getZDQLR(map);
	}

	public void insertZDQLR(ZDQLR zdqlr) {
		// TODO Auto-generated method stub
		zdqlrDAO.insertZDQLR(zdqlr);
	}

	public void updateZDQLR(ZDQLR zdqlr) {
		// TODO Auto-generated method stub
		zdqlrDAO.updateZDQLR(zdqlr);
	}

	public void insertZDQLR(SQB sqb) {
		// TODO Auto-generated method stub
		zdqlrDAO.insertZDQLR(getZDQLRbySQB(sqb));
	}

	public void insertZDQLR(SPB spb) {
		// TODO Auto-generated method stub
		zdqlrDAO.insertZDQLR(getZDQLRbySPB(spb));
	}

	public void updateZDQLR(SQB sqb) {
		// TODO Auto-generated method stub
		zdqlrDAO.updateZDQLR(getZDQLRbySQB(sqb));
	}

	public void updateZDQLR(SPB spb) {
		// TODO Auto-generated method stub
		zdqlrDAO.updateZDQLR(getZDQLRbySPB(spb));
	}

	public ZDQLR getZDQLRbySQB(SQB sqb){
		ZDQLR zdqlr = new ZDQLR();
		zdqlr.setDjh(sqb.getDjh());
		zdqlr.setFrdbdhhm(sqb.getRf2_lxdh());
		zdqlr.setQlrmc(sqb.getRf2_dwmc());
		zdqlr.setQlrzjh(sqb.getRf2_sfzmnum());
		zdqlr.setTdzh(sqb.getSqsbh());
		zdqlr.setZl(sqb.getZl());
		String zjlx = sqb.getRf2_sfzmtype();
		if (zjlx == null){
		}else if (zjlx.equals("居民身份证")){
			zdqlr.setQlrzjlx("1");
		}else if (zjlx.equals("军官证")){
			zdqlr.setQlrzjlx("2");
		}else if (zjlx.equals("护照")){
			zdqlr.setQlrzjlx("3");
		}else if (zjlx.equals("行政、企事业单位机构代码证或法人代码证")){
			zdqlr.setQlrzjlx("4");
		}else if (zjlx.equals("营业执照")){
			zdqlr.setQlrzjlx("5");
		}else if (zjlx.equals("其他")){
			zdqlr.setQlrzjlx("9");
		}
		return zdqlr;
	}
	
	public ZDQLR getZDQLRbySPB(SPB spb){
		ZDQLR zdqlr = new ZDQLR();
		zdqlr.setDjh(spb.getDjh());
		zdqlr.setFrdbdhhm(spb.getRf2_lxdh());
		zdqlr.setQlrmc(spb.getRf2_dwmc());
		zdqlr.setQlrzjh(spb.getRf2_sfzmnum());
		zdqlr.setTdzh(spb.getSpbh());
		zdqlr.setZl(spb.getZl());
		String zjlx = spb.getRf2_sfzmtype();
		if (zjlx == null){
		}else if (zjlx.equals("居民身份证")){
			zdqlr.setQlrzjlx("1");
		}else if (zjlx.equals("军官证")){
			zdqlr.setQlrzjlx("2");
		}else if (zjlx.equals("护照")){
			zdqlr.setQlrzjlx("3");
		}else if (zjlx.equals("行政、企事业单位机构代码证或法人代码证")){
			zdqlr.setQlrzjlx("4");
		}else if (zjlx.equals("营业执照")){
			zdqlr.setQlrzjlx("5");
		}else if (zjlx.equals("其他")){
			zdqlr.setQlrzjlx("9");
		}
		return zdqlr;
	}

	public ZDQLR getZDQLR(String tzdh) {
		// TODO Auto-generated method stub
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("tdzh", tzdh);
		return zdqlrDAO.getZDQLR(map);
	}
	
}
