package com.jsegov.tddj.services;

import java.util.HashMap;
import java.util.List;

import com.gtis.util.UUIDGenerator;
import com.jsegov.tddj.dao.TDZJSDAO;
import com.jsegov.tddj.services.interf.ITDZJSService;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.TDZJS;
import com.jsegov.tddj.util.CommonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TdzJsService implements ITDZJSService{

    @Autowired
    TDZJSDAO tdzjsDAO;
	
	public void deleteTDZJSByJsId(String tdzjsId) {
		tdzjsDAO.deleteTDZJSByJsId(tdzjsId);		
	}

	public void deleteTDZJS(String projectId) {
		tdzjsDAO.deleteTDZJS(projectId);		
	}
	
	public TDZJS getTDZJS(String tdzjsId) {
		return tdzjsDAO.getTDZJS(tdzjsId);
	}

	public void insertTDZJS(TDZJS tdzjs) {
		if (tdzjs.getTdzjsId()==null || tdzjs.getTdzjsId().equals(""))
			tdzjs.setTdzjsId(UUIDGenerator.generate());
		tdzjsDAO.insertTDZJS(tdzjs);		
	}

	public void updateTDZJS(TDZJS tdzjs) {
		tdzjsDAO.updateTDZJS(tdzjs);
	}

	public void insertTDZJS(SPB spb) {
		String js = spb.getJs();
		if (js != null && !js.equals("")){
			TDZJS tdzjs = new TDZJS();
			tdzjs.setJs(js);
			tdzjs.setProjectId(spb.getProjectId());
			if (spb.getSqlx().equals("土地使用权抵押权初始登记") || spb.getSqlx().indexOf("注销")>-1){
				tdzjs.setTdzh(spb.getZtdzh());
			}else{
				tdzjs.setTdzh(spb.getTdzh());
			}
			String jsdate = "";
			if (spb.getPzrq() != null){
				jsdate = CommonUtil.formateDate(spb.getPzrq());
			}
			else if(spb.getShrq() != null){
				jsdate =CommonUtil.formateDate(spb.getShrq());
			}
			else {
				jsdate =CommonUtil.getCurrStrDate();
			}
			tdzjs.setJsdate(jsdate);
			tdzjs.setTdzjsId(UUIDGenerator.generate());
			tdzjsDAO.insertTDZJS(tdzjs);
		}
	}

	@SuppressWarnings("unchecked")
	public List getTDZJSList(String tdzh) {
		return tdzjsDAO.getTDZJSList(tdzh);
	}
    public List getTDZJSByTdzProjectId(String projectId) {
        return tdzjsDAO.getTDZJSByTdzProjectId(projectId);
    }
	public TDZJS getTDZJSByProjectId(String projectId) {
		return tdzjsDAO.getTDZJSByProjectId(projectId);
	}

	public void updateTDZJS(SPB spb) {
		String js = spb.getJs();
		if (!js.equals("") || js != null){
			//TDZJS tdzjs = new TDZJS();
			HashMap<String, String> map = new HashMap<String, String>();
			String tdzh = "";
			if (spb.getSqlx().equals("土地使用权抵押权初始登记") || spb.getSqlx().indexOf("注销")>-1){
				tdzh = spb.getZtdzh();
			}else{
				tdzh = spb.getTdzh();
			}
			map.put("tdzh", tdzh);
			map.put("projectId", spb.getProjectId());
			TDZJS tdzjs = tdzjsDAO.getTDZJS(map);
			tdzjs.setJs(js);
			tdzjs.setProjectId(spb.getProjectId());
			//if (spb.getSqlx().equals("土地使用权抵押权初始登记") || spb.getSqlx().indexOf("注销")>-1){
				tdzjs.setTdzh(tdzh);
			//}else{
			//	tdzjs.setTdzh(spb.getTdzh());
			//}
			String jsdate = "";
			//System.out.println(tdzjs.getTdzh()+"-------spb.getPzrq()");
			if (spb.getPzrq() != null){
				jsdate = CommonUtil.formateDate(spb.getPzrq());
			}
			else if(spb.getShrq() != null){
				jsdate =CommonUtil.formateDate(spb.getShrq());
			}
			else {
				jsdate =CommonUtil.getCurrStrDate();
			}
			tdzjs.setJsdate(jsdate);
			tdzjsDAO.updateTDZJS(tdzjs);
		}
	}

	public void insertTXJS(SPB spb) {
		String js = spb.getTxjs();
		if (js != null && !js.equals("")){
			TDZJS tdzjs = new TDZJS();
			tdzjs.setJs(js);
			tdzjs.setProjectId(spb.getProjectId());
			//if (spb.getSqlx().equals("土地使用权抵押权初始登记") || spb.getSqlx().indexOf("注销")>-1){
			//	tdzjs.setTdzh(spb.getZtdzh());
			//}else{
			tdzjs.setTdzh(spb.getTdzh());
			//}
			String jsdate = "";
			if (spb.getPzrq() != null){
				jsdate = CommonUtil.formateDate(spb.getPzrq());
			}
			else if(spb.getShrq() != null){
				jsdate =CommonUtil.formateDate(spb.getShrq());
			}
			else {
				jsdate =CommonUtil.getCurrStrDate();
			}
			tdzjs.setJsdate(jsdate);
			tdzjs.setTdzjsId(UUIDGenerator.generate());
			tdzjsDAO.insertTDZJS(tdzjs);
		}
	}

	public void updateTXJS(SPB spb) {
		String js = spb.getTxjs();
		if (js != null && !js.equals("")){
			HashMap<String, String> map = new HashMap<String, String>();
			map.put("tdzh", spb.getTdzh());
			map.put("projectId", spb.getProjectId());
			TDZJS tdzjs = tdzjsDAO.getTDZJS(map);
			tdzjs.setJs(js);
			tdzjs.setProjectId(spb.getProjectId());
			//if (spb.getSqlx().equals("土地使用权抵押权初始登记") || spb.getSqlx().indexOf("注销")>-1){
			//	tdzjs.setTdzh(spb.getZtdzh());
			//}else{
			tdzjs.setTdzh(spb.getTdzh());
			//}
			String jsdate = "";
			if (spb.getPzrq() != null){
				jsdate = CommonUtil.formateDate(spb.getPzrq());
			}
			else if(spb.getShrq() != null){
				jsdate =CommonUtil.formateDate(spb.getShrq());
			}
			else {
				jsdate =CommonUtil.getCurrStrDate();
			}
			tdzjs.setJsdate(jsdate);
			tdzjsDAO.updateTDZJS(tdzjs);
		}
	}

	public TDZJS getTDZJS(HashMap<String, String> map) {
		return tdzjsDAO.getTDZJS(map);
	}

	public TDZJS getTDZJS(String tdzh, String projectId) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("tdzh", tdzh);
		map.put("projectId", projectId);
		return tdzjsDAO.getTDZJS(map);
	}
}
