package com.jsegov.tddj.services;

import java.util.HashMap;
import java.util.List;

import com.gtis.spring.Container;
import com.jsegov.tddj.dao.SQBDAO;
import com.jsegov.tddj.services.interf.IQSZD_DJDCBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.vo.FGINFO;
import com.jsegov.tddj.vo.FGZ;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.JTTDSUZ;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.QSZD_DJDCB;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import com.jsegov.tddj.vo.TXQLZMS;
import com.jsegov.tddj.vo.ZD_DJDCB;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqbService implements ISQBService {

    @Autowired
    SQBDAO sqbDAO;


	public SQB getSQB(String projectId) {
		// TODO Auto-generated method stub
		return sqbDAO.getSQB(projectId);
	}
	
	public void insertSQB(SQB sqb) {
		// TODO Auto-generated method stub
		sqbDAO.insertSQB(sqb);
	}
	
	public void updateSQB(SQB sqb) {
		// TODO Auto-generated method stub
		sqbDAO.updateSQB(sqb);
	}
	
	public void deleteSQB(String projectId) {
		// TODO Auto-generated method stub
		sqbDAO.deleteSQB(projectId);
	}
	
	//读取地籍调查表数据到申请表

	public SQB readDJDCB(SQB sqb, ZD_DJDCB djdcb ,Integer rfNum){
		if (djdcb.getDjh() != null && !djdcb.getDjh().equals("")){
			//sqb.setZl(djdcb.getTdzl());
			sqb.setDjh(djdcb.getDjh());
		}
		if (djdcb.getTdzl() != null && !djdcb.getTdzl().equals("")){
			sqb.setZl(djdcb.getTdzl());
		}
		if (rfNum == 1){
			//System.out.println(djdcb.getQlrmc()+"----djdcb.getQlrmc()");
			//if (djdcb.getQlrmc() != null && !djdcb.getQlrmc().equals("")){
			//	sqb.setRf1_dwmc(djdcb.getQlrmc());
			//}
			if (djdcb.getYzbm() != null && !djdcb.getYzbm().equals("")){
				sqb.setRf1_yb(djdcb.getYzbm());
			}
			if (djdcb.getTxdz() != null && !djdcb.getTxdz().equals("")){
				sqb.setRf1_txdz(djdcb.getTxdz());
			}
			if (djdcb.getQlrzjlx() != null && !djdcb.getQlrzjlx().equals("")){
				sqb.setRf1_sfzmtype(djdcb.getQlrzjlx());
			}
			if (djdcb.getQlrzjh() != null && !djdcb.getQlrzjh().equals("")){
				sqb.setRf1_sfzmnum(djdcb.getQlrzjh());
			}
			if (djdcb.getFrdbxm() != null && !djdcb.getFrdbxm().equals("")){
				sqb.setRf1_fddbr(djdcb.getFrdbxm());
			}
			if (djdcb.getDwxz() != null && !djdcb.getDwxz().equals("")){
				sqb.setRf1_dwxz(djdcb.getDwxz_zh());
			}
			if (djdcb.getQlrzjlx_zh() != null && !djdcb.getQlrzjlx_zh().equals("")){
				sqb.setRf1_sfzmtype(djdcb.getQlrzjlx_zh());
			}
			if (djdcb.getQlrzjh() != null && !djdcb.getQlrzjh().equals("")){
				sqb.setRf1_sfzmnum(djdcb.getQlrzjh());
			}
		}else if (rfNum == 2){
			if (djdcb.getQlrmc() != null && !djdcb.getQlrmc().equals("")){
				sqb.setRf2_dwmc(djdcb.getQlrmc());
			}
			if (djdcb.getYzbm() != null && !djdcb.getYzbm().equals("")){
				sqb.setRf2_txdz(djdcb.getTxdz());
			}
			if (djdcb.getTxdz() != null && !djdcb.getTxdz().equals("")){
				sqb.setRf2_yb(djdcb.getYzbm());
			}
			if (djdcb.getQlrzjlx() != null && !djdcb.getQlrzjlx().equals("")){
				sqb.setRf2_sfzmtype(djdcb.getQlrzjlx());
			}
			if (djdcb.getQlrzjh() != null && !djdcb.getQlrzjh().equals("")){
				sqb.setRf2_sfzmnum(djdcb.getQlrzjh());
			}
			if (djdcb.getFrdbxm() != null && !djdcb.getFrdbxm().equals("")){
				sqb.setRf2_fddbr(djdcb.getFrdbxm());
			}
			if (djdcb.getDwxz() != null && !djdcb.getDwxz().equals("")){
				sqb.setRf2_dwxz(djdcb.getDwxz_zh());
			}
			if (djdcb.getQlrzjlx_zh() != null && !djdcb.getQlrzjlx_zh().equals("")){
				sqb.setRf2_sfzmtype(djdcb.getQlrzjlx_zh());
			}
			if (djdcb.getQlrzjh() != null && !djdcb.getQlrzjh().equals("")){
				sqb.setRf2_sfzmnum(djdcb.getQlrzjh());
			}
		}
		sqb.setTh(djdcb.getSztfh());
		//sqb.setZdmj(djdcb.getFzmj());
		//sqb.setTdqlmj(djdcb.getFzmj());
		if (djdcb.getFzmj()!=null){
			sqb.setZdmj(djdcb.getFzmj().toString());
		}
		//sqb.setDymj(djdcb.getFzmj());
		sqb.setJzrjl(djdcb.getJzrjl());
		sqb.setJzmd(djdcb.getJzmd());
		//sqb.setTddj(djdcb.getTdjb());
		//if (djdcb.getSbdj()!=null) sqb.setBddj(djdcb.getSbdj().toString());
		sqb.setDcbh(djdcb.getDcbh());
		if (djdcb.getQdjg()!=null && !djdcb.getQdjg().equals("")){
			sqb.setQdjg(djdcb.getQdjg().toString());
		}
		if (sqb.getZzrq()==null || sqb.getZzrq().equals("")){
			sqb.setZzrq(djdcb.getZzrq());
		}
		sqb.setYt(djdcb.getYt());
		sqb.setZdsz(djdcb.getZdsz());
		//sqb.setSyqlx(djdcb.getSyqlx());
        //读ZDZMJ给  JZWZDMJ		
		sqb.setJzwzdmj(djdcb.getZdzmj());
		return sqb;
	}
	
	//读取审批表数据到申请表

	public SQB readSPB(SQB sqb, SPB spb, String djlx){
		String dwmc;
		String sfzmtype;
		String sfzmnum;
		String dwxz;
		String txdz;
		String yb;
		String fddbr;
		String lxr;
		String lxdh;
		String dzyj;
		
		dwmc = spb.getRf1_dwmc();
		sfzmtype = spb.getRf1_sfzmtype();
		sfzmnum = spb.getRf1_sfzmnum();
		dwxz = spb.getRf1_dwxz();
		txdz = spb.getRf1_txdz();
		yb = spb.getRf1_yb();
		fddbr = spb.getRf1_fddbr();
		lxr=spb.getRf1_lxr();
		lxdh = spb.getRf1_lxdh();
		dzyj=spb.getRf1_dzyj();
			
		if (djlx.equals("BGDJ")){        //变更登记
			sqb.setRf2_dwmc(dwmc);
			sqb.setRf2_sfzmtype(sfzmtype);
			sqb.setRf2_sfzmnum(sfzmnum);
			sqb.setRf2_dwxz(dwxz);
			sqb.setRf2_txdz(txdz);
			sqb.setRf2_yb(yb);
			sqb.setRf2_fddbr(fddbr);
			sqb.setRf2_lxr(lxr);
			sqb.setRf2_lxdh(lxdh);
			sqb.setRf2_dzyj(dzyj);
		}else if (djlx.equals("TXBGDJ")){  //他项权利变更登记
			sqb.setRf1(spb.getRf1());
			sqb.setRf1_dwmc(dwmc);
			sqb.setRf1_sfzmtype(sfzmtype);
			sqb.setRf1_sfzmnum(sfzmnum);
			sqb.setRf1_dwxz(dwxz);
			sqb.setRf1_txdz(txdz);
			sqb.setRf1_fddbr(fddbr);
			sqb.setRf1_yb(yb);
			sqb.setRf1_lxr(lxr);
			sqb.setRf1_lxdh(lxdh);
			sqb.setRf1_dzyj(dzyj);

			sqb.setRf2(spb.getRf2());
			sqb.setRf2_dwmc(spb.getRf2_dwmc());
			sqb.setRf2_sfzmtype(spb.getRf2_sfzmtype());
			sqb.setRf2_sfzmnum(spb.getRf2_sfzmnum());
			sqb.setRf2_dwxz(spb.getRf2_dwxz());
			sqb.setRf2_txdz(spb.getRf2_txdz());
			sqb.setRf2_yb(spb.getRf2_yb());
			sqb.setRf2_fddbr(spb.getRf2_fddbr());
			sqb.setRf2_lxr(spb.getRf2_lxr());
			sqb.setRf2_lxdh(spb.getRf2_lxdh());
			sqb.setRf2_dzyj(spb.getRf2_dzyj());
			
			//sqb.setZtdzh(spb.getZtdzh());
			
		}else if (djlx.equals("MCBGDJ")){    //名称地址用途变更登记

			
			sqb.setRf1_sfzmtype(sfzmtype);
			sqb.setRf1_sfzmnum(sfzmnum);
			sqb.setRf1_dwxz(dwxz);
			sqb.setRf1_txdz(txdz);
			sqb.setRf1_fddbr(fddbr);
			sqb.setRf1_yb(yb);
			sqb.setRf1_lxr(lxr);
			sqb.setRf1_lxdh(lxdh);
			sqb.setRf1_dzyj(dzyj);
			//
			sqb.setDw(spb.getDw());
			sqb.setQlslqk(spb.getQlslqk());
			sqb.setQdjg(spb.getQdjg());
			sqb.setRmzf(spb.getRmzf());
			sqb.setBz(spb.getBz());
			sqb.setDwdm(spb.getDwdm());
			sqb.setXydzl(spb.getXydzl());
			
		}else if (djlx.equals("TXDJ")){		//他项登记
			sqb.setRf2_dwmc(dwmc);
			sqb.setRf2_sfzmtype(sfzmtype);
			sqb.setRf2_sfzmnum(sfzmnum);
			sqb.setRf2_dwxz(dwxz);
			sqb.setRf2_txdz(txdz);
			sqb.setRf2_yb(yb);
			sqb.setRf2_fddbr(fddbr);
			sqb.setRf2_lxr(lxr);
			sqb.setRf2_lxdh(lxdh);
			sqb.setRf2_dzyj(dzyj);
		}else if (djlx.equals("ZXDJ")){		//注销登记
			sqb.setRf1(spb.getRf1());
			sqb.setRf1_dwmc(dwmc);
			sqb.setRf1_sfzmtype(sfzmtype);
			sqb.setRf1_sfzmnum(sfzmnum);
			sqb.setRf1_dwxz(dwxz);
			sqb.setRf1_txdz(txdz);
			sqb.setRf1_fddbr(fddbr);
			sqb.setRf1_yb(yb);
			sqb.setRf1_lxr(lxr);
			sqb.setRf1_lxdh(lxdh);
			sqb.setRf1_dzyj(dzyj);

			sqb.setRf2(spb.getRf2());
			sqb.setRf2_dwmc(spb.getRf2_dwmc());
			sqb.setRf2_sfzmtype(spb.getRf2_sfzmtype());
			sqb.setRf2_sfzmnum(spb.getRf2_sfzmnum());
			sqb.setRf2_dwxz(spb.getRf2_dwxz());
			sqb.setRf2_txdz(spb.getRf2_txdz());
			sqb.setRf2_yb(spb.getRf2_yb());
			sqb.setRf2_fddbr(spb.getRf2_fddbr());
			sqb.setRf2_lxr(spb.getRf2_lxr());
			sqb.setRf2_lxdh(spb.getRf2_lxdh());
			sqb.setRf2_dzyj(spb.getRf2_dzyj());
		}else if (djlx.equals("SJRL")){    //数据录入
			sqb.setRf1(spb.getRf1());
			sqb.setRf1_dwmc(dwmc);
			sqb.setRf1_sfzmtype(sfzmtype);
			sqb.setRf1_sfzmnum(sfzmnum);
			sqb.setRf1_dwxz(dwxz);
			sqb.setRf1_txdz(txdz);
			sqb.setRf1_fddbr(fddbr);
			sqb.setRf1_yb(yb);
			sqb.setRf1_lxr(lxr);
			sqb.setRf1_lxdh(lxdh);
			sqb.setRf1_dzyj(dzyj);

			sqb.setRf2(spb.getRf2());
			sqb.setRf2_dwmc(spb.getRf2_dwmc());
			sqb.setRf2_sfzmtype(spb.getRf2_sfzmtype());
			sqb.setRf2_sfzmnum(spb.getRf2_sfzmnum());
			sqb.setRf2_dwxz(spb.getRf2_dwxz());
			sqb.setRf2_txdz(spb.getRf2_txdz());
			sqb.setRf2_yb(spb.getRf2_yb());
			sqb.setRf2_fddbr(spb.getRf2_fddbr());
			sqb.setRf2_lxr(spb.getRf2_lxr());
			sqb.setRf2_lxdh(spb.getRf2_lxdh());
			sqb.setRf2_dzyj(spb.getRf2_dzyj());
			//
			sqb.setDw(spb.getDw());
			sqb.setQlslqk(spb.getQlslqk());
			sqb.setQdjg(spb.getQdjg());
			sqb.setRmzf(spb.getRmzf());
			sqb.setBz(spb.getBz());
			sqb.setDwdm(spb.getDwdm());
			sqb.setXydzl(spb.getXydzl());
		}else if (djlx.equals("YSBF")){		//遗失补发
			sqb.setRf1_dwmc(dwmc);
			sqb.setRf1_sfzmtype(sfzmtype);
			sqb.setRf1_sfzmnum(sfzmnum);
			sqb.setRf1_dwxz(dwxz);
			sqb.setRf1_txdz(txdz);
			sqb.setRf1_fddbr(fddbr);
			sqb.setRf1_yb(yb);
			sqb.setRf1_lxr(lxr);
			sqb.setRf1_lxdh(lxdh);
			sqb.setRf1_dzyj(dzyj);
			//
			sqb.setDw(spb.getDw());
			sqb.setQlslqk(spb.getQlslqk());
			sqb.setQdjg(spb.getQdjg());
			sqb.setRmzf(spb.getRmzf());
			sqb.setBz(spb.getBz());
			sqb.setDwdm(spb.getDwdm());
			sqb.setXydzl(spb.getXydzl());
		}
        if(StringUtils.isBlank(sqb.getDjh())){
            sqb.setDjh(spb.getDjh());
        }
		sqb.setTh(spb.getTh());
		sqb.setDcbh(spb.getDcbh());
		if (sqb.getSyqlx()==null || sqb.getSyqlx().equals("")){
			sqb.setSyqlx(spb.getSyqlx());
		}
		if (sqb.getSqlx()!=null && (sqb.getSqlx().equals("他项权利证明书注销登记") 
				|| sqb.getSqlx().equals("土地使用权抵押权初始登记") || sqb.getSqlx().equals("他项权利证明书遗失补发登记") 
				|| sqb.getSqlx().equals("土地抵押权变更登记") || sqb.getSqlx().equals("土地租赁权变更登记") || sqb.getSqlx().equals("地役权变更登记")
				|| sqb.getSqlx().equals("抵押期间使用权及抵押权变更登记") || sqb.getSqlx().equals("因主债权转让抵押权变更登记") || sqb.getSqlx().equals("出让土地使用权抵押权初始登记")
				|| sqb.getSqlx().equals("划拨土地使用权抵押权初始登记") || sqb.getSqlx().equals("政府储备土地使用权抵押初始登记")
				|| sqb.getSqlx().equals("抵押权或地役权终止他项权利证明书注销登记") 
				|| sqb.getSqlx().equals("地址变更登记")||sqb.getSqlx().equals("名称变更登记")||sqb.getSqlx().equals("土地用途变更登记"))){
			if(sqb.getSyqlx() == null || sqb.getSyqlx().equals("")) {
					sqb.setSyqlx(spb.getSyqlx());
			}
		}
		sqb.setZl(spb.getZl());
		sqb.setSyqx(spb.getSyqx());
		sqb.setZzrq(spb.getZzrq());
		sqb.setQsxz(spb.getQsxz());
		sqb.setZdmj(spb.getZdmj());
		sqb.setSyqmj(spb.getSyqmj());
		sqb.setDymj(spb.getDymj());
		sqb.setFtmj(spb.getFtmj());
		sqb.setYt(spb.getYt());
		sqb.setQdjg(spb.getQdjg());
		//sqb.setTddj(spb.getTddj());
		sqb.setJzrjl(spb.getJzrjl());
		sqb.setJzmd(spb.getJzmd());
		sqb.setJzxg(spb.getJzxg());
		sqb.setJzwzdmj(spb.getJzwzdmj());
		sqb.setJzwlx(spb.getJzwlx());
		
		if (sqb.getSqlx().equals("他项权利证明书注销登记") || sqb.getSqlx().equals("土地抵押权变更登记")
				|| sqb.getSqlx().equals("土地租赁权变更登记") || sqb.getSqlx().equals("地役权变更登记")
				|| sqb.getSqlx().equals("抵押期间使用权及抵押权变更登记") || sqb.getSqlx().equals("因主债权转让抵押权变更登记") || sqb.getSqlx().equals("出让土地使用权抵押权初始登记")
				|| sqb.getSqlx().equals("划拨土地使用权抵押权初始登记") || sqb.getSqlx().equals("政府储备土地使用权抵押初始登记")
				|| sqb.getSqlx().equals("他项权利证明书遗失补发登记")) {
			sqb.setTxqllx(spb.getTxqllx());
		}
		sqb.setQlsx(spb.getQlsx());
		sqb.setTxmj(spb.getTxmj());
		sqb.setDyl(spb.getDyl());
		sqb.setSdrq(spb.getSdrq());
		sqb.setCxqx(spb.getCxqx());
		sqb.setDyje(spb.getDyje());
		sqb.setTdjg(spb.getTdjg());
		sqb.setTxql(spb.getTxql());
		sqb.setTxjs(spb.getTxjs());
		sqb.setZdsz(spb.getZdsz());
		return sqb;
	}
	//读取国有土地使用证数据到申请表

	public SQB readGYTDSYZ(SQB sqb, GYTDSYZ gytdsyz, Integer rfNum) {
		if (gytdsyz!=null){
			if (rfNum == 1){
				sqb.setRf1_dwmc(gytdsyz.getQlr());
			}else if (rfNum == 2) {
				sqb.setRf2_dwmc(gytdsyz.getQlr());
			}
			sqb.setTh(gytdsyz.getTh());
			sqb.setYt(gytdsyz.getYt());
			if (sqb.getSqlx().equals("土地使用权抵押权初始登记")||sqb.getSqlx().equals("地址变更登记")
					|| sqb.getSqlx().equals("出让土地使用权抵押权初始登记")
					|| sqb.getSqlx().equals("划拨土地使用权抵押权初始登记") || sqb.getSqlx().equals("政府储备土地使用权抵押初始登记")
					||sqb.getSqlx().equals("名称变更登记")||sqb.getSqlx().equals("土地用途变更登记")){
				sqb.setSyqlx(gytdsyz.getSyqlx());
			}
			sqb.setZzrq(gytdsyz.getZzrq());
			sqb.setSyqmj(gytdsyz.getSyqmj());
			sqb.setDymj(gytdsyz.getDymj());
			sqb.setFtmj(gytdsyz.getFtmj());
			sqb.setQdjg(gytdsyz.getQdjg());
		}
		return sqb;
	}

	public SQB readJTTDSYZ(SQB sqb, JTTDSYZ jttdsyz ,Integer rfNum) {
		// TODO Auto-generated method stub
		//tdzh, qlr,  zl, djh, th, yt, qdjg, syqlx, zzrq, syqmj, 
		if (jttdsyz!=null){
			if (rfNum == 1){
				sqb.setRf1_dwmc(jttdsyz.getQlr());
			}else if (rfNum == 2) {
				sqb.setRf2_dwmc(jttdsyz.getQlr());
			}else if (rfNum == 3) {
			}
			sqb.setTh(jttdsyz.getTh());
			sqb.setYt(jttdsyz.getYt());
			sqb.setSyqlx(jttdsyz.getSyqlx());
			sqb.setZzrq(jttdsyz.getZzrq());
			sqb.setSyqmj(jttdsyz.getSyqmj());
			sqb.setDymj(jttdsyz.getDymj());
			sqb.setFtmj(jttdsyz.getFtmj());
			sqb.setQdjg(jttdsyz.getQdjg());
		}
		return sqb;
	}

	public SQB readTXQLZMS(SQB sqb, TXQLZMS txqlzms ,Integer rfNum) {
		// TODO Auto-generated method stub
		//th, qsxz, syqmj, yt, syqlx, txql, qlsx, cxqx, sdrq,
		if (txqlzms!=null){
			if (rfNum == 1){
				sqb.setRf1_dwmc(txqlzms.getQlr());
			}else if (rfNum == 2) {
				sqb.setRf1_dwmc(txqlzms.getQlr());
				sqb.setRf2_dwmc(txqlzms.getYwr());
			}else if (rfNum == 3) {
				sqb.setRf2_dwmc(txqlzms.getQlr());
			}else if (rfNum == 4) {
				sqb.setRf2_dwmc(txqlzms.getQlr());
				sqb.setRf1_dwmc(txqlzms.getYwr());
			}
			sqb.setQsxz(txqlzms.getQsxz());
			sqb.setSyqmj(txqlzms.getSyqmj());
			sqb.setTxmj(txqlzms.getSyqmj());
			sqb.setSyqlx(txqlzms.getSyqlx());
			sqb.setTxqllx("抵押");
			sqb.setYt(txqlzms.getYt());
			sqb.setTh(txqlzms.getTh());
			sqb.setTxql(txqlzms.getTxql());
			sqb.setQlsx(txqlzms.getQlsx());
			sqb.setCxqx(txqlzms.getCxqx());
			sqb.setSdrq(txqlzms.getSdrq());
		}
		return sqb;
	}
	
	public SQB readJTTDSUZ(SQB sqb, JTTDSUZ jttdsuz ,Integer rfNum) {
		// TODO Auto-generated method stub
		if (jttdsuz!=null){
			if (rfNum == 1){
				sqb.setRf1_dwmc(jttdsuz.getSyqr());
			}else if (rfNum == 2) {
				sqb.setRf2_dwmc(jttdsuz.getSyqr());
			}else if (rfNum == 3) {
			}
			sqb.setTh(jttdsuz.getTh());
			//sqb.setTdqlmj(jttdsuz.getTdzmj());
			sqb.setSyqmj(jttdsuz.getTdzmj());
		}
		return sqb;
	}
	
	public SQB readFGZ(SQB sqb, FGZ fgz, FGINFO fginfo) {
		// TODO Auto-generated method stub
		sqb.setRf2_dwmc(fgz.getQlr());
		sqb.setYt(fgz.getYt());
		sqb.setZzrq(fgz.getZzrq());
		//sqb.setTdqlmj(fgz.getFtmj());
		sqb.setSyqmj(fgz.getFtmj());
		sqb.setFtmj(fgz.getFtmj());
		if (sqb.getZdmj()==null || sqb.getZdmj().equals(""))sqb.setZdmj(fginfo.getZdmj());
		if (sqb.getTh()==null ||sqb.getTh().equals(""))sqb.setTh(fginfo.getTh());
		if (fgz.getSyqlx() !=null && !fgz.getSyqlx().equals("")){
			sqb.setSyqlx(fgz.getSyqlx());
		}else{
			sqb.setSyqlx(fginfo.getSyqlx());
		}
		sqb.setRf2_fddbr(fginfo.getFddbr());
		sqb.setRf2_dwxz(fginfo.getDwxz());
		sqb.setRf2_txdz(fginfo.getTxdz());
		return sqb;
	}

	public List<SQB> getSqbList(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		return sqbDAO.getSqbList(map);
	}

	public SQB readSYQDCB(SQB sqb, QSZD_DJDCB djdcb, Integer rfNum) {
		// TODO Auto-generated method stub
		if (djdcb.getDjh() != null && !djdcb.getDjh().equals("")){
			sqb.setDjh(djdcb.getDjh());
		}
		if (djdcb.getTdzl() != null && !djdcb.getTdzl().equals("")){
			sqb.setZl(djdcb.getTdzl());
		}
		sqb.setTh(djdcb.getSztfh());
		sqb.setDcbh(djdcb.getDcbh());
		IQSZD_DJDCBService qszd_djdcbService=(IQSZD_DJDCBService)Container.getBean("qszd_DjdcbService");
		Double zdmj = qszd_djdcbService.sumZDMJ(djdcb.getDjh());
		if (zdmj!=null){
			sqb.setZdmj(zdmj.toString());
		}
		return sqb;
	}

	public List<Object> getSqbListForBatchPrint(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		return sqbDAO.getSqbListForBatchPrint(map);
	}
}
