package com.jsegov.tddj.services;

import com.jsegov.tddj.check.CreateTaskCheck;
import com.jsegov.tddj.services.interf.INewProjectCheckService;
import com.jsegov.tddj.vo.CheckReturnMsg;
import com.jsegov.tddj.vo.NewProjectCheck;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:xuexing3212@sina.com">zx</a>
 * @version V1.0, 12-8-9
 */
@Service
public class ServerCheckService {
    @Autowired
    INewProjectCheckService newProjectCheckService;

    public String serverCheck(String djlx, String sqlx, String djh, String tdzh, String qlr, String tdzl, String qsxz) {
        String resultMsg = "";
        CheckReturnMsg msg = new CheckReturnMsg();

        String checkModel = "";
        String alertMsg = "";

        Map params = new HashMap();
        params.put("djlx", djlx);
        params.put("tdzl", tdzl);
        params.put("djh", djh);
        params.put("tdzh", tdzh);
        params.put("qlr", qlr);
        params.put("qsxz", qsxz);
        params.put("sqlx", sqlx);
        params.put("checkCode", 0);

        List<NewProjectCheck> newProjectCheckList = newProjectCheckService.getNewProjectCheckByDjlx(djlx);
        List returnMsgList = new ArrayList();
        for (NewProjectCheck newProjectCheck : newProjectCheckList) {

            //获得检查类型的检查代码，提示类型，提示信息
            Integer checkCode = Integer.parseInt(newProjectCheck.getCheckCode());
            checkModel = newProjectCheck.getCheckModel();
//            System.out.println(checkModel);

            //获得数据库中默认的提示信息
            alertMsg = newProjectCheck.getAlertMsg();

            if (StringUtils.isNotBlank(alertMsg)) {
                alertMsg = alertMsg.replaceAll("#DJH#", djh);
                alertMsg = alertMsg.replaceAll("#TDZH#", tdzh);
                alertMsg = alertMsg.replaceAll("#QLR#", qlr);
                alertMsg = alertMsg.replaceAll("#TDZL#", tdzl);
            }

            //将检查代码也作为参数传给检查逻辑
            params.remove("checkCode");
            params.put("checkCode", checkCode);

            CreateTaskCheck checkFn = newProjectCheckService.getCheckFn(checkCode);

            //确保代码都有对应的处理类
            if (checkFn != null) {
                //获得检查后返回的参数
                CheckReturnMsg checkMsg = checkFn.run(params);
                //如果检查没有通过，如果数据库中有定义提示信息，则使用数据库中的，如果没有则使用代码的
                if (checkMsg != null && StringUtils.isNotBlank(checkMsg.getReturnMessage()) && StringUtils.isNotBlank(alertMsg)) {
                    msg.setReturnMessage(checkMsg.getReturnMessage());
                    returnMsgList.add(alertMsg);
                    msg.setReturnMessageList(returnMsgList);
//                    msg.setReturnMessage(alertMsg);
                    if (StringUtils.isNotEmpty(checkModel)) {
                        if (StringUtils.equals(checkModel.toUpperCase(), "CONFIRM")) {
                            msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                        } else if (StringUtils.equals(checkModel.toUpperCase(), "ALERT")) {
                            msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                            break;
                        }
                    } else if (checkMsg.getCheckModel().toString().toUpperCase().equals("CONFIRM")) {
                        msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                    } else if (checkMsg.getCheckModel().toString().toUpperCase().equals("ALERT")) {
                        msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                        break;
                    }
                }
            }
        }
        if (msg != null && msg.getCheckModel() != null && StringUtils.equals(msg.getCheckModel() + "", "ALERT")) {
            if (msg.getReturnMessageList() != null && msg.getReturnMessageList().size() > 0) {
                resultMsg = msg.getReturnMessageList().get(0) + "";
            }
        }
        return resultMsg;
    }

    public INewProjectCheckService getNewProjectCheckService() {
        return newProjectCheckService;
    }

    public void setNewProjectCheckService(INewProjectCheckService newProjectCheckService) {
        this.newProjectCheckService = newProjectCheckService;
    }
}
