package com.jsegov.tddj.services;

import java.util.List;

import com.jsegov.tddj.dao.ProRelationDAO;
import com.jsegov.tddj.dao.ProjectDAO;
import com.jsegov.tddj.services.interf.IProRelationService;
import com.jsegov.tddj.services.interf.IZSService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProRelationService implements IProRelationService {
    @Autowired
    ProRelationDAO ProRelationDAO;
    @Autowired
    ProjectDAO projectDAO;
	@Autowired
    IZSService ZSService;



	public void deleteProjectRelation(String projectId) {
        ProRelationDAO.deleteProjectRelation(projectId);
	}

	public void insertProjectRelation(ProRelation proRelation) {
        ProRelationDAO.insertProjectRelation(proRelation);
	}

	public void updateProjectRelation(ProRelation proRelation) {
        ProRelationDAO.updateProjectRelation(proRelation);
	}

	public void insertProjectRelation(SPB spb) {
		// TODO Auto-generated method stub
        ProRelationDAO.insertProjectRelation(getProRelationBySpb(spb));
	}

	public void updateProjectRelation(SPB spb) {
		// TODO Auto-generated method stub
        ProRelationDAO.updateProjectRelation(getProRelationBySpb(spb));
	}

	public ProRelation getProRelationBySpb(SPB spb) {
		String projectId = spb.getProjectId();
		String tdzh = spb.getTdzh();
		String fzrq = "";
		
		if (spb.getPzrq() != null) {
			fzrq = CommonUtil.formateDate(spb.getPzrq());
		} else if (spb.getShrq() != null) {
			fzrq = CommonUtil.formateDate(spb.getShrq());
		} else {
			fzrq = CommonUtil.getCurrStrDate();
		}
		
		String djh = spb.getDjh();
		Project project = projectDAO.getProject(projectId);
		String djlx = project.getDjlx();
		String ytdzh = spb.getZtdzh(); // 原证号

		String qlr = "";
		String yprojectId = "";
		String yqlr = "";// 原权利人
		
		// 逻辑： RF1 为 现qlr  RF2 为 原qlr  
		//		 无原土地证 yqlr为“”  ；有原土地证 yqlr为 证上的qlr  ；如果原证为 “JU” yqlr为 syqr
		if (ytdzh == null || ytdzh.equals("")) {
			qlr = spb.getRf1_dwmc();
		} else {
			/*
			 * if (djlx.equals("名称地址用途变更登记") || djlx.equals("换证与遗失补证") ||
			 * djlx.equals("更正登记")) { qlr = spb.getRf1_dwmc(); }else{ qlr =
			 * spb.getRf2_dwmc(); yqlr = spb.getRf1_dwmc(); }
			 */
			qlr = spb.getRf1_dwmc();
			// yprojectid
			ZS zs = ZSService.getZSByTdzh(ytdzh);
			if (zs != null) {
				if (ytdzh.indexOf("国用") > 0) {
					GYTDSYZ gytdsyz = (GYTDSYZ) zs;
					yprojectId = gytdsyz.getProjectId();
					if (yqlr.equals(""))
						yqlr = gytdsyz.getQlr();
				} else if (ytdzh.indexOf("集用") > 0) {
					JTTDSYZ jttdsyz = (JTTDSYZ) zs;
					yprojectId = jttdsyz.getProjectId();
					if (yqlr.equals(""))
						yqlr = jttdsyz.getQlr();
				} else if (ytdzh.indexOf("集有") > 0) {
					JTTDSUZ jttdsuz = (JTTDSUZ) zs;
					yprojectId = jttdsuz.getProjectId();
					if (yqlr.equals(""))
						yqlr = jttdsuz.getSyqr();	
				} else if (ytdzh.indexOf("他项") > 0) {
					TXQLZMS txqlzms = (TXQLZMS) zs;
					yprojectId = txqlzms.getProjectId();
					if (yqlr.equals(""))
						yqlr = txqlzms.getQlr();
				}else{
					GYTDSYZ gytdsyz = (GYTDSYZ) zs;
					yprojectId = gytdsyz.getProjectId();
					if (yqlr.equals(""))
						yqlr = gytdsyz.getQlr();
				}
			}
		}
		
		// projectid, tdzh, qlr, fzrq, yprojectid, ytdzh, yqlr, djlx, djh
		ProRelation proRelation = new ProRelation();
		proRelation.setProjectId(projectId);
		
		if (djlx.equals("注销登记")) {
			proRelation.setTdzh("注销" + ytdzh);
			proRelation.setQlr(project.getProjectName());
		} else {
			proRelation.setTdzh(tdzh);
			proRelation.setQlr(qlr);
		}
		
		proRelation.setFzrq(fzrq);
		proRelation.setYprojectId(yprojectId);
		proRelation.setYtdzh(ytdzh);
		proRelation.setYqlr(yqlr);
		proRelation.setDjlx(djlx);
		proRelation.setDjh(djh);
		return proRelation;
	}

	public ProRelation getProRelation(String projectId) {
		// TODO Auto-generated method stub
		return ProRelationDAO.getProRelation(projectId);
	}
	
	/**
	 * 获取项目关系
	 * @param proRelation
	 * @return ProRelation
	 */
	public ProRelation getProRelation(ProRelation proRelation) {
		// TODO Auto-generated method stub
		return ProRelationDAO.getProRelation(proRelation);
	}

	public List<ProRelation> getTDZProRelation(ProRelation proRelation) {
		// TODO Auto-generated method stub
		return ProRelationDAO.getTDZProRelation(proRelation);
	}
}
