package com.jsegov.tddj.services;

import com.jsegov.tddj.dao.JZSDAO;
import com.jsegov.tddj.services.interf.IJZSService;
import com.jsegov.tddj.vo.JZS;
import com.jsegov.tddj.vo.SQB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JzsService implements IJZSService{
	@Autowired
    JZSDAO jzsDAO;
	
	public JZS getJZS(String projectId) {
		// TODO Auto-generated method stub
		return jzsDAO.getJZS(projectId);
	}

	public void deleteJZS(String projectId) {
		// TODO Auto-generated method stub
		jzsDAO.deleteJZS(projectId);
	}

	public void insertJZS(JZS jzs) {
		// TODO Auto-generated method stub
		jzsDAO.insertJZS(jzs);
	}

	

	public void updateJZS(JZS jzs) {
		// TODO Auto-generated method stub
		jzsDAO.updateJZS(jzs);
	}

	public void updateJZS(SQB sqb) {
		// TODO Auto-generated method stub
		jzsDAO.updateJZS(getJzsbySqb(sqb));
	}

	private JZS getJzsbySqb(SQB sqb){
		JZS jzs = new JZS();
		//projectid, jzsbh, rf1_dwmc, zl, syqlx, qsxz, zdmj, djh, tdjb, yt, 
		jzs.setProjectId(sqb.getProjectId());
		jzs.setRf1_dwmc(sqb.getRf1_dwmc());
		jzs.setZl(sqb.getZl());
		jzs.setSyqlx(sqb.getSyqlx());
		jzs.setQsxz(sqb.getQsxz());
		if (sqb.getZdmj()!=null){
			jzs.setZdmj(Double.parseDouble(sqb.getZdmj()));
		}
		jzs.setDjh(sqb.getDjh());
		//jzs.setTdjb(sqb.getTddj());
		jzs.setYt(sqb.getYt());
		jzs.setQlr(sqb.getRf2_dwmc());
		jzs.setRf2_dwmc(sqb.getRf2_dwmc());
		//jzs.setJzrq(sqb.getSjrq());
		return jzs;
	}

	public void insertJZS(SQB sqb) {
		// TODO Auto-generated method stub
		jzsDAO.insertJZS(getJzsbySqb(sqb));
	}
}
