package com.jsegov.tddj.services;

import java.util.HashMap;
import java.util.List;

import com.jsegov.tddj.dao.JttdsyzDAO;
import com.jsegov.tddj.services.interf.IJttdsyzService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.SPB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JtTdsyzService implements IJttdsyzService {
	@Autowired
    JttdsyzDAO jttdsyzDAO;

	public void deleteJTTDSYZ(String projectId) {
		jttdsyzDAO.deleteJTTDSYZ(projectId);
	}

	public JTTDSYZ getJTTDSYZByTdzh(String tdzh) {
		// TODO Auto-generated method stub
		JTTDSYZ jttdsyz = new JTTDSYZ();
		jttdsyz.setTdzh(tdzh);
		return jttdsyzDAO.getJTTDSYZ(jttdsyz);
	}
	
	public JTTDSYZ getJTTDSYZ(String projectId) {
		return jttdsyzDAO.getJTTDSYZ(projectId);
	}

	public void insertJTTDSYZ(JTTDSYZ jttdsyz) {
		jttdsyzDAO.insertJTTDSYZ(jttdsyz);
	}

	public void updateJTTDSYZ(JTTDSYZ jttdsyz) {
		jttdsyzDAO.updateJTTDSYZ(jttdsyz);
	}

	public void insertJTTDSYZ(SPB spb) {
		// TODO Auto-generated method stub
		jttdsyzDAO.insertJTTDSYZ(getJTTDSYZBySPB(spb));
	}

	public void updateJTTDSYZ(SPB spb) {
		// TODO Auto-generated method stub
		jttdsyzDAO.updateJTTDSYZ(getJTTDSYZBySPB(spb));
	}
	
	public JTTDSYZ getJTTDSYZBySPB(SPB spb){
		//根据审批表生成集体土地使用证
		//字段对应---注意人方一及人方二
		JTTDSYZ jttdsyz = new JTTDSYZ();
		//projectid, tdzh, qlr, syqr, zl, djh, th, yt, qdjg, syqlx, 
		//zzrq, syqmj, dymj, ftmj, dwdm, fzrq, islogout, rmzf, olddata 
		jttdsyz.setProjectId(spb.getProjectId());
		jttdsyz.setTdzh(spb.getTdzh());
		//String sqlx = spb.getSqlx();
		/*if (!spb.getRf2_dwmc().equals("")){
			jttdsyz.setQlr(spb.getRf2_dwmc());
		}else{
			jttdsyz.setQlr(spb.getRf1_dwmc());
		}*/
		jttdsyz.setQlr(spb.getRf1_dwmc());
		//jttdsyz.setSyqr(syqr)
		jttdsyz.setZl(spb.getZl());
		jttdsyz.setDjh(spb.getDjh());
		jttdsyz.setTh(spb.getTh());
		jttdsyz.setYt(spb.getYt());
		jttdsyz.setQdjg(spb.getQdjg());
		jttdsyz.setSyqlx(spb.getSyqlx());
		jttdsyz.setZzrq(spb.getZzrq());
		jttdsyz.setSyqmj(spb.getSyqmj());
		jttdsyz.setDymj(spb.getDymj());
		jttdsyz.setFtmj(spb.getFtmj());
		jttdsyz.setDwdm(spb.getDwdm());
		String fzrq = "";
		if (spb.getPzrq() != null){
			fzrq = CommonUtil.formateDate(spb.getPzrq());
		}
//		else if(spb.getShrq() != null){
//			fzrq =CommonUtil.formateDate(spb.getShrq());
//		}
		else {
			fzrq =CommonUtil.getCurrStrDate();
		}
		jttdsyz.setFzrq(fzrq);
		jttdsyz.setIslogout(0);
		jttdsyz.setRmzf(spb.getRmzf());
		jttdsyz.setOlddata(0);
		return jttdsyz;
	}

	public List<Object> expJttdsyz(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		return jttdsyzDAO.expJttdsyz(map);
	}

	public List<Object> printZsQsb(HashMap<String, Object> map) {
		// TODO Auto-generated method stub
		return jttdsyzDAO.printZsQsb(map);
	}
}
