package com.jsegov.tddj.services;

import com.jsegov.tddj.dao.JttdsuzDAO;
import com.jsegov.tddj.services.interf.IJttdsuzService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.JTTDSUZ;
import com.jsegov.tddj.vo.SPB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JtTdsuzService implements IJttdsuzService{
	@Autowired
    JttdsuzDAO jttdsuzDAO;

	public void deleteJTTDSUZ(String projectId) {
		// TODO Auto-generated method stub
		jttdsuzDAO.deleteJTTDSUZ(projectId);
		
	}

	public JTTDSUZ getJTTDSUZ(String projectId) {
		// TODO Auto-generated method stub
		return (JTTDSUZ) jttdsuzDAO.getJTTDSUZ(projectId);
	}

	public void insertJTTDSUZ(JTTDSUZ jttdsuz) {
		// TODO Auto-generated method stub
		jttdsuzDAO.insertJTTDSUZ(jttdsuz);
	}
 
	public void updateJTTDSUZ(JTTDSUZ jttdsuz) {
		// TODO Auto-generated method stub
		jttdsuzDAO.updateJTTDSUZ(jttdsuz);
	}

	public void insertJTTDSUZ(SPB spb) {
		// TODO Auto-generated method stub
		jttdsuzDAO.insertJTTDSUZ(getJTTDSUZBySPB(spb));
	}
	
	public void updateJTTDSUZ(SPB spb) {
		// TODO Auto-generated method stub
		jttdsuzDAO.updateJTTDSUZ(getJTTDSUZBySPB(spb));
	}
	
	public JTTDSUZ getJTTDSUZByTdzh(String tdzh) {
		// TODO Auto-generated method stub
		return jttdsuzDAO.getJTTDSUZByTdzh(tdzh);
	}
    
	public JTTDSUZ getJTTDSUZBySPB(SPB spb){
		// PROJECTID,TDZH,SYQR,ZL,DJH,TH,TDZMJ,NYD,GD,YD,LD,MCD,QTNYD,JSYD,WLYD,
		// DWDM,FZRQ,ISLOGOUT,RMZF,OLDDATA,ISPRINTED,BZ,ZSNO
		JTTDSUZ jttdsuz = new JTTDSUZ();
		jttdsuz.setProjectId(spb.getProjectId());
		jttdsuz.setTdzh(spb.getTdzh());
		jttdsuz.setSyqr(spb.getRf1_dwmc());
		jttdsuz.setZl(spb.getZl());
		jttdsuz.setDjh(spb.getDjh());
		jttdsuz.setTh(spb.getTh());
		Double zdmj = 0.0;
		if (spb.getZdmj()!=null){
			try{
				zdmj = Double.parseDouble(spb.getZdmj());
			}catch(Exception e){
				System.out.println("ERROR----JttdsuzService.getJTTDSUZBySPB.Double.parseDouble(spb.getZdmj())");
			}
		}
		jttdsuz.setTdzmj(zdmj);
		jttdsuz.setGd(spb.getGd()== null?0:spb.getGd());
		jttdsuz.setLd(spb.getLd()== null?0:spb.getLd());
		jttdsuz.setYd(spb.getYd()== null?0:spb.getYd());
		jttdsuz.setMcd(spb.getCd()== null?0:spb.getCd());
		jttdsuz.setQtnyd(spb.getSyyd()== null?0:spb.getSyyd());
		
		jttdsuz.setNyd(jttdsuz.getGd()+jttdsuz.getLd()+jttdsuz.getYd()+jttdsuz.getMcd()+jttdsuz.getQtnyd());
		
		jttdsuz.setJsyd((spb.getSfyd()==null?0:spb.getSfyd())
						+(spb.getGkyd()==null?0:spb.getGkyd())
						+(spb.getZzyd()==null?0:spb.getZzyd())
						+(spb.getGgyd()==null?0:spb.getGgyd())
						+(spb.getTsyd()==null?0:spb.getTsyd())
						+(spb.getJtyd()==null?0:spb.getJtyd()));
		
		jttdsuz.setWlyd(spb.getQtyd()==null?0:spb.getQtyd());
		
		String fzrq = "";
		if (spb.getPzrq() != null){
			fzrq = CommonUtil.formateDate(spb.getPzrq());
		}
//		else if(spb.getShrq() != null){
//			fzrq =CommonUtil.formateDate(spb.getShrq());
//		}
		else {
			fzrq =CommonUtil.getCurrStrDate();
		}
		jttdsuz.setFzrq(fzrq);		
		jttdsuz.setDwdm(spb.getDwdm());
		jttdsuz.setIslogout(0);
		jttdsuz.setIsprinted(0);
		jttdsuz.setRmzf(spb.getRmzf());
		jttdsuz.setOlddata(0);
		return jttdsuz;
	}
}
